/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.console;

import de.rcenvironment.core.component.execution.api.ConsoleRow;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class DecoratedConsoleLabelProvider
extends DecoratingLabelProvider
implements ITableLabelProvider {
    private final Color red = Display.getDefault().getSystemColor(3);
    private final Color yellow = Display.getDefault().getSystemColor(8);
    private final Color black = Display.getDefault().getSystemColor(2);
    private final Color gray = Display.getDefault().getSystemColor(15);
    private ITableLabelProvider provider;
    private ILabelDecorator decorator;

    public DecoratedConsoleLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
        super(provider, decorator);
        this.provider = (ITableLabelProvider)provider;
        this.decorator = decorator;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image decorated;
        Image image = this.provider.getColumnImage(element, columnIndex);
        if (this.decorator != null && (decorated = this.decorator.decorateImage(image, element)) != null) {
            return decorated;
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        String decorated;
        String text = this.provider.getColumnText(element, columnIndex);
        if (this.decorator != null && (decorated = this.decorator.decorateText(text, element)) != null) {
            return decorated;
        }
        return text;
    }

    public Color getForeground(Object element) {
        Color result = null;
        if (element instanceof ConsoleRow) {
            ConsoleRow consoleRow = (ConsoleRow)element;
            switch (consoleRow.getType()) {
                case TOOL_ERROR: 
                case COMPONENT_ERROR: 
                case WORKFLOW_ERROR: {
                    result = this.red;
                    break;
                }
                case COMPONENT_WARN: {
                    result = this.yellow;
                    break;
                }
                case LIFE_CYCLE_EVENT: {
                    result = this.gray;
                    break;
                }
                default: {
                    result = this.black;
                }
            }
        }
        return result;
    }
}

