/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.utils.text.impl;

import de.rcenvironment.toolkit.utils.text.MultiLineOutput;
import java.util.Collections;
import java.util.List;

public class MultiLineOutputWrapper
implements MultiLineOutput {
    private List<String> lines;

    public MultiLineOutputWrapper(List<String> lines) {
        this.lines = lines;
    }

    @Override
    public List<String> getLines() {
        return Collections.unmodifiableList(this.lines);
    }

    @Override
    public String asMultilineString() {
        return this.asMultilineString("", "\n");
    }

    @Override
    public String asMultilineString(String indent, String lineSeparator) {
        return this.asMultilineString(null, indent, lineSeparator, null);
    }

    @Override
    public String asMultilineString(String intro, String indent, String lineSeparator, String outro) {
        StringBuilder buffer = new StringBuilder();
        if (intro != null) {
            buffer.append(intro);
            buffer.append(lineSeparator);
        }
        for (String line : this.lines) {
            buffer.append(indent);
            buffer.append(line);
            buffer.append(lineSeparator);
        }
        if (outro != null) {
            buffer.append(outro);
            buffer.append(lineSeparator);
        }
        if (buffer.length() >= lineSeparator.length()) {
            buffer.setLength(buffer.length() - lineSeparator.length());
        }
        return buffer.toString();
    }

    @Override
    public boolean hasContent() {
        return !this.lines.isEmpty();
    }
}

