/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.gui.properties.commands;

import de.rcenvironment.components.optimizer.gui.properties.commands.OptimizerDynamicEndpointCommandHelper;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.RemoveDynamicEndpointCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import java.util.HashMap;
import java.util.List;

public class OptimizerRemoveDynamicEndpointCommand
extends RemoveDynamicEndpointCommand {
    private static final String DESIGN_VARIABLE = "Design";

    public OptimizerRemoveDynamicEndpointCommand(EndpointType direction, List<String> names, String id, Refreshable ... refreshable) {
        super(direction, id, names, refreshable);
    }

    public void execute() {
        super.execute();
        for (String name : this.names) {
            EndpointDescription oldDescription = (EndpointDescription)this.oldDescriptions.get(name);
            WorkflowNode workflowNode = this.getWorkflowNode();
            switch (this.direction) {
                case INPUT: {
                    for (EndpointDescription variable : workflowNode.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
                        if (!variable.getDynamicEndpointIdentifier().equals(DESIGN_VARIABLE) || workflowNode.getInputDescriptionsManager().isValidEndpointName(OptimizerDynamicEndpointCommandHelper.createGradientChannelName(name, variable.getName()))) continue;
                        workflowNode.getInputDescriptionsManager().removeDynamicEndpointDescription(OptimizerDynamicEndpointCommandHelper.createGradientChannelName(name, variable.getName()));
                    }
                    OptimizerDynamicEndpointCommandHelper.removeUpperLowerBoundsEndpoints(oldDescription.getName(), oldDescription.getMetaData(), workflowNode);
                    break;
                }
                case OUTPUT: {
                    for (EndpointDescription function : workflowNode.getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
                        if (workflowNode.getInputDescriptionsManager().isValidEndpointName(OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), name))) continue;
                        workflowNode.getInputDescriptionsManager().removeDynamicEndpointDescription(OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), name));
                    }
                    if (this.getWorkflowNode().getOutputDescriptionsManager().getEndpointDescription(String.valueOf(name) + "_optimal") != null) {
                        this.getWorkflowNode().getOutputDescriptionsManager().removeDynamicEndpointDescription(String.valueOf(name) + "_optimal");
                    }
                    if (oldDescription.getMetaData().get("hasStartValue") == null && ((String)oldDescription.getMetaData().get("startValue")).isEmpty() || oldDescription.getMetaData().get("hasStartValue") != null && !Boolean.parseBoolean((String)oldDescription.getMetaData().get("hasStartValue"))) {
                        this.getWorkflowNode().getInputDescriptionsManager().removeDynamicEndpointDescription(String.valueOf(name) + " - start value");
                    }
                    if (oldDescription.getMetaData().get("useStep") != null && !((String)oldDescription.getMetaData().get("useStep")).isEmpty() && oldDescription.getMetaData().get("useUnifiedStep") != null && !Boolean.parseBoolean((String)oldDescription.getMetaData().get("useUnifiedStep"))) {
                        workflowNode.getInputDescriptionsManager().removeDynamicEndpointDescription(String.valueOf(name) + " - step value");
                    }
                    OptimizerDynamicEndpointCommandHelper.removeUpperLowerBoundsEndpoints(oldDescription.getName(), oldDescription.getMetaData(), workflowNode);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            if (this.refreshable == null) continue;
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }

    public void undo() {
        WorkflowNode workflowNode = this.getWorkflowNode();
        super.undo();
        for (String name : this.names) {
            EndpointDescription oldDescription = (EndpointDescription)this.oldDescriptions.get(name);
            switch (this.direction) {
                case INPUT: {
                    for (EndpointDescription variable : workflowNode.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
                        if (!variable.getDynamicEndpointIdentifier().equals(DESIGN_VARIABLE) || oldDescription.getMetaDataValue("hasGradient") == null || !Boolean.parseBoolean(oldDescription.getMetaDataValue("hasGradient")) || !workflowNode.getInputDescriptionsManager().isValidEndpointName(OptimizerDynamicEndpointCommandHelper.createGradientChannelName(name, variable.getName()))) continue;
                        HashMap<String, String> gradientData = new HashMap<String, String>();
                        for (String key : oldDescription.getMetaData().keySet()) {
                            if (!(key.equals("vectorSize") || key.equals("inputHandling_73b1056e") || key.equals("inputExecutionConstraint_4aae3eea"))) {
                                gradientData.put(key, "-");
                                continue;
                            }
                            gradientData.put(key, oldDescription.getMetaDataValue(key));
                        }
                        workflowNode.getInputDescriptionsManager().addDynamicEndpointDescription("gradients", OptimizerDynamicEndpointCommandHelper.createGradientChannelName(name, variable.getName()), variable.getDataType(), gradientData);
                    }
                    OptimizerDynamicEndpointCommandHelper.addLowerAndUpperBoundsEndpoints(oldDescription.getName(), oldDescription.getDataType(), oldDescription.getMetaData(), workflowNode);
                    break;
                }
                case OUTPUT: {
                    for (EndpointDescription function : workflowNode.getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
                        if (function.getMetaDataValue("hasGradient") == null || !Boolean.parseBoolean(function.getMetaDataValue("hasGradient"))) continue;
                        workflowNode.getInputDescriptionsManager().addDynamicEndpointDescription("gradients", OptimizerDynamicEndpointCommandHelper.createGradientChannelName(function.getName(), name), oldDescription.getDataType(), new HashMap());
                    }
                    this.getWorkflowNode().getOutputDescriptionsManager().addDynamicEndpointDescription("optima", String.valueOf(name) + "_optimal", oldDescription.getDataType(), oldDescription.getMetaData());
                    if (oldDescription.getMetaData().get("hasStartValue") == null && ((String)oldDescription.getMetaData().get("startValue")).isEmpty() || oldDescription.getMetaData().get("hasStartValue") != null && !Boolean.parseBoolean((String)oldDescription.getMetaData().get("hasStartValue"))) {
                        this.getWorkflowNode().getInputDescriptionsManager().addDynamicEndpointDescription("startvalues", String.valueOf(name) + " - start value", oldDescription.getDataType(), new HashMap());
                    }
                    if (oldDescription.getMetaData().get("useStep") != null && !((String)oldDescription.getMetaData().get("useStep")).isEmpty() && oldDescription.getMetaData().get("useUnifiedStep") != null && !Boolean.parseBoolean((String)oldDescription.getMetaData().get("useUnifiedStep"))) {
                        HashMap stepValueMetaData = new HashMap();
                        workflowNode.getInputDescriptionsManager().addDynamicEndpointDescription("startvalues", String.valueOf(name) + " - step value", oldDescription.getDataType(), stepValueMetaData);
                    }
                    OptimizerDynamicEndpointCommandHelper.addLowerAndUpperBoundsEndpoints(oldDescription.getName(), oldDescription.getDataType(), oldDescription.getMetaData(), workflowNode);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            if (this.refreshable == null) continue;
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }
}

