/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.eventlog.backends.api;

import de.rcenvironment.core.eventlog.backends.api.EventLogBackend;
import de.rcenvironment.core.eventlog.internal.EventLogEntryImpl;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;

public class EventLogPrintStreamBackend
extends EventLogBackend {
    private static final String FIELD_SEPARATOR = "   ";
    private static final String EVENT_ID_PADDING_LENGTH = "30";
    private final Writer writer;
    private boolean closeStream;

    public EventLogPrintStreamBackend(PrintStream printStream, boolean closeStream) {
        this.writer = new PrintWriter(printStream);
        this.closeStream = closeStream;
    }

    @Override
    public void close() throws IOException {
        if (this.closeStream) {
            this.writer.close();
        }
    }

    @Override
    public void append(EventLogEntryImpl logEntry) throws IOException {
        this.writer.write(String.format("%s   %-30s   %s%s", logEntry.getHumanReadableLocalTimestamp(), logEntry.getEventTypeId(), logEntry.getAttributeDataAsConpactJsonString(), System.lineSeparator()));
        this.writer.flush();
    }
}

