/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common;

import org.apache.commons.logging.LogFactory;

public enum OSFamily {
    Windows,
    Linux,
    Unspecified;


    public static OSFamily getLocal() {
        return InitializationHolder.LOCAL_OS_FAMILY;
    }

    public static boolean isWindows() {
        return InitializationHolder.LOCAL_OS_FAMILY == Windows;
    }

    public static boolean isLinux() {
        return InitializationHolder.LOCAL_OS_FAMILY == Linux;
    }

    private static class InitializationHolder {
        private static final OSFamily LOCAL_OS_FAMILY;

        static {
            String os = System.getProperty("os.name", "Linux");
            if (os.startsWith("Windows")) {
                LOCAL_OS_FAMILY = Windows;
            } else if (os.toLowerCase().indexOf("linux") >= 0) {
                LOCAL_OS_FAMILY = Linux;
            } else {
                LOCAL_OS_FAMILY = Unspecified;
                LogFactory.getLog(OSFamily.class).warn((Object)("Local operating system family not recognized, setting to " + (Object)((Object)LOCAL_OS_FAMILY)));
            }
        }

        private InitializationHolder() {
        }
    }
}

