/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.backend.metadata.derby.internal;

import de.rcenvironment.core.datamodel.api.TimelineIntervalType;
import de.rcenvironment.core.utils.common.StringUtils;

public abstract class DerbyDatabaseSetupSqlStatements {
    private static final String UNION = " UNION ";
    private static final String AND = " AND ";
    private static final String CLOB = " CLOB ";
    private static final String UNIQUE = "UNIQUE";
    private static final String STRING_PLACEHOLDER = "%s";
    private static final String WHERE = " WHERE ";
    private static final String EQUAL = " = ";
    private static final String APO = "'";
    private static final String COMMA = " , ";
    private static final String SELECT = " SELECT ";
    private static final String FROM = " FROM ";
    private static final String CREATE_TABLE = " CREATE TABLE ";
    private static final String PRIMARY_KEY = " PRIMARY KEY ";
    private static final String FOREIGN_KEY = " FOREIGN KEY ";
    private static final String REFERENCES = " REFERENCES ";
    private static final String INTEGER = " INTEGER ";
    private static final String BIGINT = " BIGINT ";
    private static final String CHAR_5 = " CHAR(5) ";
    private static final String CHAR_36 = " CHAR(36) ";
    private static final String VARCHAR_100 = " VARCHAR(100) ";
    private static final String VARCHAR_255 = " VARCHAR(255) ";
    private static final String AS_IDENTITY = " GENERATED ALWAYS AS IDENTITY ";
    private static final String TIMESTAMP = " TIMESTAMP ";
    private static final String VARCHAR = " VARCHAR ";
    private static final String NOT_NULL = " NOT NULL ";
    private static final String LONG_VARCHAR = " LONG VARCHAR ";
    private static final String DOT = ".";
    private static final String CREATE_VIEW = " CREATE VIEW ";
    private static final String AS = " AS ";
    private static final String BOOLEAN = " BOOLEAN ";

    protected static String getSqlTableDbVersionInfo() {
        String sql = " CREATE TABLE DB_VERSION_INFO(DB_VERSION VARCHAR(255)  NOT NULL )";
        return sql;
    }

    protected static String getSqlRelationWorkflowRunDataReference() {
        String sql = " CREATE TABLE REL_WFR_DR(WORKFLOW_RUN_ID BIGINT  NOT NULL  , DATA_REFERENCE_ID BIGINT  NOT NULL  ,  PRIMARY KEY (WORKFLOW_RUN_ID , DATA_REFERENCE_ID) ,  FOREIGN KEY (WORKFLOW_RUN_ID) REFERENCES WORKFLOW_RUN(WORKFLOW_RUN_ID) ,  FOREIGN KEY (DATA_REFERENCE_ID) REFERENCES DATA_REFERENCE(DATA_REFERENCE_ID))";
        return sql;
    }

    protected static String getSqlRelationComponentInstanceDataReference() {
        String sql = " CREATE TABLE REL_CI_DR(COMPONENT_INSTANCE_ID BIGINT  NOT NULL  , DATA_REFERENCE_ID BIGINT  NOT NULL  ,  PRIMARY KEY (COMPONENT_INSTANCE_ID , DATA_REFERENCE_ID) ,  FOREIGN KEY (COMPONENT_INSTANCE_ID) REFERENCES COMPONENT_INSTANCE(COMPONENT_INSTANCE_ID) ,  FOREIGN KEY (DATA_REFERENCE_ID) REFERENCES DATA_REFERENCE(DATA_REFERENCE_ID))";
        return sql;
    }

    protected static String getSqlRelationDataReferenceBinaryReference() {
        String sql = " CREATE TABLE REL_DR_BR(BINARY_REFERENCE_ID BIGINT  NOT NULL  , DATA_REFERENCE_ID BIGINT  NOT NULL  ,  PRIMARY KEY (BINARY_REFERENCE_ID , DATA_REFERENCE_ID) ,  FOREIGN KEY (BINARY_REFERENCE_ID) REFERENCES BINARY_REFERENCE(BINARY_REFERENCE_ID) ,  FOREIGN KEY (DATA_REFERENCE_ID) REFERENCES DATA_REFERENCE(DATA_REFERENCE_ID))";
        return sql;
    }

    protected static String getSqlRelationComponentRunDataReference() {
        String sql = " CREATE TABLE REL_CR_DR(COMPONENT_RUN_ID BIGINT  NOT NULL  , DATA_REFERENCE_ID BIGINT  NOT NULL  ,  PRIMARY KEY (COMPONENT_RUN_ID , DATA_REFERENCE_ID) ,  FOREIGN KEY (COMPONENT_RUN_ID) REFERENCES COMPONENT_RUN(COMPONENT_RUN_ID) ,  FOREIGN KEY (DATA_REFERENCE_ID) REFERENCES DATA_REFERENCE(DATA_REFERENCE_ID))";
        return sql;
    }

    protected static String getSqlTableBinaryReference() {
        String sql = " CREATE TABLE BINARY_REFERENCE(BINARY_REFERENCE_ID BIGINT  NOT NULL  GENERATED ALWAYS AS IDENTITY  , BINARY_REFERENCE_KEY CHAR(36)  NOT NULL  , COMPRESSION VARCHAR(255)  NOT NULL  , REVISION CHAR(5)  NOT NULL  ,  PRIMARY KEY (BINARY_REFERENCE_ID))";
        return sql;
    }

    protected static String getSqlTableDataReference() {
        String sql = " CREATE TABLE DATA_REFERENCE(DATA_REFERENCE_ID BIGINT  NOT NULL  GENERATED ALWAYS AS IDENTITY  , DATA_REFERENCE_KEY CHAR(36) UNIQUE , NODE_ID VARCHAR(100)  NOT NULL  ,  PRIMARY KEY (DATA_REFERENCE_ID))";
        return sql;
    }

    protected static String getSqlTableEndpointData() {
        String sql = " CREATE TABLE ENDPOINT_DATA(COMPONENT_RUN_ID BIGINT  NOT NULL  , ENDPOINT_INSTANCE_ID BIGINT  NOT NULL  , TYPED_DATUM_ID BIGINT  NOT NULL  , COUNTER INTEGER  NOT NULL  ,  PRIMARY KEY (COMPONENT_RUN_ID , TYPED_DATUM_ID , ENDPOINT_INSTANCE_ID , COUNTER) ,  FOREIGN KEY (COMPONENT_RUN_ID) REFERENCES COMPONENT_RUN(COMPONENT_RUN_ID) ,  FOREIGN KEY (ENDPOINT_INSTANCE_ID) REFERENCES ENDPOINT_INSTANCE(ENDPOINT_INSTANCE_ID) ,  FOREIGN KEY (TYPED_DATUM_ID) REFERENCES TYPED_DATUM(TYPED_DATUM_ID))";
        return sql;
    }

    protected static String getSqlTableEndpointInstance() {
        String sql = " CREATE TABLE ENDPOINT_INSTANCE(ENDPOINT_INSTANCE_ID BIGINT  NOT NULL  GENERATED ALWAYS AS IDENTITY  , COMPONENT_INSTANCE_ID BIGINT  NOT NULL  , NAME VARCHAR(255)  NOT NULL  , TYPE VARCHAR(255)  NOT NULL  ,  PRIMARY KEY (ENDPOINT_INSTANCE_ID) ,  FOREIGN KEY (COMPONENT_INSTANCE_ID) REFERENCES COMPONENT_INSTANCE(COMPONENT_INSTANCE_ID))";
        return sql;
    }

    protected static String getSqlTableEndpointInstanceProperties() {
        String sql = " CREATE TABLE ENDPOINT_INSTANCE_PROPERTIES(ENDPOINT_INSTANCE_ID BIGINT  NOT NULL  , KEY_ VARCHAR(255)  NOT NULL  , VALUE LONG VARCHAR  ,  PRIMARY KEY (ENDPOINT_INSTANCE_ID , KEY_) ,  FOREIGN KEY (ENDPOINT_INSTANCE_ID) REFERENCES ENDPOINT_INSTANCE(ENDPOINT_INSTANCE_ID))";
        return sql;
    }

    protected static String getSqlTableTypedDatum() {
        String sql = " CREATE TABLE TYPED_DATUM(TYPED_DATUM_ID BIGINT  NOT NULL  GENERATED ALWAYS AS IDENTITY  , TYPE VARCHAR(255)  NOT NULL  , VALUE LONG VARCHAR  , BIG_VALUE CLOB  ,  PRIMARY KEY (TYPED_DATUM_ID))";
        return sql;
    }

    protected static String getSqlTableComponentRunProperties() {
        String sql = " CREATE TABLE COMPONENT_RUN_PROPERTIES(COMPONENT_RUN_ID BIGINT  NOT NULL  , KEY_ VARCHAR(255)  NOT NULL  , VALUE LONG VARCHAR  ,  PRIMARY KEY (COMPONENT_RUN_ID , KEY_) ,  FOREIGN KEY (COMPONENT_RUN_ID) REFERENCES COMPONENT_RUN(COMPONENT_RUN_ID))";
        return sql;
    }

    protected static String getSqlTableComponentRun() {
        String sql = " CREATE TABLE COMPONENT_RUN(COMPONENT_RUN_ID BIGINT  NOT NULL  GENERATED ALWAYS AS IDENTITY  , COMPONENT_INSTANCE_ID BIGINT  NOT NULL  , COMPONENT_RUN_FINAL_STATE VARCHAR(255)  , NODE_ID VARCHAR(100)  NOT NULL  , COUNTER INTEGER  NOT NULL  , HISTORY_DATA_ITEM LONG VARCHAR  , REFERENCES_DELETED BOOLEAN  ,  PRIMARY KEY (COMPONENT_RUN_ID) ,  FOREIGN KEY (COMPONENT_INSTANCE_ID) REFERENCES COMPONENT_INSTANCE(COMPONENT_INSTANCE_ID))";
        return sql;
    }

    protected static String getSqlTableComponentInstanceProperties() {
        String sql = " CREATE TABLE COMPONENT_INSTANCE_PROPERTIES(COMPONENT_INSTANCE_ID BIGINT  NOT NULL  , KEY_ VARCHAR(255)  NOT NULL  , VALUE LONG VARCHAR  ,  PRIMARY KEY (COMPONENT_INSTANCE_ID , KEY_) ,  FOREIGN KEY (COMPONENT_INSTANCE_ID) REFERENCES COMPONENT_INSTANCE(COMPONENT_INSTANCE_ID))";
        return sql;
    }

    protected static String getSqlTableComponentInstance() {
        String sql = " CREATE TABLE COMPONENT_INSTANCE(COMPONENT_INSTANCE_ID BIGINT  NOT NULL  GENERATED ALWAYS AS IDENTITY  , WORKFLOW_RUN_ID BIGINT  NOT NULL  , COMPONENT_ID VARCHAR(255)  NOT NULL  , COMPONENT_INSTANCE_NAME VARCHAR(255)  NOT NULL  , FINAL_STATE VARCHAR(255)  ,  PRIMARY KEY (COMPONENT_INSTANCE_ID) ,  FOREIGN KEY (WORKFLOW_RUN_ID) REFERENCES WORKFLOW_RUN(WORKFLOW_RUN_ID))";
        return sql;
    }

    protected static String getSqlTableTimelineInterval() {
        String sql = " CREATE TABLE TIMELINE_INTERVAL(TIMELINE_INTERVAL_ID BIGINT  NOT NULL  GENERATED ALWAYS AS IDENTITY  , WORKFLOW_RUN_ID BIGINT  NOT NULL  , TYPE VARCHAR(255)  NOT NULL  , STARTTIME TIMESTAMP  NOT NULL  , ENDTIME TIMESTAMP  , COMPONENT_RUN_ID BIGINT  ,  PRIMARY KEY (TIMELINE_INTERVAL_ID) ,  FOREIGN KEY (WORKFLOW_RUN_ID) REFERENCES WORKFLOW_RUN(WORKFLOW_RUN_ID) ,  FOREIGN KEY (COMPONENT_RUN_ID) REFERENCES COMPONENT_RUN(COMPONENT_RUN_ID))";
        return sql;
    }

    protected static String getSqlTableWorkflowRunProperties() {
        String sql = " CREATE TABLE WORKFLOW_RUN_PROPERTIES(WORKFLOW_RUN_ID BIGINT  NOT NULL  , KEY_ VARCHAR(255)  NOT NULL  , VALUE LONG VARCHAR  ,  PRIMARY KEY (WORKFLOW_RUN_ID , KEY_) ,  FOREIGN KEY (WORKFLOW_RUN_ID) REFERENCES WORKFLOW_RUN(WORKFLOW_RUN_ID))";
        return sql;
    }

    protected static String getSqlTableWorkflowRun() {
        String sql = " CREATE TABLE WORKFLOW_RUN(WORKFLOW_RUN_ID BIGINT  NOT NULL  GENERATED ALWAYS AS IDENTITY  , NAME VARCHAR(255)  NOT NULL  , CONTROLLER_NODE_ID VARCHAR(100)  NOT NULL  , DATAMANAGEMENT_NODE_ID VARCHAR(100)  NOT NULL  , FINAL_STATE VARCHAR(255)  , TIMELINE_DATA_ITEM LONG VARCHAR  , WORKFLOW_FILE_REFERENCE LONG VARCHAR  , TO_BE_DELETED INTEGER  ,  PRIMARY KEY (WORKFLOW_RUN_ID))";
        return sql;
    }

    protected static String getSqlViewEndpointData() {
        String sql = " CREATE VIEW V_ENDPOINT_DATA AS  SELECT COMPONENT_INSTANCE.WORKFLOW_RUN_ID , ENDPOINT_DATA.COMPONENT_RUN_ID , ENDPOINT_DATA.COUNTER , ENDPOINT_INSTANCE.ENDPOINT_INSTANCE_ID , ENDPOINT_INSTANCE.NAME , ENDPOINT_INSTANCE.TYPE AS ENDPOINT_TYPE , TYPED_DATUM.TYPE AS DATUM_TYPE , TYPED_DATUM.VALUE , TYPED_DATUM.BIG_VALUE FROM COMPONENT_INSTANCE , COMPONENT_RUN , ENDPOINT_DATA , ENDPOINT_INSTANCE , TYPED_DATUM WHERE COMPONENT_INSTANCE.COMPONENT_INSTANCE_ID = COMPONENT_RUN.COMPONENT_INSTANCE_ID AND COMPONENT_RUN.COMPONENT_RUN_ID = ENDPOINT_DATA.COMPONENT_RUN_ID AND ENDPOINT_INSTANCE.ENDPOINT_INSTANCE_ID = ENDPOINT_DATA.ENDPOINT_INSTANCE_ID AND TYPED_DATUM.TYPED_DATUM_ID = ENDPOINT_DATA.TYPED_DATUM_ID";
        return sql;
    }

    protected static String getSqlViewEndpointInstanceProperties() {
        String sql = " CREATE VIEW V_ENDPOINT_INSTANCE_PROPERTIES AS  SELECT COMPONENT_INSTANCE.WORKFLOW_RUN_ID , ENDPOINT_INSTANCE.ENDPOINT_INSTANCE_ID , ENDPOINT_INSTANCE.NAME , ENDPOINT_INSTANCE.TYPE AS ENDPOINT_TYPE , ENDPOINT_INSTANCE_PROPERTIES.KEY_ , ENDPOINT_INSTANCE_PROPERTIES.VALUE FROM COMPONENT_INSTANCE , ENDPOINT_INSTANCE , ENDPOINT_INSTANCE_PROPERTIES WHERE COMPONENT_INSTANCE.COMPONENT_INSTANCE_ID = ENDPOINT_INSTANCE.COMPONENT_INSTANCE_ID AND ENDPOINT_INSTANCE.ENDPOINT_INSTANCE_ID = ENDPOINT_INSTANCE_PROPERTIES.ENDPOINT_INSTANCE_ID";
        return sql;
    }

    protected static String getSqlViewWorkflowRunComponentRun() {
        String sql = " CREATE VIEW V_WORKFLOW_COMPONENTRUN AS  SELECT COMPONENT_INSTANCE.WORKFLOW_RUN_ID , COMPONENT_RUN.COMPONENT_RUN_ID FROM COMPONENT_INSTANCE , COMPONENT_RUN WHERE COMPONENT_INSTANCE.COMPONENT_INSTANCE_ID = COMPONENT_RUN.COMPONENT_INSTANCE_ID";
        return sql;
    }

    protected static String getSqlViewComponentRuns() {
        String sql = StringUtils.format((String)" CREATE VIEW V_COMPONENT_RUNS AS  SELECT COMPONENT_INSTANCE.WORKFLOW_RUN_ID , COMPONENT_INSTANCE.COMPONENT_ID , COMPONENT_INSTANCE.COMPONENT_INSTANCE_NAME , COMPONENT_INSTANCE.FINAL_STATE , COMPONENT_RUN.COMPONENT_RUN_ID , COMPONENT_RUN.NODE_ID , COMPONENT_RUN.COUNTER , COMPONENT_RUN.REFERENCES_DELETED , COMPONENT_RUN.HISTORY_DATA_ITEM , COMPONENT_RUN.COMPONENT_RUN_FINAL_STATE , TIMELINE_INTERVAL.STARTTIME , TIMELINE_INTERVAL.ENDTIME FROM COMPONENT_INSTANCE , COMPONENT_RUN , TIMELINE_INTERVAL WHERE COMPONENT_RUN.COMPONENT_INSTANCE_ID = COMPONENT_INSTANCE.COMPONENT_INSTANCE_ID AND TIMELINE_INTERVAL.COMPONENT_RUN_ID = COMPONENT_RUN.COMPONENT_RUN_ID AND TIMELINE_INTERVAL.TYPE = '%s'", (Object[])new Object[]{TimelineIntervalType.COMPONENT_RUN.toString()});
        return sql;
    }

    protected static String getSqlViewComponentTimelineIntervals() {
        String sql = " CREATE VIEW V_COMPONENT_TIMELINE_INTERVALS AS  SELECT WORKFLOW_RUN.WORKFLOW_RUN_ID , TIMELINE_INTERVAL.STARTTIME , TIMELINE_INTERVAL.ENDTIME , TIMELINE_INTERVAL.TYPE , COMPONENT_INSTANCE.COMPONENT_ID , COMPONENT_INSTANCE.COMPONENT_INSTANCE_NAME FROM WORKFLOW_RUN , TIMELINE_INTERVAL , COMPONENT_RUN , COMPONENT_INSTANCE WHERE TIMELINE_INTERVAL.WORKFLOW_RUN_ID = WORKFLOW_RUN.WORKFLOW_RUN_ID AND COMPONENT_RUN.COMPONENT_RUN_ID = TIMELINE_INTERVAL.COMPONENT_RUN_ID AND COMPONENT_RUN.COMPONENT_INSTANCE_ID = COMPONENT_INSTANCE.COMPONENT_INSTANCE_ID";
        return sql;
    }

    protected static String getSqlViewWorkflowRunDataReference() {
        String sql = " CREATE VIEW V_WORKFLOWRUN_DATAREFERENCE AS  SELECT COMPONENT_INSTANCE.WORKFLOW_RUN_ID , REL_CR_DR.DATA_REFERENCE_ID FROM REL_CR_DR , COMPONENT_RUN , COMPONENT_INSTANCE WHERE COMPONENT_RUN.COMPONENT_RUN_ID = REL_CR_DR.COMPONENT_RUN_ID AND COMPONENT_INSTANCE.COMPONENT_INSTANCE_ID = COMPONENT_RUN.COMPONENT_INSTANCE_ID UNION  SELECT COMPONENT_INSTANCE.WORKFLOW_RUN_ID , REL_CI_DR.DATA_REFERENCE_ID FROM REL_CI_DR , COMPONENT_INSTANCE WHERE COMPONENT_INSTANCE.COMPONENT_INSTANCE_ID = REL_CI_DR.COMPONENT_INSTANCE_ID UNION  SELECT REL_WFR_DR.WORKFLOW_RUN_ID , REL_WFR_DR.DATA_REFERENCE_ID FROM REL_WFR_DR";
        return sql;
    }

    protected static String getSqlViewWorkflowRunTypedDatum() {
        String sql = " CREATE VIEW V_WORKFLOWRUN_TYPEDDATUM AS  SELECT COMPONENT_INSTANCE.WORKFLOW_RUN_ID , ENDPOINT_DATA.TYPED_DATUM_ID FROM ENDPOINT_DATA , COMPONENT_RUN , COMPONENT_INSTANCE WHERE COMPONENT_RUN.COMPONENT_RUN_ID = ENDPOINT_DATA.COMPONENT_RUN_ID AND COMPONENT_INSTANCE.COMPONENT_INSTANCE_ID = COMPONENT_RUN.COMPONENT_INSTANCE_ID";
        return sql;
    }
}

