/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.toolintegration;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.component.api.ComponentGroupPathRules;
import de.rcenvironment.core.component.api.ComponentIdRules;
import de.rcenvironment.core.component.integration.IntegrationContext;
import de.rcenvironment.core.component.integration.IntegrationContextType;
import de.rcenvironment.core.component.integration.ToolIntegrationConstants;
import de.rcenvironment.core.gui.integration.common.IntegrationHelper;
import de.rcenvironment.core.gui.integration.toolintegration.Messages;
import de.rcenvironment.core.gui.integration.toolintegration.TemplateListContentProvider;
import de.rcenvironment.core.gui.integration.toolintegration.TemplateListData;
import de.rcenvironment.core.gui.integration.toolintegration.TemplateListItem;
import de.rcenvironment.core.gui.integration.toolintegration.ToolIntegrationDoubleClickListener;
import de.rcenvironment.core.gui.integration.toolintegration.ToolIntegrationWizard;
import de.rcenvironment.core.gui.integration.toolintegration.api.ToolIntegrationWizardPage;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class ChooseConfigurationPage
extends ToolIntegrationWizardPage {
    private static final Log LOGGER = LogFactory.getLog(ChooseConfigurationPage.class);
    private static final String JSON_SUFFIX = ".json";
    private Text textChosenConfig;
    private List toolList;
    private ListViewer templateListViewer;
    private final ToolIntegrationWizard wizard;
    private final boolean isEditWizard;
    private Button newIntegrationButton = null;
    private Button loadInactiveConfigurationButton;
    private Button loadTemplateButton;
    private final ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
    private final Collection<IntegrationContext> allIntegrationContexts;
    private final Map<String, Map<String, Object>> allConfigurations;
    private Map<String, String> displayedToolNamesToToolNames;
    private IntegrationHelper integrationHelper = new IntegrationHelper();

    protected static ChooseConfigurationPage createWithoutPreselectedTool(String pageName, Collection<IntegrationContext> allIntegrationContexts, ToolIntegrationWizard wizard, String type) {
        return new ChooseConfigurationPage(pageName, allIntegrationContexts, wizard, type);
    }

    protected ChooseConfigurationPage(String pageName, Collection<IntegrationContext> allIntegrationContexts, ToolIntegrationWizard wizard, String type) {
        super(pageName);
        this.setTitle(pageName);
        if ("NEW_COMMON".equals(type)) {
            this.isEditWizard = false;
        } else if ("EDIT_COMMON".equals(type)) {
            this.isEditWizard = true;
        } else {
            throw new IllegalArgumentException(StringUtils.format((String)"Unexpected wizard type '%s'", (Object[])new Object[]{type}));
        }
        if (this.isNewWizard()) {
            this.setDescription(Messages.newIntegrationDescription);
        } else {
            this.setDescription(Messages.editIntegrationDescription);
        }
        this.wizard = wizard;
        this.allIntegrationContexts = allIntegrationContexts;
        this.allConfigurations = new TreeMap<String, Map<String, Object>>();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        GridData containerData = new GridData(1808);
        container.setLayoutData((Object)containerData);
        if (this.isNewWizard()) {
            this.createNewIntegrationPart(container);
            this.createTemplatePart(container);
            this.createInactivePart(container);
        } else {
            new Label(container, 0).setText(Messages.chooseConfigToEdit);
        }
        Map<String, String> configs = this.readExistingConfigurations();
        ListViewer toolListViewer = new ListViewer(container, 2052);
        toolListViewer.addDoubleClickListener((IDoubleClickListener)new ToolIntegrationDoubleClickListener(this));
        this.toolList = toolListViewer.getList();
        GridData toolListData = new GridData(1808);
        this.toolList.setLayoutData((Object)toolListData);
        this.displayedToolNamesToToolNames = new TreeMap<String, String>();
        for (String toolName : configs.keySet()) {
            String displayedToolName = this.createDisplayedToolName(toolName);
            this.displayedToolNamesToToolNames.put(displayedToolName, toolName);
            this.toolList.add(displayedToolName);
        }
        if (this.toolList.getItemCount() == 0) {
            this.toolList.setEnabled(false);
        }
        if (this.loadInactiveConfigurationButton != null && this.toolList.getItemCount() == 0) {
            this.loadInactiveConfigurationButton.setEnabled(false);
        }
        this.toolList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (ChooseConfigurationPage.this.toolList.isEnabled()) {
                    int[] selectedItems = ChooseConfigurationPage.this.toolList.getSelectionIndices();
                    ChooseConfigurationPage.this.textChosenConfig.setText("");
                    if (selectedItems.length > 0) {
                        String toolName = ChooseConfigurationPage.this.getToolNameFromDisplayedToolName(ChooseConfigurationPage.this.toolList.getItem(selectedItems[0]));
                        ChooseConfigurationPage.this.loadToolConfigurationIntoWizard(toolName);
                    }
                    ChooseConfigurationPage.this.setPageComplete(true);
                    if (ChooseConfigurationPage.this.isEditWizard()) {
                        ToolIntegrationWizard wiz = (ToolIntegrationWizard)ChooseConfigurationPage.this.getWizard();
                        wiz.updateAllPages();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        if (this.isEditWizard()) {
            Button loadConfigButton = new Button(container, 8);
            loadConfigButton.setText(Messages.loadConfigurationButton);
            loadConfigButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    FileDialog dialog = new FileDialog(ChooseConfigurationPage.this.getShell());
                    dialog.setFilterExtensions(new String[]{"*.json"});
                    String file = dialog.open();
                    if (file != null) {
                        File configJson = new File(file);
                        ChooseConfigurationPage.this.loadConfigurationFromFile(configJson);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    this.widgetSelected(arg0);
                }
            });
        }
        Composite chosenComposite = new Composite(container, 0);
        chosenComposite.setLayout((Layout)new GridLayout(2, false));
        chosenComposite.setLayoutData((Object)new GridData(768));
        new Label(chosenComposite, 0).setText(Messages.selectedConfig);
        this.textChosenConfig = new Text(chosenComposite, 2048);
        this.textChosenConfig.setEditable(false);
        this.textChosenConfig.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ChooseConfigurationPage.this.setPageComplete(ChooseConfigurationPage.this.textChosenConfig.getText() != null && !ChooseConfigurationPage.this.textChosenConfig.getText().equals(""));
            }
        });
        this.textChosenConfig.setLayoutData((Object)new GridData(768));
        this.textChosenConfig.setBackground(Display.getDefault().getSystemColor(1));
        if (this.newIntegrationButton != null) {
            this.newIntegrationButton.setSelection(true);
            this.toolList.setEnabled(false);
            this.textChosenConfig.setEnabled(false);
            this.toolList.setBackground(Display.getDefault().getSystemColor(19));
        }
        this.setControl((Control)container);
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        if (this.isNewWizard()) {
            helpSystem.setHelp(this.getControl(), "de.rcenvironment.core.gui.wizard.toolintegration.integration_chooseconfig");
        } else {
            helpSystem.setHelp(this.getControl(), "de.rcenvironment.core.gui.wizard.toolintegration.integration_editconfig");
        }
    }

    public void selectToolConfiguration(String toolname) {
        if (this.loadToolConfigurationIntoWizard(toolname)) {
            this.selectTool(toolname);
        }
    }

    private boolean loadToolConfigurationIntoWizard(String toolName) {
        Map<String, String> configs = this.readExistingConfigurations();
        if (configs.get(toolName) != null) {
            File configJson = new File(configs.get(toolName));
            this.loadConfigurationFromFile(configJson);
            return true;
        }
        LOGGER.error((Object)StringUtils.format((String)"Could not find the configuration for tool %s in the profile directory. It may have been deleted.", (Object[])new Object[]{toolName}));
        return false;
    }

    private String getToolNameFromDisplayedToolName(String displayedToolName) {
        return this.displayedToolNamesToToolNames.get(displayedToolName);
    }

    private void selectTool(String toolname) {
        int toolIndex = this.getToolIndexByToolname(toolname);
        this.toolList.setSelection(toolIndex);
    }

    private int getToolIndexByToolname(String toolname) {
        int i = 0;
        while (i < this.toolList.getItemCount()) {
            String currentDisplayedName = this.toolList.getItem(i);
            String currentToolName = this.getToolNameFromDisplayedToolName(currentDisplayedName);
            if (currentToolName.equals(toolname)) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Toolname " + toolname + " not found in toollist");
    }

    private void createInactivePart(Composite container) {
        this.loadInactiveConfigurationButton = new Button(container, 16);
        this.loadInactiveConfigurationButton.setText(Messages.chooseInactiveButton);
        this.loadInactiveConfigurationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (ChooseConfigurationPage.this.loadInactiveConfigurationButton.getSelection()) {
                    ChooseConfigurationPage.this.setPageComplete(false);
                    ChooseConfigurationPage.this.toolList.setEnabled(true);
                    ChooseConfigurationPage.this.textChosenConfig.setEnabled(true);
                    ChooseConfigurationPage.this.toolList.setBackground(Display.getDefault().getSystemColor(25));
                    ChooseConfigurationPage.this.toolList.deselectAll();
                    ChooseConfigurationPage.this.templateListViewer.getControl().setEnabled(false);
                    ChooseConfigurationPage.this.templateListViewer.getControl().setBackground(Display.getDefault().getSystemColor(19));
                    ChooseConfigurationPage.this.templateListViewer.getList().deselectAll();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
    }

    private void createTemplatePart(Composite container) {
        this.loadTemplateButton = new Button(container, 16);
        this.loadTemplateButton.setText(Messages.newConfigurationFromTemplateButton);
        this.loadTemplateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (ChooseConfigurationPage.this.loadTemplateButton.getSelection()) {
                    ChooseConfigurationPage.this.setPageComplete(false);
                    ChooseConfigurationPage.this.templateListViewer.getControl().setEnabled(true);
                    ChooseConfigurationPage.this.textChosenConfig.setEnabled(true);
                    ChooseConfigurationPage.this.templateListViewer.getControl().setBackground(Display.getDefault().getSystemColor(25));
                    ChooseConfigurationPage.this.templateListViewer.getList().deselectAll();
                    ChooseConfigurationPage.this.toolList.setEnabled(false);
                    ChooseConfigurationPage.this.textChosenConfig.setEnabled(false);
                    ChooseConfigurationPage.this.toolList.setBackground(Display.getDefault().getSystemColor(19));
                    ChooseConfigurationPage.this.toolList.deselectAll();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        final Map<String, Map<String, Object>> templates = this.readTemplates();
        TemplateListContentProvider templateListContentProvider = new TemplateListContentProvider();
        TemplateListData templateListData = new TemplateListData();
        this.templateListViewer = new ListViewer(container, 2052);
        this.templateListViewer.setContentProvider((IContentProvider)templateListContentProvider);
        this.templateListViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((TemplateListItem)e1).toString().compareTo(((TemplateListItem)e2).toString());
            }
        });
        this.templateListViewer.getControl().setEnabled(false);
        this.templateListViewer.getControl().setBackground(Display.getDefault().getSystemColor(19));
        GridData templateListGridData = new GridData(1808);
        this.templateListViewer.getControl().setLayoutData((Object)templateListGridData);
        for (String templateFileName : templates.keySet()) {
            String integrationType = (String)templates.get(templateFileName).get("integrationType");
            if (integrationType == null) {
                integrationType = IntegrationContextType.COMMON.toString();
            }
            TemplateListItem item = new TemplateListItem(templateFileName, integrationType);
            String templateDisplayName = (String)templates.get(templateFileName).get("templateName");
            if (templateDisplayName != null) {
                item.setDisplayName(templateDisplayName);
            }
            templateListData.add(item);
        }
        this.templateListViewer.setInput((Object)templateListData);
        if (this.loadTemplateButton != null && templateListData.getItems().isEmpty()) {
            this.loadTemplateButton.setEnabled(false);
            this.templateListViewer.getControl().setEnabled(false);
        }
        this.templateListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                if (ChooseConfigurationPage.this.templateListViewer.getControl().isEnabled()) {
                    IStructuredSelection selection = (IStructuredSelection)ChooseConfigurationPage.this.templateListViewer.getSelection();
                    if (!selection.isEmpty()) {
                        TemplateListItem item = (TemplateListItem)selection.getFirstElement();
                        for (Map.Entry e : templates.entrySet()) {
                            if (item == null || !((String)e.getKey()).equals(item.getFilename())) continue;
                            ChooseConfigurationPage.this.wizard.removeAdditionalPages();
                            ChooseConfigurationPage.this.wizard.setPreviousConfiguration((Map)e.getValue(), new File((String)e.getKey()));
                            if ((String)((Map)e.getValue()).get("integrationType") != null) {
                                ((ToolIntegrationWizard)ChooseConfigurationPage.this.getWizard()).setIntegrationType((String)((Map)e.getValue()).get("integrationType"), true);
                                ChooseConfigurationPage.this.wizard.setAdditionalPages((String)((Map)e.getValue()).get("integrationType"));
                            } else {
                                ((ToolIntegrationWizard)ChooseConfigurationPage.this.getWizard()).setIntegrationType(IntegrationContextType.COMMON.toString(), true);
                            }
                            if (!ChooseConfigurationPage.this.wizard.getConfigurationMap().containsKey("templateName")) continue;
                            ChooseConfigurationPage.this.wizard.getConfigurationMap().remove("templateName");
                        }
                    }
                    ChooseConfigurationPage.this.setPageComplete(true);
                }
            }
        });
        this.templateListViewer.addDoubleClickListener((IDoubleClickListener)new ToolIntegrationDoubleClickListener(this));
    }

    private Map<String, Map<String, Object>> readTemplates() {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (IntegrationContext context : this.allIntegrationContexts) {
            File[] readOnlyList;
            File templateRootPath = new File(String.valueOf(context.getRootPathToToolIntegrationDirectory()) + File.separator + ToolIntegrationConstants.TEMPLATE_PATH);
            if (!templateRootPath.exists()) {
                templateRootPath.mkdirs();
            }
            this.readTemplateDir(result, templateRootPath);
            File[] fileArray = readOnlyList = context.getReadOnlyPathsList();
            int n = readOnlyList.length;
            int n2 = 0;
            while (n2 < n) {
                File dir = fileArray[n2];
                this.readTemplateDir(result, new File(String.valueOf(dir.getAbsolutePath()) + File.separator + ToolIntegrationConstants.TEMPLATE_PATH));
                ++n2;
            }
        }
        return result;
    }

    private void readTemplateDir(Map<String, Map<String, Object>> result, File templateRootPath) {
        if (templateRootPath != null && templateRootPath.listFiles() != null) {
            File[] fileArray = templateRootPath.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile() && f.getName().endsWith(JSON_SUFFIX)) {
                    try {
                        Map configurationMap = (Map)this.mapper.readValue(f, new HashMap().getClass());
                        result.put(f.getAbsolutePath(), configurationMap);
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"Integration: Could not read templates: ", (Throwable)e);
                    }
                }
                ++n2;
            }
        }
    }

    public void setPageComplete(boolean complete) {
        if (complete && this.isEditWizard()) {
            complete &= this.textChosenConfig.getText() != null && !this.textChosenConfig.getText().isEmpty();
        } else if (complete && this.isNewWizard() && this.loadInactiveConfigurationButton.getSelection()) {
            complete &= this.textChosenConfig.getText() != null && !this.textChosenConfig.getText().isEmpty();
        } else if (complete && this.isNewWizard() && this.loadTemplateButton.getSelection()) {
            complete &= this.templateListViewer.getSelection() != null && !this.templateListViewer.getSelection().isEmpty();
        }
        super.setPageComplete(complete);
    }

    private void createNewIntegrationPart(Composite container) {
        this.newIntegrationButton = new Button(container, 16);
        this.newIntegrationButton.setText(StringUtils.format((String)Messages.newConfigurationButton, (Object[])new Object[]{IntegrationContextType.COMMON.toString()}));
        this.newIntegrationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (ChooseConfigurationPage.this.newIntegrationButton.getSelection()) {
                    ChooseConfigurationPage.this.textChosenConfig.setText("");
                    HashMap<String, Object> newConfiguration = new HashMap<String, Object>();
                    newConfiguration.put("integrationType", IntegrationContextType.COMMON.toString());
                    ChooseConfigurationPage.this.wizard.setPreviousConfiguration(newConfiguration, null);
                    ChooseConfigurationPage.this.wizard.removeAdditionalPages();
                    ChooseConfigurationPage.this.toolList.setEnabled(false);
                    ChooseConfigurationPage.this.templateListViewer.getControl().setEnabled(false);
                    ChooseConfigurationPage.this.textChosenConfig.setEnabled(false);
                    ChooseConfigurationPage.this.toolList.setBackground(Display.getDefault().getSystemColor(19));
                    ChooseConfigurationPage.this.toolList.deselectAll();
                    ChooseConfigurationPage.this.templateListViewer.getControl().setBackground(Display.getDefault().getSystemColor(19));
                    ChooseConfigurationPage.this.templateListViewer.getList().deselectAll();
                    ChooseConfigurationPage.this.setPageComplete(true);
                    ChooseConfigurationPage.this.wizard.setIntegrationType(IntegrationContextType.COMMON.toString(), false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        for (final IntegrationContext context : this.allIntegrationContexts) {
            if (context.getContextId().equals(ToolIntegrationConstants.COMMON_TOOL_INTEGRATION_CONTEXT_UID)) continue;
            final Button newExtensionIntegrationButton = new Button(container, 16);
            newExtensionIntegrationButton.setText(StringUtils.format((String)Messages.newConfigurationButton, (Object[])new Object[]{context.getContextTypeString()}));
            newExtensionIntegrationButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    if (newExtensionIntegrationButton.getSelection()) {
                        ChooseConfigurationPage.this.textChosenConfig.setText("");
                        HashMap<String, Object> newConfiguration = new HashMap<String, Object>();
                        newConfiguration.put("integrationType", context.getContextTypeString());
                        ChooseConfigurationPage.this.wizard.setPreviousConfiguration(newConfiguration, null);
                        ChooseConfigurationPage.this.wizard.removeAdditionalPages();
                        ChooseConfigurationPage.this.wizard.setAdditionalPages(context.getContextTypeString());
                        ChooseConfigurationPage.this.toolList.setEnabled(false);
                        ChooseConfigurationPage.this.templateListViewer.getControl().setEnabled(false);
                        ChooseConfigurationPage.this.textChosenConfig.setEnabled(false);
                        ChooseConfigurationPage.this.toolList.setBackground(Display.getDefault().getSystemColor(19));
                        ChooseConfigurationPage.this.toolList.deselectAll();
                        ChooseConfigurationPage.this.templateListViewer.getControl().setBackground(Display.getDefault().getSystemColor(19));
                        ChooseConfigurationPage.this.templateListViewer.getList().deselectAll();
                        ChooseConfigurationPage.this.setPageComplete(true);
                        ChooseConfigurationPage.this.wizard.setIntegrationType(context.getContextTypeString(), false);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    this.widgetSelected(arg0);
                }
            });
        }
    }

    private void loadConfigurationFromFile(File configJson) {
        if (configJson.exists() && configJson.isFile()) {
            Map configurationMap = null;
            try {
                configurationMap = (Map)this.mapper.readValue(configJson, HashMap.class);
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
            if (configurationMap != null) {
                this.textChosenConfig.setText(configJson.getAbsolutePath());
            } else {
                this.textChosenConfig.setText("");
            }
            this.wizard.setPreviousConfiguration(configurationMap, configJson);
            this.wizard.setIsEdit(configurationMap != null && configurationMap.get("isActive") != null && (Boolean)configurationMap.get("isActive") != false);
            this.wizard.removeAdditionalPages();
            if (configurationMap != null) {
                this.wizard.setAdditionalPages((String)configurationMap.get("integrationType"));
            }
        } else {
            this.wizard.setPreviousConfiguration(null, null);
            this.wizard.removeAdditionalPages();
        }
    }

    private Map<String, String> readExistingConfigurations() {
        TreeMap<String, String> allConfigs = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (IntegrationContext context : this.allIntegrationContexts) {
            String configFolder = context.getRootPathToToolIntegrationDirectory();
            ToolIntegrationContextDirectory toolIntegrationContextFolder = new ToolIntegrationContextDirectory(new File(configFolder, context.getNameOfToolIntegrationDirectory()));
            if (!toolIntegrationContextFolder.isPotentiallyValid()) continue;
            File[] fileArray = toolIntegrationContextFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                Optional f;
                File toolFolder = fileArray[n2];
                ToolIntegrationDirectory integrationDirectory = new ToolIntegrationDirectory(toolFolder);
                if (integrationDirectory.isPotentiallyValid() && (f = this.integrationHelper.tryFindConfigurationFile(context, integrationDirectory.getToolFolder())).isPresent()) {
                    try {
                        ToolConfiguration toolConfiguration = new ToolConfiguration((Map)this.mapper.readValue((File)f.get(), HashMap.class));
                        String toolName = toolConfiguration.getToolName();
                        if (this.isNewWizard() && toolConfiguration.isInactive() || this.isEditWizard() && toolConfiguration.isActive()) {
                            allConfigs.put(toolName, ((File)f.get()).getAbsolutePath());
                        }
                        this.allConfigurations.put(toolName, toolConfiguration.toMap());
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"Could not read configuration file: ", (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        return allConfigs;
    }

    private boolean isNewWizard() {
        return !this.isEditWizard;
    }

    private boolean isEditWizard() {
        return this.isEditWizard;
    }

    public String getChoosenConfigPath() {
        return this.textChosenConfig.getText();
    }

    public void performHelp() {
        super.performHelp();
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        if (this.isNewWizard()) {
            helpSystem.displayHelp("de.rcenvironment.core.gui.wizard.toolintegration.integration_chooseconfig");
        } else {
            helpSystem.displayHelp("de.rcenvironment.core.gui.wizard.toolintegration.integration_editconfig");
        }
    }

    @Override
    public void setConfigMap(Map<String, Object> newConfigurationMap) {
    }

    @Override
    public void updatePage() {
        if (this.isEditWizard() && this.isCurrentPage() && (this.textChosenConfig.getText() == null || this.textChosenConfig.getText().isEmpty())) {
            this.setPageComplete(false);
        }
    }

    public void showPage(IWizardPage iWizardPage) {
        this.getContainer().showPage(iWizardPage);
    }

    public String createDisplayedToolName(String toolName) {
        String groupName;
        String type = IntegrationContextType.COMMON.toString();
        if (this.allConfigurations.get(toolName).get("integrationType") != null) {
            type = (String)this.allConfigurations.get(toolName).get("integrationType");
        }
        ArrayList launchSettings = (ArrayList)this.allConfigurations.get(toolName).get("launchSettings");
        String version = (String)((LinkedHashMap)launchSettings.get(0)).get("version");
        Object[] toolInformation = new Object[]{toolName, version, type};
        String displayedToolName = StringUtils.format((String)"%s (%s; Type: %s)", (Object[])toolInformation);
        boolean disabled = false;
        StringBuilder errorString = new StringBuilder();
        if (ComponentIdRules.validateComponentIdRules((String)toolName).isPresent()) {
            errorString.append(" [INVALID TOOL NAME]");
            disabled = true;
        }
        if (ComponentIdRules.validateComponentVersionRules((String)version).isPresent()) {
            errorString.append(" [INVALID VERSION]");
            disabled = true;
        }
        if (this.allConfigurations.get(toolName).get("groupName") != null && !(groupName = (String)this.allConfigurations.get(toolName).get("groupName")).isEmpty() && ComponentGroupPathRules.validateComponentGroupPathRules((String)groupName).isPresent()) {
            errorString.append(" [INVALID GROUP NAME]");
            disabled = true;
        }
        if (disabled) {
            displayedToolName = StringUtils.format((String)"%s%s - DISABLED", (Object[])new Object[]{displayedToolName, errorString.toString()});
        }
        return displayedToolName;
    }

    private class ToolConfiguration {
        private Map<String, Object> configurationMap;

        protected ToolConfiguration(Map<String, Object> configurationMap) {
            this.configurationMap = configurationMap;
        }

        public boolean isActive() {
            Object isActiveValue = this.configurationMap.get("isActive");
            return isActiveValue != null && (Boolean)isActiveValue != false;
        }

        public boolean isInactive() {
            Object isActiveValue = this.configurationMap.get("isActive");
            return isActiveValue != null && (Boolean)isActiveValue == false;
        }

        public String getToolName() {
            return (String)this.configurationMap.get("toolName");
        }

        public Map<String, Object> toMap() {
            return new HashMap<String, Object>(this.configurationMap);
        }
    }

    private class ToolIntegrationContextDirectory {
        private final File directoryFile;

        ToolIntegrationContextDirectory(File directoryFile) {
            this.directoryFile = directoryFile;
        }

        private boolean isPotentiallyValid() {
            return this.directoryFile.exists() && this.directoryFile.isDirectory() && this.directoryFile.listFiles() != null && this.directoryFile.listFiles().length > 0;
        }

        public File[] listFiles() {
            return this.directoryFile.listFiles();
        }
    }

    private class ToolIntegrationDirectory {
        private final File toolFolder;

        ToolIntegrationDirectory(File toolFolder) {
            this.toolFolder = toolFolder;
        }

        private boolean isPotentiallyValid() {
            return this.toolFolder != null && this.toolFolder.isDirectory() && !this.toolFolder.getName().equals("null") && this.toolFolder.listFiles() != null && this.toolFolder.listFiles().length > 0;
        }

        public File getToolFolder() {
            return this.toolFolder;
        }
    }
}

