/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.testing;

import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.testing.TestParametersProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ParameterizedTestUtils
implements TestParametersProvider {
    private static final ThreadLocal<File> TEST_PARAMS_DIRECTORY_THREADLOCAL = new ThreadLocal();
    private Properties properties;

    public static void setTestParameterDirectoryForCurrentThread(File paramsDir) {
        TEST_PARAMS_DIRECTORY_THREADLOCAL.set(paramsDir);
    }

    public TestParametersProvider readPropertiesFile(File paramFile) throws IOException {
        this.properties = new Properties();
        this.verifyAndLoadPropertiesFile(paramFile);
        return this;
    }

    public TestParametersProvider readDefaultPropertiesFile(Class<?> testClass) throws IOException {
        File paramsDir = TEST_PARAMS_DIRECTORY_THREADLOCAL.get();
        this.properties = new Properties();
        String resourceName = String.valueOf(testClass.getSimpleName()) + ".properties";
        if (paramsDir != null) {
            File paramFile = new File(paramsDir, resourceName);
            this.verifyAndLoadPropertiesFile(paramFile);
        } else {
            InputStream propertiesStream = testClass.getResourceAsStream("/" + resourceName);
            if (propertiesStream == null) {
                throw new IOException("Failed to load test configuration as resouce: " + resourceName);
            }
            this.properties.load(propertiesStream);
        }
        return this;
    }

    public TestParametersProvider readPropertiesFile(String resourceName) throws IOException {
        this.properties = new Properties();
        File paramFile = new File(resourceName);
        this.verifyAndLoadPropertiesFile(paramFile);
        return this;
    }

    @Override
    public String getNonEmptyString(String key) {
        String value = this.properties.getProperty(key);
        if (value == null || value.isEmpty()) {
            throw new AssertionError((Object)StringUtils.format((String)"Required test property '%s' is undefined or empty", (Object[])new Object[]{key}));
        }
        return value;
    }

    @Override
    public File getDefinedFileOrDir(String key) {
        String value = this.getNonEmptyString(key);
        return new File(value).getAbsoluteFile();
    }

    @Override
    public File getExistingFile(String key) {
        File value = this.getDefinedFileOrDir(key);
        if (!value.isFile()) {
            throw new AssertionError((Object)StringUtils.format((String)"Configured test file '%s' does not exist", (Object[])new Object[]{value.getAbsolutePath()}));
        }
        return value;
    }

    @Override
    public File getExistingDir(String key) {
        File value = this.getDefinedFileOrDir(key);
        if (!value.isDirectory()) {
            throw new AssertionError((Object)StringUtils.format((String)"Configured test directory '%s' does not exist", (Object[])new Object[]{value.getAbsolutePath()}));
        }
        return value;
    }

    @Override
    public int getOptionalInteger(String key, int defaultValue) {
        return StringUtils.nullSafeParseInt((String)this.properties.getProperty(key), (int)defaultValue);
    }

    @Override
    public int getExistingInteger(String key) {
        int intValue;
        String value = this.getNonEmptyString(key);
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AssertionError((Object)StringUtils.format((String)"Value %s for required test property %s is not an Integer.", (Object[])new Object[]{key, value}));
        }
        return intValue;
    }

    private void verifyAndLoadPropertiesFile(File paramFile) throws IOException, FileNotFoundException {
        if (!paramFile.isFile()) {
            throw new IOException("Expected to find test parameter file " + paramFile.getAbsolutePath());
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream is = new FileInputStream(paramFile);){
            this.properties.load(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getOptionalString(String key) {
        return this.properties.getProperty(key);
    }
}

