/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.palette.view.palettetreenodes;

import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.gui.integration.toolintegration.ShowIntegrationEditWizardHandler;
import de.rcenvironment.core.gui.integration.workflowintegration.handlers.EditWorkflowIntegrationHandler;
import de.rcenvironment.core.gui.palette.toolidentification.ToolIdentification;
import de.rcenvironment.core.gui.palette.toolidentification.ToolType;
import de.rcenvironment.core.gui.palette.view.PaletteView;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.ComponentNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.PaletteTreeNode;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.editor.PaletteCreationTool;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditor;
import de.rcenvironment.core.gui.workflow.editor.WorkflowNodeFactory;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.Tool;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class AccessibleComponentNode
extends ComponentNode {
    private static final String DEPRECATED_STRING = "Component Status 'DEPRECATED': This component will no longer be available in future versions of RCE.";
    private static final String AUTHENTICATION_GROUP_STRING = "Accessible via group(s): %s";
    private static final String INTEGRATION_TYPE_STRING = "Component Integration Type: %s";
    private static final String LOCAL_EXECUTION_ONLY_STRING = "Local Execution: This component is only available for local execution.";
    private static final String TYPE_STRING = "Component Type: %s";
    private static final String COMPONENT_STRING = "Component Name: %s";
    private static final String VERSION_STRING = "Component Version: %s";
    private static final String LOCATION_STRING = "Component Location: %s";
    private static final String DEFAULT_GROUP_STRING = "Default Group: %s";
    private static final String LOOP_DRIVER_STRING = "Loop Driver: This component is a driver workflow component.";
    private static final String STRING_LOCAL = "Local";
    private static final String STRING_REMOTE = "Remote";
    private static final Object STRING_MAPPED = "Remote (via Uplink or SSH connection)";
    private static final String LINE_BREAK = "\n";
    private final DistributedComponentEntry componentEntry;
    private PaletteCreationTool tool;

    public AccessibleComponentNode(PaletteTreeNode parent, DistributedComponentEntry toolEntry, ToolIdentification toolIdentification) {
        super((TreeNode)parent, toolIdentification);
        ComponentInterface componentInterface = toolEntry.getComponentInstallation().getComponentInterface();
        if (componentInterface.getIcon16() != null) {
            Image toolImage = new Image((Device)Display.getCurrent(), (InputStream)new ByteArrayInputStream(componentInterface.getIcon16()));
            this.setIcon(toolImage);
        }
        this.componentEntry = toolEntry;
    }

    @Override
    public Optional<Image> getIcon() {
        Optional<Image> icon = super.getIcon();
        if (icon.isPresent() && this.componentEntry.getComponentInterface().getIsDeprecated()) {
            return Optional.of(this.getOverlayIcon(icon.get()));
        }
        return icon;
    }

    private Image getOverlayIcon(Image icon) {
        DecorationOverlayIcon overlayIcon = new DecorationOverlayIcon(icon, ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.DECORATOR_DEPRECATED), 2);
        return overlayIcon.createImage();
    }

    @Override
    public boolean isLocal() {
        return this.componentEntry.getType().isLocal() && !this.isMapped();
    }

    public boolean isMapped() {
        return this.componentEntry.getComponentInstallation().isMappedComponent();
    }

    public DistributedComponentEntry getComponentEntry() {
        return this.componentEntry;
    }

    @Override
    public void handleEditEvent() {
        if (this.getToolIdentification().getType().equals((Object)ToolType.INTEGRATED_TOOL)) {
            ShowIntegrationEditWizardHandler handler = new ShowIntegrationEditWizardHandler(this.getNodeName());
            try {
                handler.execute(new ExecutionEvent());
            }
            catch (ExecutionException e) {
                LogFactory.getLog(PaletteTreeNode.class).error((Object)"Opening Tool Edit wizard failed", (Throwable)e);
            }
        } else if (this.getToolIdentification().getType().equals((Object)ToolType.INTEGRATED_WORKFLOW)) {
            EditWorkflowIntegrationHandler handler = new EditWorkflowIntegrationHandler(this.getNodeName());
            try {
                handler.execute(null);
            }
            catch (ExecutionException e) {
                LogFactory.getLog(PaletteTreeNode.class).error((Object)"Opening Edit Workflow failed", (Throwable)e);
            }
        } else {
            throw new UnsupportedOperationException(StringUtils.format((String)"Unexpected edit event on %s", (Object[])new Object[]{this.getClass().getCanonicalName()}));
        }
    }

    @Override
    public boolean canHandleEditEvent() {
        return (this.getToolIdentification().getType().equals((Object)ToolType.INTEGRATED_TOOL) || this.getToolIdentification().getType().equals((Object)ToolType.INTEGRATED_WORKFLOW)) && this.isLocal();
    }

    @Override
    public String getDisplayName() {
        return this.getNodeName();
    }

    public String getPredefinedGroup() {
        return this.componentEntry.getComponentInstallation().getComponentInterface().getGroupName();
    }

    public String getGroupPathPrefix() {
        ToolType toolType = this.getToolIdentification().getType();
        if (toolType.equals((Object)ToolType.INTEGRATED_TOOL) && this.getPredefinedGroup().equals(ToolType.INTEGRATED_TOOL.getTopLevelGroupName())) {
            return "";
        }
        if (toolType.equals((Object)ToolType.INTEGRATED_WORKFLOW) && this.getPredefinedGroup().equals(ToolType.INTEGRATED_WORKFLOW.getTopLevelGroupName())) {
            return "";
        }
        return String.valueOf(this.getToolIdentification().getType().getTopLevelGroupName()) + "/";
    }

    @Override
    public void handleWidgetSelected(WorkflowEditor editor) {
        editor.getViewer().getEditDomain().setActiveTool((Tool)this.getTool());
    }

    public PaletteCreationTool getTool() {
        if (this.tool == null) {
            this.tool = new PaletteCreationTool((CreationFactory)new WorkflowNodeFactory(this.componentEntry.getComponentInstallation()));
        }
        return this.tool;
    }

    @Override
    public boolean isCustomized() {
        return !(String.valueOf(this.getGroupPathPrefix()) + this.getPredefinedGroup()).equals(this.getParentGroupNode().getQualifiedGroupName());
    }

    @Override
    public void handleDoubleclick(PaletteView paletteView) {
        Optional<WorkflowEditor> optional = paletteView.getWorkflowEditor();
        if (!optional.isPresent()) {
            return;
        }
        WorkflowEditor editor = optional.get();
        editor.onPaletteDoubleClick((Tool)this.getTool());
    }

    @Override
    public Optional<String> getHelpContextID() {
        return Optional.of(ComponentUtils.getComponentInterfaceIdentifierWithoutVersion((String)this.getToolIdentification().getToolID()));
    }

    public String getComponentInformation() {
        ComponentInterface componentInterface = this.getComponentEntry().getComponentInterface();
        StringBuilder text = new StringBuilder();
        this.appendComponentNameString(text);
        this.appendVersionString(componentInterface, text);
        this.appendComponentTypeString(text);
        this.appendIntegrationTypeString(text);
        this.appendLocationString(text);
        this.appendAuthenticationGroupString(text);
        this.appendCurrentGroupString(text);
        this.appendDefaultGroupString(text);
        this.appendLoopDriverString(componentInterface, text);
        this.appendLocalExecutionString(componentInterface, text);
        this.appendDeprecatedString(componentInterface, text);
        return text.toString();
    }

    public String getComponentTooltip() {
        ComponentInterface componentInterface = this.getComponentEntry().getComponentInterface();
        StringBuilder text = new StringBuilder();
        this.appendComponentNameString(text);
        this.appendVersionString(componentInterface, text);
        this.appendComponentTypeString(text);
        this.appendLocationString(text);
        this.appendDefaultGroupString(text);
        this.appendDeprecatedString(componentInterface, text);
        return text.toString();
    }

    private void appendDeprecatedString(ComponentInterface componentInterface, StringBuilder text) {
        if (componentInterface.getIsDeprecated()) {
            text.append(LINE_BREAK);
            text.append(DEPRECATED_STRING);
        }
    }

    private void appendLocalExecutionString(ComponentInterface componentInterface, StringBuilder text) {
        if (componentInterface.getLocalExecutionOnly()) {
            text.append(LINE_BREAK);
            text.append(LOCAL_EXECUTION_ONLY_STRING);
        }
    }

    private void appendLoopDriverString(ComponentInterface componentInterface, StringBuilder text) {
        if (componentInterface.getIsLoopDriver()) {
            text.append(LINE_BREAK);
            text.append(LOOP_DRIVER_STRING);
        }
    }

    private void appendDefaultGroupString(StringBuilder text) {
        String predefindedGroupPath = String.valueOf(this.getGroupPathPrefix()) + this.getPredefinedGroup();
        if (!predefindedGroupPath.equals(this.getParentGroupNode().getQualifiedGroupName())) {
            text.append(LINE_BREAK);
            text.append(String.format(DEFAULT_GROUP_STRING, predefindedGroupPath));
        }
    }

    private void appendCurrentGroupString(StringBuilder text) {
        text.append(LINE_BREAK);
        text.append(StringUtils.format((String)"Current Palette Group: %s", (Object[])new Object[]{this.getParentGroupNode().getQualifiedGroupName()}));
    }

    private void appendAuthenticationGroupString(StringBuilder text) {
        if (!this.isLocal() && !this.isMapped()) {
            text.append(LINE_BREAK);
            text.append(StringUtils.format((String)AUTHENTICATION_GROUP_STRING, (Object[])new Object[]{String.join((CharSequence)", ", (CharSequence[])this.getComponentEntry().getDeclaredPermissionSet().getAccessGroups().stream().map(AuthorizationAccessGroup::getName).toArray(String[]::new))}));
        }
    }

    private void appendIntegrationTypeString(StringBuilder text) {
        if (this.getToolIdentification().getIntegrationType().isPresent()) {
            text.append(LINE_BREAK);
            text.append(StringUtils.format((String)INTEGRATION_TYPE_STRING, (Object[])new Object[]{this.getToolIdentification().getIntegrationType().get()}));
        }
    }

    private void appendComponentTypeString(StringBuilder text) {
        text.append(LINE_BREAK);
        text.append(String.format(TYPE_STRING, this.getType().getName()));
    }

    private void appendVersionString(ComponentInterface componentInterface, StringBuilder text) {
        if (this.getType() == ToolType.INTEGRATED_TOOL || this.getType() == ToolType.INTEGRATED_WORKFLOW) {
            text.append(LINE_BREAK);
            text.append(StringUtils.format((String)VERSION_STRING, (Object[])new Object[]{componentInterface.getVersion()}));
        }
    }

    private void appendComponentNameString(StringBuilder text) {
        text.append(StringUtils.format((String)COMPONENT_STRING, (Object[])new Object[]{this.getDisplayName()}));
    }

    private void appendLocationString(StringBuilder text) {
        text.append(LINE_BREAK);
        if (this.isMapped()) {
            text.append(StringUtils.format((String)LOCATION_STRING, (Object[])new Object[]{STRING_MAPPED}));
            return;
        }
        if (!this.isLocal()) {
            text.append(StringUtils.format((String)LOCATION_STRING, (Object[])new Object[]{STRING_REMOTE}));
            return;
        }
        text.append(StringUtils.format((String)LOCATION_STRING, (Object[])new Object[]{STRING_LOCAL}));
    }
}

