/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common;

import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CommonIdRules {
    protected static final Pattern ID_OR_VERSION_STRING_INVALID_CHARACTERS_REGEXP = Pattern.compile("[^a-zA-Z0-9 _\\.,\\-\\+\\(\\)]");
    protected static final String VALID_ID_OR_VERSION_STRING_CHARSET_ERROR_MESSAGE = "Invalid character at position %d (\"%s\") - anything except a-z, A-Z, digits, spaces, and _.,-+() is forbidden";
    protected static final Pattern VALID_ID_FIRST_CHARACTER_REGEXP = Pattern.compile("^[a-zA-Z_].*");
    protected static final String VALID_ID_FIRST_CHARACTER_ERROR_MESSAGE = "It must begin with one of the letters a-z, A-Z, or the underscore (\"_\")";
    protected static final Pattern VALID_VERSION_STRING_FIRST_CHARACTER_REGEXP = Pattern.compile("^[a-zA-Z0-9_].*");
    protected static final String VALID_VERSION_STRING_FIRST_CHARACTER_ERROR_MESSAGE = "It must begin with one of the letters a-z, A-Z, a digit, or the underscore (\"_\")";
    protected static final Pattern VALID_ID_OR_VERSION_STRING_LAST_CHARACTER_REGEXP = Pattern.compile(".*[^ ]$");
    protected static final String VALID_ID_OR_VERSION_STRING_LAST_CHARACTER_ERROR_MESSAGE = "Spaces are allowed, but cannot be the last character";

    private CommonIdRules() {
    }

    public static Optional<String> validateCommonIdRules(String input) {
        if (input.isEmpty()) {
            return Optional.empty();
        }
        Optional<String> characterValidationError = CommonIdRules.checkForInvalidCharacters(input);
        if (characterValidationError.isPresent()) {
            return characterValidationError;
        }
        if (!VALID_ID_FIRST_CHARACTER_REGEXP.matcher(input).matches()) {
            return Optional.of(VALID_ID_FIRST_CHARACTER_ERROR_MESSAGE);
        }
        if (!VALID_ID_OR_VERSION_STRING_LAST_CHARACTER_REGEXP.matcher(input).matches()) {
            return Optional.of(VALID_ID_OR_VERSION_STRING_LAST_CHARACTER_ERROR_MESSAGE);
        }
        return Optional.empty();
    }

    public static Optional<String> validateCommonVersionStringRules(String input) {
        if (input.isEmpty()) {
            return Optional.empty();
        }
        Optional<String> characterValidationError = CommonIdRules.checkForInvalidCharacters(input);
        if (characterValidationError.isPresent()) {
            return characterValidationError;
        }
        if (!VALID_VERSION_STRING_FIRST_CHARACTER_REGEXP.matcher(input).matches()) {
            return Optional.of(VALID_VERSION_STRING_FIRST_CHARACTER_ERROR_MESSAGE);
        }
        if (!VALID_ID_OR_VERSION_STRING_LAST_CHARACTER_REGEXP.matcher(input).matches()) {
            return Optional.of(VALID_ID_OR_VERSION_STRING_LAST_CHARACTER_ERROR_MESSAGE);
        }
        return Optional.empty();
    }

    private static Optional<String> checkForInvalidCharacters(String input) {
        Matcher invalidCharMatcher = ID_OR_VERSION_STRING_INVALID_CHARACTERS_REGEXP.matcher(input);
        if (invalidCharMatcher.find()) {
            return Optional.of(StringUtils.format(VALID_ID_OR_VERSION_STRING_CHARSET_ERROR_MESSAGE, invalidCharMatcher.start(0) + 1, invalidCharMatcher.group(0)));
        }
        return Optional.empty();
    }
}

