/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.workflow;

import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.workflow.execution.function.EndpointAdapter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EndpointAdapterFactory {
    private static final String TYPE_KEY = "type";
    private static final String IDENTIFIER_KEY = "identifier";
    private static final String INTERNAL_NAME_KEY = "internalName";
    private static final String EXTERNAL_NAME_KEY = "externalName";
    private final WorkflowDescription description;
    private Map<String, String> configurationMap;
    private Collection<String> errorMessages = new LinkedList<String>();

    public EndpointAdapterFactory(WorkflowDescription descriptionParam) {
        this.description = descriptionParam;
    }

    public EndpointAdapter buildFromMap(Map<String, String> map) throws ComponentException {
        this.configurationMap = map;
        EndpointAdapter.Builder builder = "INPUT".equals(this.configurationMap.get(TYPE_KEY)) ? EndpointAdapter.inputAdapterBuilder() : EndpointAdapter.outputAdapterBuilder();
        this.initializeEndpointNames(builder);
        this.initializeAdaptedDataType(builder);
        this.initializeInputHandling(builder);
        this.initializeInputExecutionConstraint(builder);
        if (!this.configurationMap.containsKey(TYPE_KEY)) {
            this.errorMessages.add("Configuration does not key 'type', which must be set to ether 'INPUT' or 'OUTPUT'");
        } else if (!"INPUT".equals(this.configurationMap.get(TYPE_KEY)) && !"OUTPUT".equals(this.configurationMap.get(TYPE_KEY))) {
            String errorMessage = StringUtils.format((String)"Endpoint adapter defined as unknown type %s. Supported types: 'INPUT', 'OUTPUT'", (Object[])new Object[]{this.configurationMap.get(TYPE_KEY)});
            this.errorMessages.add(errorMessage);
        }
        this.throwExceptionIfErrorOccurred();
        if ("INPUT".equals(this.configurationMap.get(TYPE_KEY))) {
            return builder.build();
        }
        return builder.build();
    }

    private void initializeInputExecutionConstraint(EndpointAdapter.Builder builder) {
        if (!this.configurationMap.containsKey(IDENTIFIER_KEY)) {
            return;
        }
        boolean isInputAdapter = "INPUT".equals(this.configurationMap.get(TYPE_KEY));
        if (!isInputAdapter) {
            return;
        }
        Optional<EndpointDescription> adaptedInput = this.getAdaptedEndpoint();
        if (!adaptedInput.isPresent()) {
            return;
        }
        builder.inputExecutionConstraint(EndpointDefinition.InputExecutionContraint.valueOf((String)this.configurationMap.get("inputExecutionConstraint")));
    }

    private void initializeInputHandling(EndpointAdapter.Builder builder) {
        if (!this.configurationMap.containsKey(IDENTIFIER_KEY)) {
            return;
        }
        boolean isInputAdapter = "INPUT".equals(this.configurationMap.get(TYPE_KEY));
        if (!isInputAdapter) {
            return;
        }
        Optional<EndpointDescription> adaptedInput = this.getAdaptedEndpoint();
        if (!adaptedInput.isPresent()) {
            return;
        }
        builder.inputHandling(EndpointDefinition.InputDatumHandling.valueOf((String)this.configurationMap.get("inputHandling")));
    }

    private void throwExceptionIfErrorOccurred() throws ComponentException {
        if (this.errorMessages.isEmpty()) {
            return;
        }
        String unparsedConfigurationMap = this.configurationMap.entrySet().stream().map(entry -> StringUtils.format((String)"%s=%s", (Object[])new Object[]{entry.getKey(), entry.getValue()})).collect(Collectors.joining(", ", "{", "}"));
        String joinedErrorMessages = this.errorMessages.stream().collect(Collectors.joining(". "));
        throw new ComponentException(StringUtils.format((String)"Invalid endpoint adapter definition: %s. Specific errors: %s.", (Object[])new Object[]{unparsedConfigurationMap, joinedErrorMessages}));
    }

    private void initializeEndpointNames(EndpointAdapter.Builder builder) throws ComponentException {
        if (!this.configurationMap.containsKey(IDENTIFIER_KEY)) {
            this.errorMessages.add("Configuration does not contain required parameter 'identifier'");
        } else {
            builder.workflowNodeIdentifier(this.configurationMap.get(IDENTIFIER_KEY));
        }
        if (!this.configurationMap.containsKey(INTERNAL_NAME_KEY)) {
            this.errorMessages.add("Configuration does not contain required parameter 'internalName'");
        } else {
            builder.internalEndpointName(this.configurationMap.get(INTERNAL_NAME_KEY));
        }
        if (!this.configurationMap.containsKey(EXTERNAL_NAME_KEY)) {
            this.errorMessages.add("Configuration does not contain required parameter 'externalName'");
        } else {
            builder.externalEndpointName(this.configurationMap.get(EXTERNAL_NAME_KEY));
        }
    }

    private void initializeAdaptedDataType(EndpointAdapter.Builder builder) {
        if (!this.configurationMap.containsKey(IDENTIFIER_KEY)) {
            return;
        }
        Optional<EndpointDescription> internalEndpointDescription = this.getAdaptedEndpoint();
        if (!internalEndpointDescription.isPresent()) {
            this.errorMessages.add(StringUtils.format((String)"Endpoint with name '%s' at workflow node with ID '%s' is configured to pass values from or to the external workflow, but that endpoint does not exist on that node", (Object[])new Object[]{this.configurationMap.get(INTERNAL_NAME_KEY), this.configurationMap.get(IDENTIFIER_KEY)}));
            return;
        }
        builder.dataType(internalEndpointDescription.get().getDataType());
    }

    private Optional<EndpointDescription> getAdaptedEndpoint() {
        boolean isInputAdapter = "INPUT".equals(this.configurationMap.get(TYPE_KEY));
        String workflowNodeIdentifier = this.configurationMap.get(IDENTIFIER_KEY);
        Optional<WorkflowNode> adaptedWorkflowNode = this.description.getWorkflowNodes().stream().filter(node -> workflowNodeIdentifier.equals(node.getIdentifierAsObject().toString())).findAny();
        if (!adaptedWorkflowNode.isPresent()) {
            this.errorMessages.add(StringUtils.format((String)"Workflow node with identifier '%s' is configured to pass values from or to the external workflow, but that node does not exist in the workflow", (Object[])new Object[]{workflowNodeIdentifier}));
            return Optional.empty();
        }
        EndpointDescriptionsManager endpointDescriptions = isInputAdapter ? adaptedWorkflowNode.get().getInputDescriptionsManager() : adaptedWorkflowNode.get().getOutputDescriptionsManager();
        Stream allEndpointDescriptions = Stream.concat(endpointDescriptions.getDynamicEndpointDescriptions().stream(), endpointDescriptions.getStaticEndpointDescriptions().stream());
        Optional<EndpointDescription> internalEndpointDescription = allEndpointDescriptions.filter(endpointDescription -> endpointDescription.getName().equals(this.configurationMap.get(INTERNAL_NAME_KEY))).findAny();
        return internalEndpointDescription;
    }
}

