/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.views.contributors;

import de.rcenvironment.core.gui.resources.api.ColorManager;
import de.rcenvironment.core.gui.resources.api.ColorSource;
import de.rcenvironment.core.gui.resources.api.StandardColors;
import de.rcenvironment.core.gui.utils.common.ClipboardHelper;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConfigurationSnippetDialog
extends TitleAreaDialog {
    private static final String CONFIGURATION_NODES_TEMPLATE = "\"%s\" : {\r\n\t\"%s\" : {\r\n\t\t\"%s\" : {\r\n";
    private static final String CONFIGURATION_ENTRY_TEMPLATE = "\t\t\t\"%s\" : %s";
    private static final String CLOSING_BRACKET_TEMPLATE = "\r\n\t\t}\r\n\t}\r\n}";
    private Text configurationSnippetTextfield;
    private String configurationSnippet;

    public ConfigurationSnippetDialog(Shell parent, String topLevelNode, String secondLevelNode, String configurationNode, Map<String, Object> configurationEntries) {
        super(parent);
        ConfigurationSnippetDialog.setDialogHelpAvailable((boolean)false);
        this.configurationSnippet = this.buildSnippet(topLevelNode, secondLevelNode, configurationNode, configurationEntries);
    }

    private String buildSnippet(String topLevelNode, String secondLevelNode, String configurationNode, Map<String, Object> configurationEntries) {
        StringBuilder builder = new StringBuilder();
        builder.append(StringUtils.format((String)CONFIGURATION_NODES_TEMPLATE, (Object[])new Object[]{topLevelNode, secondLevelNode, configurationNode}));
        builder.append(String.join((CharSequence)",\r\n", (CharSequence[])configurationEntries.entrySet().stream().map(entry -> StringUtils.format((String)CONFIGURATION_ENTRY_TEMPLATE, (Object[])new Object[]{entry.getKey(), this.getValueString(entry.getValue())})).toArray(String[]::new)));
        builder.append(CLOSING_BRACKET_TEMPLATE);
        return builder.toString();
    }

    private String getValueString(Object value) {
        if (value instanceof String) {
            return StringUtils.format((String)"\"%s\"", (Object[])new Object[]{String.valueOf(value)});
        }
        return String.valueOf(value);
    }

    public void create() {
        super.create();
        this.setTitle("Configuration Snippet");
        this.setMessage("In order to persist this connection, the configuration snippet can be copied into the profile's configuration file (configuration.json).");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.configurationSnippetTextfield = new Text(container, 522);
        this.configurationSnippetTextfield.setBackground(ColorManager.getInstance().getSharedColor((ColorSource)StandardColors.RCE_WHITE));
        this.configurationSnippetTextfield.setText(this.configurationSnippet);
        this.configurationSnippetTextfield.setLayoutData((Object)new GridData(1808));
        GridData buttonData = new GridData();
        buttonData.horizontalIndent = 2;
        buttonData.verticalIndent = 4;
        Button copyToClipboardButton = new Button(container, 8);
        copyToClipboardButton.setText("Copy To Clipboard");
        copyToClipboardButton.setLayoutData((Object)buttonData);
        copyToClipboardButton.addSelectionListener((SelectionListener)new CopyToClipboardSelectionListener());
        GridData noteData = new GridData();
        noteData.horizontalIndent = 4;
        noteData.verticalIndent = 4;
        noteData.widthHint = this.getInitialSize().x;
        Label note = new Label(container, 64);
        note.setText("Please ensure to keep the JSON scheme when copying the snippet into the configuration file. \nAfter restarting RCE, the connection is permanently available in the Network View.");
        note.setLayoutData((Object)noteData);
        return container;
    }

    private final class CopyToClipboardSelectionListener
    implements SelectionListener {
        private CopyToClipboardSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            ClipboardHelper.setContent((String)ConfigurationSnippetDialog.this.configurationSnippetTextfield.getText());
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Copy to Clipboard", (String)"The configuration snippet was successfully copied to the clipboard.");
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }
    }
}

