/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.views;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.NetworkGraphNode;
import de.rcenvironment.core.gui.communication.views.internal.AnchorPoints;
import de.rcenvironment.core.gui.communication.views.model.NetworkGraphNodeWithContext;
import de.rcenvironment.core.gui.communication.views.model.NetworkViewModel;
import de.rcenvironment.core.gui.communication.views.spi.ContributedNetworkViewNode;
import de.rcenvironment.core.gui.communication.views.spi.ContributedNetworkViewNodeWithParent;
import de.rcenvironment.core.gui.communication.views.spi.NetworkViewContributor;
import de.rcenvironment.core.gui.communication.views.spi.SelfRenderingNetworkViewNode;
import de.rcenvironment.core.monitoring.system.api.model.FullSystemAndProcessDataSnapshot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class NetworkViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private static final String COLON = ": ";
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private NetworkViewModel model;
    private boolean optionRawPropertiesVisible = false;
    private final List<NetworkViewContributor> rootContributors;
    private final List<NetworkViewContributor> instanceDataContributors;
    private final List<Object> firstLevelNodes = new ArrayList<Object>();
    private Log log = LogFactory.getLog(this.getClass());

    public NetworkViewContentProvider(List<NetworkViewContributor> rootContributors, List<NetworkViewContributor> instanceDataContributors) {
        this.rootContributors = rootContributors;
        this.instanceDataContributors = instanceDataContributors;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        if (newInput == null) {
            return;
        }
        this.model = (NetworkViewModel)newInput;
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        this.firstLevelNodes.clear();
        this.firstLevelNodes.add((Object)AnchorPoints.MAIN_NETWORK_SECTION_PARENT_NODE);
        this.firstLevelNodes.add((Object)AnchorPoints.SSH_UPLINK_SECTION_PARENT_NODE);
        this.firstLevelNodes.add((Object)AnchorPoints.SSH_REMOTE_ACCESS_SECTION_PARENT_NODE);
        return this.firstLevelNodes.toArray();
    }

    public Object[] getChildren(Object parentNode) {
        Object[] result;
        ContributedNetworkViewNode typedParentNode;
        if (parentNode == AnchorPoints.INSTANCES_PARENT_NODE) {
            if (this.model.networkGraphWithProperties == null) {
                return EMPTY_ARRAY;
            }
            Collection nodes = this.model.networkGraphWithProperties.getNodes();
            int i = 0;
            Object[] result2 = new Object[nodes.size()];
            for (NetworkGraphNode node : nodes) {
                NetworkGraphNodeWithContext nodeWithContext = new NetworkGraphNodeWithContext(node, NetworkGraphNodeWithContext.Context.ROOT, null);
                nodeWithContext.setAttachedNodeProperties(this.model.getNodeProperties().get(node.getNodeId()));
                result2[i++] = nodeWithContext;
            }
            Arrays.sort(result2);
            return result2;
        }
        if (parentNode instanceof ContributedNetworkViewNode) {
            if (parentNode instanceof SelfRenderingNetworkViewNode) {
                SelfRenderingNetworkViewNode typedParentNode2 = (SelfRenderingNetworkViewNode)parentNode;
                if (!typedParentNode2.getHasChildren()) {
                    return EMPTY_ARRAY;
                }
                return typedParentNode2.getContributor().getChildren(typedParentNode2);
            }
            typedParentNode = (ContributedNetworkViewNode)parentNode;
            if (typedParentNode.getContributor() != null) {
                return typedParentNode.getContributor().getChildren(typedParentNode);
            }
        }
        if (parentNode == AnchorPoints.MAIN_NETWORK_SECTION_PARENT_NODE || parentNode == AnchorPoints.SSH_REMOTE_ACCESS_SECTION_PARENT_NODE || parentNode == AnchorPoints.SSH_UPLINK_SECTION_PARENT_NODE) {
            ArrayList<Object> result3 = new ArrayList<Object>();
            if (parentNode == AnchorPoints.MAIN_NETWORK_SECTION_PARENT_NODE) {
                result3.add((Object)AnchorPoints.INSTANCES_PARENT_NODE);
            }
            for (NetworkViewContributor contributor : this.rootContributors) {
                Object[] contributedNodes = contributor.getTopLevelElements(parentNode);
                if (contributedNodes == null) continue;
                Object[] objectArray = contributedNodes;
                int n = contributedNodes.length;
                int nodeWithContext = 0;
                while (nodeWithContext < n) {
                    Object element = objectArray[nodeWithContext];
                    result3.add(element);
                    ++nodeWithContext;
                }
            }
            return result3.toArray();
        }
        typedParentNode = (NetworkGraphNodeWithContext)parentNode;
        switch (((NetworkGraphNodeWithContext)typedParentNode).getContext()) {
            case ROOT: {
                ArrayList<Object> contribList = new ArrayList<Object>();
                for (NetworkViewContributor contributor : this.instanceDataContributors) {
                    Object[] objectArray = contributor.getChildrenForNetworkInstanceNode((NetworkGraphNodeWithContext)typedParentNode);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object contrib = objectArray[n2];
                        contribList.add(contrib);
                        ++n2;
                    }
                }
                if (this.optionRawPropertiesVisible) {
                    contribList.add(new NetworkGraphNodeWithContext((NetworkGraphNodeWithContext)typedParentNode, NetworkGraphNodeWithContext.Context.RAW_NODE_PROPERTIES_FOLDER, null));
                }
                result = contribList.toArray();
                break;
            }
            case RESOURCE_MONITORING_FOLDER: {
                FullSystemAndProcessDataSnapshot monitoringDataModel = this.model.getMonitoringDataModelMap().get(((NetworkGraphNodeWithContext)typedParentNode).getNode().getNodeId());
                if (monitoringDataModel != null) {
                    result = this.createNodeSystemResources(monitoringDataModel, ((NetworkGraphNodeWithContext)typedParentNode).getNode().getNodeId());
                    break;
                }
                result = new Object[]{"Fetching monitoring data..."};
                break;
            }
            case RAW_NODE_PROPERTIES_FOLDER: {
                ArrayList<NetworkGraphNodeWithContext> children = new ArrayList<NetworkGraphNodeWithContext>();
                Map<String, String> propertyValueMap = ((NetworkGraphNodeWithContext)typedParentNode).getAttachedNodeProperties();
                if (propertyValueMap != null) {
                    for (Map.Entry<String, String> property : propertyValueMap.entrySet()) {
                        NetworkGraphNodeWithContext newChild = new NetworkGraphNodeWithContext((NetworkGraphNodeWithContext)typedParentNode, NetworkGraphNodeWithContext.Context.RAW_NODE_PROPERTY, null);
                        newChild.setDisplayText(String.valueOf(property.getKey()) + COLON + property.getValue());
                        children.add(newChild);
                    }
                } else {
                    NetworkGraphNodeWithContext newChild = new NetworkGraphNodeWithContext((NetworkGraphNodeWithContext)typedParentNode, NetworkGraphNodeWithContext.Context.RAW_NODE_PROPERTY, null);
                    newChild.setDisplayText("<unknown>");
                    children.add(newChild);
                }
                result = children.toArray(EMPTY_ARRAY);
                Arrays.sort(result);
                break;
            }
            default: {
                result = EMPTY_ARRAY;
            }
        }
        return result;
    }

    private Object[] createNodeSystemResources(FullSystemAndProcessDataSnapshot monitoringDataModel, InstanceNodeSessionId nodeId) {
        return null;
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof SelfRenderingNetworkViewNode) {
            SelfRenderingNetworkViewNode typedParentNode = (SelfRenderingNetworkViewNode)parent;
            return typedParentNode.getHasChildren();
        }
        if (parent instanceof ContributedNetworkViewNode && ((ContributedNetworkViewNode)parent).getContributor() != null) {
            return ((ContributedNetworkViewNode)parent).getContributor().hasChildren(parent);
        }
        if (parent instanceof NetworkGraphNodeWithContext) {
            NetworkGraphNodeWithContext typedParentNode = (NetworkGraphNodeWithContext)parent;
            if (typedParentNode.getContributor() != null) {
                return typedParentNode.getContributor().hasChildren(parent);
            }
            switch (typedParentNode.getContext()) {
                case ROOT: {
                    return true;
                }
                case RAW_NODE_PROPERTIES_FOLDER: 
                case RESOURCE_MONITORING_FOLDER: {
                    return true;
                }
                case RAW_NODE_PROPERTY: {
                    return false;
                }
            }
            return true;
        }
        return this.firstLevelNodes.contains(parent) || parent == AnchorPoints.INSTANCES_PARENT_NODE;
    }

    public Object getParent(Object node) {
        if (node instanceof NetworkGraphNodeWithContext) {
            NetworkGraphNodeWithContext typedNode = (NetworkGraphNodeWithContext)node;
            NetworkGraphNodeWithContext parent = typedNode.getParent();
            if (parent != null) {
                return parent;
            }
            return AnchorPoints.INSTANCES_PARENT_NODE;
        }
        if (node instanceof ContributedNetworkViewNodeWithParent) {
            return ((ContributedNetworkViewNodeWithParent)node).getParentNode();
        }
        if (node instanceof ContributedNetworkViewNode) {
            ContributedNetworkViewNode typedNode = (ContributedNetworkViewNode)node;
            NetworkViewContributor contributor = typedNode.getContributor();
            if (contributor == null) {
                this.log.warn((Object)("getParent() called on contributed node without a contributor: " + node.toString()));
                return null;
            }
            Object parent = contributor.getParent(typedNode);
            if (parent == null) {
                this.log.warn((Object)("Contributor returned a null parent for " + node.toString()));
            } else {
                if (parent == AnchorPoints.SYMBOLIC_ROOT_NODE) {
                    return this.model;
                }
                return parent;
            }
        }
        if (this.firstLevelNodes.contains(node)) {
            return this.model;
        }
        this.log.warn((Object)("getParent() fall-through; returning null for node " + node.toString()));
        return null;
    }

    public void setRawPropertiesVisible(boolean value) {
        this.optionRawPropertiesVisible = value;
    }
}

