/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.command;

import de.rcenvironment.core.configuration.PersistentSettingsService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.util.ArrayList;
import java.util.List;

public class CommandHandler {
    private static final String KEYCOMMAND = "UsedCommands";
    private static final String SAVEDCOMMANDCOUNTER = "SavedCommandCounter";
    private static final int COMMAND_LIMIT = 30;
    private final List<String> usedCommands = new ArrayList<String>();
    private PersistentSettingsService persistentSettingsService;

    public CommandHandler() {
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)this);
        this.persistentSettingsService = (PersistentSettingsService)serviceRegistryAccess.getService(PersistentSettingsService.class);
        this.retrieveCommandHistory();
    }

    public List<String> getUsedCommands() {
        return this.usedCommands;
    }

    private void retrieveCommandHistory() {
        String commands = this.persistentSettingsService.readStringValue(KEYCOMMAND);
        if (commands != null) {
            String[] commandSplit;
            String[] stringArray = commandSplit = StringUtils.splitAndUnescape((String)commands);
            int n = commandSplit.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                this.addUsedCommand(element);
                ++n2;
            }
        }
    }

    public void addUsedCommand(String command) {
        this.usedCommands.remove(command);
        int size = this.usedCommands.size();
        if (size == 30) {
            this.usedCommands.remove(size - 1);
        }
        this.usedCommands.add(0, command);
    }

    public void saveCommand(String command) {
        String savedCommands = this.persistentSettingsService.readStringValue(KEYCOMMAND);
        String savedCommandCounter = this.persistentSettingsService.readStringValue(SAVEDCOMMANDCOUNTER);
        String escapeAndConcat = null;
        int savedCounter = savedCommandCounter == null ? 0 : Integer.parseInt(savedCommandCounter);
        if (savedCounter < 30) {
            if (savedCommands == null) {
                escapeAndConcat = StringUtils.escapeAndConcat((String[])new String[]{command});
            } else {
                String[] splitAndUnescape = this.splitAndUnescapeCommand(savedCommands, command, savedCounter);
                escapeAndConcat = StringUtils.escapeAndConcat((String[])splitAndUnescape);
            }
            this.persistentSettingsService.saveStringValue(SAVEDCOMMANDCOUNTER, "" + ++savedCounter);
        } else {
            String[] splitAndUnescape = this.splitAndRemoveLast(savedCommands, command);
            escapeAndConcat = StringUtils.escapeAndConcat((String[])splitAndUnescape);
        }
        this.persistentSettingsService.saveStringValue(KEYCOMMAND, escapeAndConcat);
    }

    private String[] splitAndUnescapeCommand(String savedCommands, String command, int savedCounter) {
        String[] splitAndUnescape = new String[savedCounter + 1];
        String[] commandSplit = StringUtils.splitAndUnescape((String)savedCommands);
        int i = 0;
        while (i < commandSplit.length) {
            splitAndUnescape[i] = commandSplit[i];
            ++i;
        }
        splitAndUnescape[splitAndUnescape.length - 1] = command;
        return splitAndUnescape;
    }

    private String[] splitAndRemoveLast(String savedCommands, String command) {
        String[] splitAndUnescape = StringUtils.splitAndUnescape((String)savedCommands);
        int i = 0;
        while (i < splitAndUnescape.length - 1) {
            splitAndUnescape[i] = splitAndUnescape[i + 1];
            ++i;
        }
        splitAndUnescape[splitAndUnescape.length - 1] = command;
        return splitAndUnescape;
    }
}

