/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor;

import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescriptionPersistenceHandler;
import de.rcenvironment.core.gui.workflow.editor.Messages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class NewWorkflowWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;
    private NewWorkflowPage mainPage;

    public boolean performFinish() {
        IFile file = this.mainPage.createNewFile();
        WorkflowDescription wd = new WorkflowDescription(UUID.randomUUID().toString());
        WorkflowDescriptionPersistenceHandler wdHandler = new WorkflowDescriptionPersistenceHandler();
        try {
            file.setContents((InputStream)new ByteArrayInputStream(wdHandler.writeWorkflowDescriptionToStream(wd).toByteArray()), 0, null);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return file != null;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.selection = currentSelection;
        this.setWindowTitle(Messages.newWorkflow);
    }

    public void addPages() {
        this.mainPage = new NewWorkflowPage(this.selection);
        this.addPage((IWizardPage)this.mainPage);
    }

    class NewWorkflowPage
    extends WizardNewFileCreationPage {
        NewWorkflowPage(IStructuredSelection selection) {
            super("NewWorkflowPage", selection);
            this.setFileExtension("wf");
            this.setDescription(Messages.createWorkflow);
            this.setTitle(Messages.fileWorkflow);
        }
    }
}

