/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.core.setup;

import de.rcenvironment.toolkit.core.api.Toolkit;
import de.rcenvironment.toolkit.core.api.ToolkitException;
import de.rcenvironment.toolkit.core.internal.PicoContainerObjectGraph;
import de.rcenvironment.toolkit.core.internal.ToolkitBuilderImpl;
import de.rcenvironment.toolkit.core.internal.ToolkitInstanceTracker;
import de.rcenvironment.toolkit.core.setup.ToolkitConfiguration;

public final class ToolkitFactory {
    private ToolkitFactory() {
    }

    public static Toolkit create(ToolkitConfiguration toolkitConfiguration) throws ToolkitException {
        ToolkitBuilderImpl builder = ToolkitFactory.createBuilder();
        toolkitConfiguration.configure(builder);
        Toolkit newInstance = builder.create();
        ToolkitInstanceTracker.getInstance().register(newInstance);
        return newInstance;
    }

    private static ToolkitBuilderImpl createBuilder() throws ToolkitException {
        if (ToolkitFactory.testForClass("org.picocontainer.PicoContainer")) {
            return new ToolkitBuilderImpl(new PicoContainerObjectGraph());
        }
        throw new ToolkitException("No supported dependency injection library (currently: PicoContainer 2.x) found in classpath");
    }

    private static boolean testForClass(String className) {
        try {
            Class.forName(className, false, ToolkitFactory.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

