/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.model.api;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointGroupDescription;
import de.rcenvironment.core.component.model.spi.PropertiesChangeSupport;
import de.rcenvironment.core.component.workflow.model.api.Location;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Connection
extends PropertiesChangeSupport
implements Serializable,
Comparable<Connection> {
    public static final String PROPERTY_BENDPOINT = "de.rcenvironment.bendpoint";
    private static final long serialVersionUID = 6019856436149503867L;
    private final WorkflowNode sourceWorkflowNode;
    private final EndpointDescription outputEndpointDescription;
    private final WorkflowNode targetWorkflowNode;
    private final EndpointDescription inputEndpointDescription;
    private List<Location> bendpoints = new ArrayList<Location>();

    public Connection(WorkflowNode source, EndpointDescription output, WorkflowNode target, EndpointDescription input) {
        this.sourceWorkflowNode = source;
        this.outputEndpointDescription = output;
        this.targetWorkflowNode = target;
        this.inputEndpointDescription = input;
    }

    public Connection(WorkflowNode source, EndpointDescription output, WorkflowNode target, EndpointDescription input, List<Location> bendpoints) {
        this.sourceWorkflowNode = source;
        this.outputEndpointDescription = output;
        this.targetWorkflowNode = target;
        this.inputEndpointDescription = input;
        this.bendpoints = new ArrayList<Location>(bendpoints);
    }

    public WorkflowNode getSourceNode() {
        return this.sourceWorkflowNode;
    }

    public EndpointDescription getOutput() {
        return this.outputEndpointDescription;
    }

    public WorkflowNode getTargetNode() {
        return this.targetWorkflowNode;
    }

    public EndpointDescription getInput() {
        return this.inputEndpointDescription;
    }

    public boolean equals(Object o) {
        Connection c;
        boolean equals = false;
        if (o instanceof Connection && (c = (Connection)o).getTargetNode().getIdentifier().equals(this.targetWorkflowNode.getIdentifier()) && c.getSourceNode().getIdentifier().equals(this.sourceWorkflowNode.getIdentifier()) && this.inputEndpointDescription.getIdentifier().equals(c.getInput().getIdentifier()) && this.outputEndpointDescription.getIdentifier().equals(c.getOutput().getIdentifier())) {
            equals = true;
        }
        return equals;
    }

    public int hashCode() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.targetWorkflowNode.getIdentifier());
        builder.append(this.sourceWorkflowNode.getIdentifier());
        builder.append(this.inputEndpointDescription.getIdentifier());
        builder.append(this.outputEndpointDescription.getIdentifier());
        return builder.toString().hashCode();
    }

    public void addBendpoints(List<Location> locations) {
        int i = 0;
        while (i < locations.size()) {
            this.bendpoints.add(i, new Location(locations.get((int)i).x, locations.get((int)i).y));
            ++i;
        }
        this.firePropertyChange(PROPERTY_BENDPOINT);
    }

    public void addBendpoint(int index, int x, int y, boolean inverse) {
        int indexToUse = new Integer(index);
        if (inverse) {
            indexToUse = this.bendpoints.size() - indexToUse;
        }
        boolean alreadyExistent = false;
        for (Location location : this.bendpoints) {
            if (location.x != x || location.y != y) continue;
            alreadyExistent = true;
        }
        if (!alreadyExistent) {
            this.bendpoints.add(indexToUse, new Location(x, y));
            this.firePropertyChange(PROPERTY_BENDPOINT);
        }
    }

    public void removeBendpoint(int index, boolean inverse) {
        int indexToUse = new Integer(index);
        if (inverse) {
            indexToUse = this.bendpoints.size() - indexToUse - 1;
        }
        if (indexToUse >= 0 && indexToUse < this.bendpoints.size() && this.bendpoints.size() > 0) {
            this.bendpoints.remove(indexToUse);
        }
        this.firePropertyChange(PROPERTY_BENDPOINT);
    }

    public void setBendpoint(int index, int x, int y, boolean inverse) {
        int indexToUse = new Integer(index);
        if (inverse) {
            indexToUse = this.bendpoints.size() - indexToUse - 1;
        }
        if (indexToUse >= 0 && indexToUse <= this.bendpoints.size() && this.bendpoints.size() > 0) {
            Location location = new Location(x, y);
            this.bendpoints.set(indexToUse, location);
        }
        this.firePropertyChange(PROPERTY_BENDPOINT);
    }

    public void removeBendpoint(int index) {
        this.bendpoints.remove(index);
        this.firePropertyChange(PROPERTY_BENDPOINT);
    }

    public Location getBendpoint(int index) {
        return this.bendpoints.get(index);
    }

    public List<Location> getBendpoints() {
        if (this.bendpoints != null) {
            return new ArrayList<Location>(this.bendpoints);
        }
        return null;
    }

    public void setBendpoints(List<Location> bendpoints) {
        this.bendpoints = new ArrayList<Location>(bendpoints);
        this.firePropertyChange(PROPERTY_BENDPOINT);
    }

    public void setBendpoint(int index, int x, int y) {
        Location location = new Location(x, y);
        this.bendpoints.set(index, location);
        this.firePropertyChange(PROPERTY_BENDPOINT);
    }

    public void removeAllBendpoints() {
        this.bendpoints = new ArrayList<Location>();
        this.firePropertyChange(PROPERTY_BENDPOINT);
    }

    @Override
    public int compareTo(Connection o) {
        int result = this.getSourceNode().compareTo(o.getSourceNode());
        if (result == 0 && (result = this.getOutput().compareTo((EndpointGroupDescription)o.getOutput())) == 0 && (result = this.getTargetNode().compareTo(o.getTargetNode())) == 0) {
            result = this.getInput().compareTo((EndpointGroupDescription)o.getInput());
        }
        return result;
    }
}

