/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.model.impl;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.communication.model.InitialNodeInformation;
import de.rcenvironment.core.utils.common.StringUtils;

public class InitialNodeInformationImpl
implements InitialNodeInformation {
    private static final long serialVersionUID = 6729868652469869965L;
    private transient InstanceNodeSessionId instanceSessionIdObject;
    private String instanceSessionId;
    private String displayName;

    public InitialNodeInformationImpl() {
    }

    public InitialNodeInformationImpl(InstanceNodeSessionId localInstanceSessionId) {
        this.instanceSessionIdObject = localInstanceSessionId;
        this.instanceSessionId = localInstanceSessionId.getInstanceNodeSessionIdString();
    }

    public InitialNodeInformationImpl(String id) {
        this.instanceSessionId = id;
    }

    @Override
    public String getInstanceNodeSessionIdString() {
        return this.instanceSessionId;
    }

    public void setNodeId(String nodeId) {
        this.instanceSessionId = nodeId;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public synchronized InstanceNodeSessionId getInstanceNodeSessionId() {
        if (this.instanceSessionIdObject == null) {
            this.instanceSessionIdObject = NodeIdentifierUtils.parseInstanceNodeSessionIdStringWithExceptionWrapping(this.instanceSessionId);
        }
        return this.instanceSessionIdObject;
    }

    @Override
    public String getLogDescription() {
        String name = this.displayName;
        if (this.displayName == null) {
            this.displayName = "<unnamed>";
        }
        return StringUtils.format((String)"%s [%s]", (Object[])new Object[]{name, this.instanceSessionId});
    }

    private String getInternalFingerprint() {
        return StringUtils.format((String)"%s#%s", (Object[])new Object[]{this.instanceSessionId, this.displayName});
    }

    public String toString() {
        return StringUtils.format((String)"%s/%s", (Object[])new Object[]{this.instanceSessionId, this.displayName});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InitialNodeInformationImpl)) {
            return false;
        }
        return this.getInternalFingerprint().equals(((InitialNodeInformationImpl)obj).getInternalFingerprint());
    }

    public int hashCode() {
        return this.getInternalFingerprint().hashCode();
    }
}

