/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.text;

import com.googlecode.lanterna.input.CommonProfile;
import com.googlecode.lanterna.terminal.Terminal;
import com.googlecode.lanterna.terminal.TerminalSize;
import com.googlecode.lanterna.terminal.text.StreamBasedTerminal;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public abstract class ANSITerminal
extends StreamBasedTerminal {
    public ANSITerminal(InputStream terminalInput, OutputStream terminalOutput, Charset terminalCharset) {
        super(terminalInput, terminalOutput, terminalCharset);
        this.addInputProfile(new CommonProfile());
    }

    private void CSI() {
        this.writeToTerminal(27, 91);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public TerminalSize queryTerminalSize() {
        Object object = this.writerMutex;
        synchronized (object) {
            this.saveCursorPosition();
            this.moveCursor(5000, 5000);
            this.reportPosition();
            this.restoreCursorPosition();
        }
        return this.getLastKnownSize();
    }

    @Override
    public TerminalSize getTerminalSize() {
        this.queryTerminalSize();
        return this.waitForTerminalSizeReport(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyBackgroundColor(Terminal.Color color) {
        Object object = this.writerMutex;
        synchronized (object) {
            this.CSI();
            this.writeToTerminal(52, (byte)(color.getIndex() + "").charAt(0), 109);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyBackgroundColor(int r, int g, int b) {
        if (r < 0 || r > 255) {
            throw new IllegalArgumentException("applyForegroundColor: r is outside of valid range (0-255)");
        }
        if (g < 0 || g > 255) {
            throw new IllegalArgumentException("applyForegroundColor: g is outside of valid range (0-255)");
        }
        if (b < 0 || b > 255) {
            throw new IllegalArgumentException("applyForegroundColor: b is outside of valid range (0-255)");
        }
        Object object = this.writerMutex;
        synchronized (object) {
            this.CSI();
            String asString = "48;2;" + r + ";" + g + ";" + b + "m";
            for (int i = 0; i < asString.length(); ++i) {
                this.writeToTerminal((byte)asString.charAt(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyBackgroundColor(int index) {
        if (index < 0 || index > 255) {
            throw new IllegalArgumentException("applyBackgroundColor: index is outside of valid range (0-255)");
        }
        Object object = this.writerMutex;
        synchronized (object) {
            this.CSI();
            String asString = "48;5;" + index + "m";
            for (int i = 0; i < asString.length(); ++i) {
                this.writeToTerminal((byte)asString.charAt(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyForegroundColor(Terminal.Color color) {
        Object object = this.writerMutex;
        synchronized (object) {
            this.CSI();
            this.writeToTerminal(51, (byte)(color.getIndex() + "").charAt(0), 109);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyForegroundColor(int r, int g, int b) {
        if (r < 0 || r > 255) {
            throw new IllegalArgumentException("applyForegroundColor: r is outside of valid range (0-255)");
        }
        if (g < 0 || g > 255) {
            throw new IllegalArgumentException("applyForegroundColor: g is outside of valid range (0-255)");
        }
        if (b < 0 || b > 255) {
            throw new IllegalArgumentException("applyForegroundColor: b is outside of valid range (0-255)");
        }
        Object object = this.writerMutex;
        synchronized (object) {
            this.CSI();
            String asString = "38;2;" + r + ";" + g + ";" + b + "m";
            for (int i = 0; i < asString.length(); ++i) {
                this.writeToTerminal((byte)asString.charAt(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyForegroundColor(int index) {
        if (index < 0 || index > 255) {
            throw new IllegalArgumentException("applyForegroundColor: index is outside of valid range (0-255)");
        }
        Object object = this.writerMutex;
        synchronized (object) {
            this.CSI();
            String asString = "38;5;" + index + "m";
            for (int i = 0; i < asString.length(); ++i) {
                this.writeToTerminal((byte)asString.charAt(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applySGR(Terminal.SGR ... options) {
        Object object = this.writerMutex;
        synchronized (object) {
            this.CSI();
            int index = 0;
            for (Terminal.SGR sgr : options) {
                switch (sgr) {
                    case ENTER_BOLD: {
                        this.writeToTerminal(49);
                        break;
                    }
                    case ENTER_REVERSE: {
                        this.writeToTerminal(55);
                        break;
                    }
                    case ENTER_UNDERLINE: {
                        this.writeToTerminal(52);
                        break;
                    }
                    case EXIT_BOLD: {
                        this.writeToTerminal(50, 50);
                        break;
                    }
                    case EXIT_REVERSE: {
                        this.writeToTerminal(50, 55);
                        break;
                    }
                    case EXIT_UNDERLINE: {
                        this.writeToTerminal(50, 52);
                        break;
                    }
                    case ENTER_BLINK: {
                        this.writeToTerminal(53);
                        break;
                    }
                    case RESET_ALL: {
                        this.writeToTerminal(48);
                    }
                }
                if (index++ >= options.length - 1) continue;
                this.writeToTerminal(59);
            }
            this.writeToTerminal(109);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearScreen() {
        Object object = this.writerMutex;
        synchronized (object) {
            this.CSI();
            this.writeToTerminal(50, 74);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enterPrivateMode() {
        Object object = this.writerMutex;
        synchronized (object) {
            this.CSI();
            this.writeToTerminal(63, 49, 48, 52, 57, 104);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitPrivateMode() {
        Object object = this.writerMutex;
        synchronized (object) {
            this.applySGR(Terminal.SGR.RESET_ALL);
            this.setCursorVisible(true);
            this.CSI();
            this.writeToTerminal(63, 49, 48, 52, 57, 108);
        }
    }

    public abstract void setEcho(boolean var1);

    public abstract void setCBreak(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveCursor(int x, int y) {
        Object object = this.writerMutex;
        synchronized (object) {
            this.CSI();
            this.writeToTerminal((y + 1 + "").getBytes());
            this.writeToTerminal(59);
            this.writeToTerminal((x + 1 + "").getBytes());
            this.writeToTerminal(72);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursorVisible(boolean visible) {
        Object object = this.writerMutex;
        synchronized (object) {
            this.CSI();
            this.writeToTerminal(63);
            this.writeToTerminal(50);
            this.writeToTerminal(53);
            if (visible) {
                this.writeToTerminal(104);
            } else {
                this.writeToTerminal(108);
            }
        }
    }

    protected void reportPosition() {
        this.CSI();
        this.writeToTerminal("6n".getBytes());
    }

    protected void restoreCursorPosition() {
        this.CSI();
        this.writeToTerminal("u".getBytes());
    }

    protected void saveCursorPosition() {
        this.CSI();
        this.writeToTerminal("s".getBytes());
    }
}

