/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.layout;

import com.googlecode.lanterna.gui.Component;
import com.googlecode.lanterna.gui.component.Panel;
import com.googlecode.lanterna.gui.layout.DefaultLaidOutComponent;
import com.googlecode.lanterna.gui.layout.LayoutManager;
import com.googlecode.lanterna.gui.layout.LayoutParameter;
import com.googlecode.lanterna.terminal.TerminalPosition;
import com.googlecode.lanterna.terminal.TerminalSize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class LinearLayout
implements LayoutManager {
    public static final LayoutParameter MAXIMIZES_HORIZONTALLY = new LayoutParameter("LinearLayout.MAXIMIZES_HORIZONTALLY");
    public static final LayoutParameter MAXIMIZES_VERTICALLY = new LayoutParameter("LinearLayout.MAXIMIZES_VERTICALLY");
    public static final LayoutParameter GROWS_HORIZONTALLY = new LayoutParameter("LinearLayout.GROWS_HORIZONTALLY");
    public static final LayoutParameter GROWS_VERTICALLY = new LayoutParameter("LinearLayout.GROWS_VERTICALLY");
    private final List<LinearLayoutComponent> componentList = new ArrayList<LinearLayoutComponent>();
    private int padding = 0;

    LinearLayout() {
    }

    @Override
    public void addComponent(Component component, LayoutParameter ... layoutParameters) {
        HashSet<LayoutParameter> asSet = new HashSet<LayoutParameter>(Arrays.asList(layoutParameters));
        if (asSet.contains(MAXIMIZES_HORIZONTALLY) && asSet.contains(GROWS_HORIZONTALLY)) {
            throw new IllegalArgumentException("Component " + component + " cannot be both maximizing and growing horizontally at the same time");
        }
        if (asSet.contains(MAXIMIZES_VERTICALLY) && asSet.contains(GROWS_VERTICALLY)) {
            throw new IllegalArgumentException("Component " + component + " cannot be both maximizing and growing vertically at the same time");
        }
        this.componentList.add(new LinearLayoutComponent(component, asSet));
    }

    @Override
    public void removeComponent(Component component) {
        Iterator<LinearLayoutComponent> iterator = this.componentList.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().component != component) continue;
            iterator.remove();
            return;
        }
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    @Override
    public TerminalSize getPreferredSize() {
        if (this.componentList.isEmpty()) {
            return new TerminalSize(0, 0);
        }
        TerminalSize preferredSize = new TerminalSize(0, 0);
        for (LinearLayoutComponent axisLayoutComponent : this.componentList) {
            TerminalSize componentPreferredSize = axisLayoutComponent.component.getPreferredSize();
            this.setMajorAxis(preferredSize, this.getMajorAxis(preferredSize) + this.getMajorAxis(componentPreferredSize));
            this.setMinorAxis(preferredSize, Math.max(this.getMinorAxis(preferredSize), this.getMinorAxis(componentPreferredSize)));
        }
        this.setMajorAxis(preferredSize, this.getMajorAxis(preferredSize) + this.padding * (this.componentList.size() - 1));
        return preferredSize;
    }

    @Override
    public List<? extends LayoutManager.LaidOutComponent> layout(TerminalSize layoutArea) {
        ArrayList<DefaultLaidOutComponent> result = new ArrayList<DefaultLaidOutComponent>();
        IdentityHashMap<Component, TerminalSize> minimumSizeMap = new IdentityHashMap<Component, TerminalSize>();
        IdentityHashMap<Component, TerminalSize> preferredSizeMap = new IdentityHashMap<Component, TerminalSize>();
        IdentityHashMap<Component, Set<LayoutParameter>> layoutParameterMap = new IdentityHashMap<Component, Set<LayoutParameter>>();
        for (LinearLayoutComponent llc : this.componentList) {
            minimumSizeMap.put(llc.component, llc.component.getMinimumSize());
            preferredSizeMap.put(llc.component, llc.component.getPreferredSize());
            layoutParameterMap.put(llc.component, llc.layoutParameters);
        }
        int availableMajorAxisSpace = this.getMajorAxis(layoutArea);
        int availableMinorAxisSpace = this.getMinorAxis(layoutArea);
        for (LinearLayoutComponent llc : this.componentList) {
            result.add(new DefaultLaidOutComponent(llc.component, new TerminalSize(0, 0), new TerminalPosition(0, 0)));
        }
        for (DefaultLaidOutComponent lloc : result) {
            if (((Set)layoutParameterMap.get(lloc.component)).contains(this.getMinorMaximizesParameter()) || ((Set)layoutParameterMap.get(lloc.component)).contains(this.getMinorGrowingParameter()) || lloc.component instanceof Panel && this.maximisesOnMinorAxis((Panel)lloc.component)) {
                this.setMinorAxis(lloc.size, availableMinorAxisSpace);
                continue;
            }
            int preferred = this.getMinorAxis((TerminalSize)preferredSizeMap.get(lloc.component));
            this.setMinorAxis(lloc.size, preferred <= availableMinorAxisSpace ? preferred : availableMinorAxisSpace);
        }
        while (availableMajorAxisSpace > 0) {
            boolean changedSomething = false;
            for (DefaultLaidOutComponent lloc : result) {
                int preferred = this.getMajorAxis((TerminalSize)preferredSizeMap.get(lloc.component));
                if (availableMajorAxisSpace <= 0 || preferred <= this.getMajorAxis(lloc.getSize())) continue;
                --availableMajorAxisSpace;
                this.setMajorAxis(lloc.getSize(), this.getMajorAxis(lloc.getSize()) + 1);
                changedSomething = true;
            }
            if (changedSomething) continue;
            break;
        }
        availableMajorAxisSpace -= (result.size() - 1) * this.padding;
        ArrayList<DefaultLaidOutComponent> growingComponents = new ArrayList<DefaultLaidOutComponent>();
        for (DefaultLaidOutComponent lloc : result) {
            if (((Set)layoutParameterMap.get(lloc.component)).contains(this.getMajorMaximizesParameter()) || ((Set)layoutParameterMap.get(lloc.component)).contains(this.getMajorGrowingParameter())) {
                growingComponents.add(lloc);
            }
            if (!(lloc.component instanceof Panel) || !this.maximisesOnMajorAxis((Panel)lloc.component)) continue;
            growingComponents.add(lloc);
        }
        while (availableMajorAxisSpace > 0 && !growingComponents.isEmpty()) {
            for (DefaultLaidOutComponent lloc : growingComponents) {
                if (availableMajorAxisSpace <= 0) continue;
                --availableMajorAxisSpace;
                this.setMajorAxis(lloc.getSize(), this.getMajorAxis(lloc.getSize()) + 1);
            }
        }
        int nextMajorPosition = 0;
        for (DefaultLaidOutComponent laidOutComponent : result) {
            this.setMajorAxis(laidOutComponent.topLeftPosition, nextMajorPosition);
            if (result.get(result.size() - 1) != laidOutComponent) {
                nextMajorPosition += this.getMajorAxis(laidOutComponent.size) + this.padding;
                continue;
            }
            nextMajorPosition += this.getMajorAxis(laidOutComponent.size);
        }
        return result;
    }

    @Override
    public boolean maximisesHorisontally() {
        for (LinearLayoutComponent llc : this.componentList) {
            if (!llc.layoutParameters.contains(MAXIMIZES_HORIZONTALLY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean maximisesVertically() {
        for (LinearLayoutComponent llc : this.componentList) {
            if (!llc.layoutParameters.contains(MAXIMIZES_VERTICALLY)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean maximisesOnMajorAxis(Panel var1);

    protected abstract boolean maximisesOnMinorAxis(Panel var1);

    protected abstract void setMajorAxis(TerminalSize var1, int var2);

    protected abstract void setMinorAxis(TerminalSize var1, int var2);

    protected abstract void setMajorAxis(TerminalPosition var1, int var2);

    protected abstract int getMajorAxis(TerminalSize var1);

    protected abstract int getMinorAxis(TerminalSize var1);

    protected abstract LayoutParameter getMajorMaximizesParameter();

    protected abstract LayoutParameter getMinorMaximizesParameter();

    protected abstract LayoutParameter getMajorGrowingParameter();

    protected abstract LayoutParameter getMinorGrowingParameter();

    protected List<Panel> getSubPanels() {
        ArrayList<Panel> subPanels = new ArrayList<Panel>();
        for (LinearLayoutComponent axisLayoutComponent : this.componentList) {
            if (!(axisLayoutComponent.component instanceof Panel)) continue;
            subPanels.add((Panel)axisLayoutComponent.component);
        }
        return subPanels;
    }

    protected static class LinearLayoutComponent {
        public Component component;
        public Set<LayoutParameter> layoutParameters;

        public LinearLayoutComponent(Component component, Set<LayoutParameter> layoutParameters) {
            this.component = component;
            this.layoutParameters = layoutParameters;
        }
    }
}

