/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.component;

import com.googlecode.lanterna.gui.TextGraphics;
import com.googlecode.lanterna.gui.Theme;
import com.googlecode.lanterna.gui.component.AbstractComponent;
import com.googlecode.lanterna.screen.ScreenCharacterStyle;
import com.googlecode.lanterna.terminal.Terminal;
import com.googlecode.lanterna.terminal.TerminalSize;
import java.util.Arrays;

public class Label
extends AbstractComponent {
    private String[] text;
    private int height;
    private int width;
    private int forceWidth;
    private Boolean textBold;
    private Terminal.Color textColor;
    private Theme.Category style;

    public Label() {
        this("");
    }

    public Label(String text) {
        this(text, -1);
    }

    public Label(String text, Terminal.Color textColor) {
        this(text, textColor, null);
    }

    public Label(String text, Boolean textBold) {
        this(text, null, textBold);
    }

    public Label(String text, Terminal.Color textColor, Boolean textBold) {
        this(text, -1, textColor, textBold);
    }

    public Label(String text, int fixedWidth) {
        this(text, fixedWidth, null, null);
    }

    public Label(String text, int fixedWidth, Terminal.Color color, Boolean textBold) {
        this.text = text == null ? new String[]{"null"} : text.split("\n");
        this.textColor = color;
        this.textBold = textBold;
        this.height = 0;
        this.width = 0;
        this.forceWidth = fixedWidth;
        this.style = Theme.Category.DIALOG_AREA;
        this.updateMetrics();
    }

    @Override
    protected TerminalSize calculatePreferredSize() {
        if (this.forceWidth == -1) {
            return new TerminalSize(this.width, this.height);
        }
        return new TerminalSize(this.forceWidth, this.height);
    }

    @Override
    public void repaint(TextGraphics graphics) {
        graphics.applyTheme(graphics.getTheme().getDefinition(this.style));
        graphics = this.transformAccordingToAlignment(graphics, this.calculatePreferredSize());
        if (this.textColor != null) {
            graphics.setForegroundColor(this.textColor);
        }
        if (this.textBold != null) {
            if (this.textBold.booleanValue()) {
                graphics.setBoldMask(true);
            } else {
                graphics.setBoldMask(false);
            }
        }
        if (this.text.length == 0) {
            return;
        }
        int leftPosition = 0;
        for (int i = 0; i < this.text.length; ++i) {
            if (this.forceWidth > -1) {
                if (this.text[i].length() > this.forceWidth) {
                    graphics.drawString(leftPosition, i, this.text[i].substring(0, this.forceWidth - 3) + "...", new ScreenCharacterStyle[0]);
                    continue;
                }
                graphics.drawString(leftPosition, i, this.text[i], new ScreenCharacterStyle[0]);
                continue;
            }
            graphics.drawString(leftPosition, i, this.text[i], new ScreenCharacterStyle[0]);
        }
    }

    public void setText(String text) {
        this.text = text.split("\n");
        this.updateMetrics();
        this.invalidate();
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        for (String line : this.text) {
            sb.append(line).append("\n");
        }
        sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }

    public String[] getLines() {
        return Arrays.copyOf(this.text, this.text.length);
    }

    public void setStyle(Theme.Category style) {
        this.style = style;
        this.invalidate();
    }

    public Theme.Category getStyle() {
        return this.style;
    }

    public Terminal.Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Terminal.Color textColor) {
        this.textColor = textColor;
        this.invalidate();
    }

    private void updateMetrics() {
        this.height = this.text.length;
        if (this.height == 0) {
            this.height = 1;
        }
        this.width = 0;
        for (String line : this.text) {
            if (line.length() <= this.width) continue;
            this.width = line.length();
        }
    }
}

