/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.component;

import com.googlecode.lanterna.gui.Interactable;
import com.googlecode.lanterna.gui.TextGraphics;
import com.googlecode.lanterna.gui.Theme;
import com.googlecode.lanterna.gui.component.AbstractInteractableComponent;
import com.googlecode.lanterna.input.Key;
import com.googlecode.lanterna.screen.ScreenCharacterStyle;
import com.googlecode.lanterna.terminal.TerminalPosition;
import com.googlecode.lanterna.terminal.TerminalSize;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractListBox
extends AbstractInteractableComponent {
    private final List<Object> items = new ArrayList<Object>();
    private TerminalSize preferredSizeOverride;
    private int selectedIndex;
    private int scrollTopIndex;
    private int pageSize;

    public AbstractListBox() {
        this(null);
    }

    public AbstractListBox(TerminalSize preferredSize) {
        this.preferredSizeOverride = preferredSize;
        this.selectedIndex = -1;
        this.scrollTopIndex = 0;
        this.pageSize = 1;
    }

    @Override
    protected TerminalSize calculatePreferredSize() {
        if (this.preferredSizeOverride != null) {
            return this.preferredSizeOverride;
        }
        int maxWidth = 5;
        for (int i = 0; i < this.items.size(); ++i) {
            String itemString = this.createItemString(i);
            if (itemString.length() <= maxWidth) continue;
            maxWidth = itemString.length();
        }
        return new TerminalSize(maxWidth + 1, this.items.size());
    }

    protected void addItem(Object item) {
        if (item == null) {
            return;
        }
        this.items.add(item);
        if (this.selectedIndex == -1) {
            this.selectedIndex = 0;
        }
        this.invalidate();
    }

    public void clearItems() {
        this.items.clear();
        this.selectedIndex = -1;
        this.invalidate();
    }

    public int indexOf(Object item) {
        return this.items.indexOf(item);
    }

    public int getSize() {
        return this.items.size();
    }

    public Object getItemAt(int index) {
        return this.items.get(index);
    }

    public int getNrOfItems() {
        return this.items.size();
    }

    public void setSelectedItem(int index) {
        this.selectedIndex = index;
        this.invalidate();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Object getSelectedItem() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.items.get(this.selectedIndex);
    }

    @Override
    public boolean isScrollable() {
        return true;
    }

    @Override
    public void repaint(TextGraphics graphics) {
        int i;
        this.pageSize = graphics.getHeight();
        if (this.selectedIndex != -1) {
            if (this.selectedIndex < this.scrollTopIndex) {
                this.scrollTopIndex = this.selectedIndex;
            } else if (this.selectedIndex >= graphics.getHeight() + this.scrollTopIndex) {
                this.scrollTopIndex = this.selectedIndex - graphics.getHeight() + 1;
            }
        }
        if (this.items.size() > graphics.getHeight() && this.items.size() - this.scrollTopIndex < graphics.getHeight()) {
            this.scrollTopIndex = this.items.size() - graphics.getHeight();
        }
        graphics.applyTheme(this.getListItemThemeDefinition(graphics.getTheme()));
        graphics.fillArea(' ');
        for (i = this.scrollTopIndex; i < this.items.size() && i - this.scrollTopIndex < graphics.getHeight(); ++i) {
            if (i == this.selectedIndex && this.hasFocus()) {
                graphics.applyTheme(this.getSelectedListItemThemeDefinition(graphics.getTheme()));
            } else {
                graphics.applyTheme(this.getListItemThemeDefinition(graphics.getTheme()));
            }
            this.printItem(graphics, 0, 0 + i - this.scrollTopIndex, i);
        }
        if (this.items.size() > graphics.getHeight()) {
            graphics.applyTheme(Theme.Category.DIALOG_AREA);
            graphics.drawString(graphics.getWidth() - 1, 0, "\u2191", new ScreenCharacterStyle[0]);
            graphics.applyTheme(Theme.Category.DIALOG_AREA);
            for (i = 1; i < graphics.getHeight() - 1; ++i) {
                graphics.drawString(graphics.getWidth() - 1, i, "\u2592", new ScreenCharacterStyle[0]);
            }
            graphics.applyTheme(Theme.Category.DIALOG_AREA);
            graphics.drawString(graphics.getWidth() - 1, graphics.getHeight() - 1, "\u2193", new ScreenCharacterStyle[0]);
            int scrollableSize = this.items.size() - graphics.getHeight();
            double position = (double)this.scrollTopIndex / (double)scrollableSize;
            int tickPosition = (int)(((double)graphics.getHeight() - 3.0) * position);
            graphics.applyTheme(Theme.Category.SHADOW);
            graphics.drawString(graphics.getWidth() - 1, 1 + tickPosition, " ", new ScreenCharacterStyle[0]);
        }
        if (this.selectedIndex == -1 || this.items.isEmpty()) {
            this.setHotspot(new TerminalPosition(0, 0));
        } else {
            this.setHotspot(graphics.translateToGlobalCoordinates(new TerminalPosition(this.getHotSpotPositionOnLine(this.selectedIndex), this.selectedIndex - this.scrollTopIndex)));
        }
    }

    @Override
    protected void afterEnteredFocus(Interactable.FocusChangeDirection direction) {
        if (this.items.isEmpty()) {
            return;
        }
        if (direction == Interactable.FocusChangeDirection.DOWN) {
            this.selectedIndex = 0;
        } else if (direction == Interactable.FocusChangeDirection.UP) {
            this.selectedIndex = this.items.size() - 1;
        }
    }

    protected Theme.Definition getSelectedListItemThemeDefinition(Theme theme) {
        return theme.getDefinition(Theme.Category.LIST_ITEM_SELECTED);
    }

    protected Theme.Definition getListItemThemeDefinition(Theme theme) {
        return theme.getDefinition(Theme.Category.LIST_ITEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Interactable.Result keyboardInteraction(Key key) {
        try {
            switch (key.getKind()) {
                case Tab: 
                case ArrowRight: {
                    Interactable.Result result = Interactable.Result.NEXT_INTERACTABLE_RIGHT;
                    return result;
                }
                case ReverseTab: 
                case ArrowLeft: {
                    Interactable.Result result = Interactable.Result.PREVIOUS_INTERACTABLE_LEFT;
                    return result;
                }
                case ArrowDown: {
                    if (this.items.isEmpty() || this.selectedIndex == this.items.size() - 1) {
                        Interactable.Result result = Interactable.Result.NEXT_INTERACTABLE_DOWN;
                        return result;
                    }
                    ++this.selectedIndex;
                    break;
                }
                case ArrowUp: {
                    if (this.items.isEmpty() || this.selectedIndex == 0) {
                        Interactable.Result result = Interactable.Result.PREVIOUS_INTERACTABLE_UP;
                        return result;
                    }
                    --this.selectedIndex;
                    if (this.selectedIndex - this.scrollTopIndex >= 0) break;
                    --this.scrollTopIndex;
                    break;
                }
                case Home: {
                    this.selectedIndex = 0;
                    break;
                }
                case End: {
                    this.selectedIndex = this.items.size() - 1;
                    break;
                }
                case PageUp: {
                    this.selectedIndex -= this.pageSize;
                    if (this.selectedIndex >= 0) break;
                    this.selectedIndex = 0;
                    break;
                }
                case PageDown: {
                    this.selectedIndex += this.pageSize;
                    if (this.selectedIndex <= this.items.size() - 1) break;
                    this.selectedIndex = this.items.size() - 1;
                    break;
                }
                default: {
                    Interactable.Result result = this.unhandledKeyboardEvent(key);
                    return result;
                }
            }
            Interactable.Result result = Interactable.Result.EVENT_HANDLED;
            return result;
        }
        finally {
            this.invalidate();
        }
    }

    protected void printItem(TextGraphics graphics, int x, int y, int index) {
        String asText = this.createItemString(index);
        if (asText.length() > graphics.getWidth()) {
            asText = asText.substring(0, graphics.getWidth());
        }
        graphics.drawString(x, y, asText, new ScreenCharacterStyle[0]);
    }

    protected Interactable.Result unhandledKeyboardEvent(Key key) {
        return Interactable.Result.EVENT_NOT_HANDLED;
    }

    protected int getHotSpotPositionOnLine(int selectedIndex) {
        return 0;
    }

    protected abstract String createItemString(int var1);
}

