/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.views.contributors;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.spi.NetworkTopologyChangeListener;
import de.rcenvironment.core.communication.spi.NetworkTopologyChangeListenerAdapter;
import de.rcenvironment.core.gui.communication.views.NetworkViewContentProvider;
import de.rcenvironment.core.gui.communication.views.contributors.NetworkViewContributorBase;
import de.rcenvironment.core.gui.communication.views.model.NetworkGraphNodeWithContext;
import de.rcenvironment.core.gui.communication.views.spi.ContributedNetworkViewNode;
import de.rcenvironment.core.gui.communication.views.spi.ContributedNetworkViewNodeWithParent;
import de.rcenvironment.core.gui.communication.views.spi.NetworkViewContributor;
import de.rcenvironment.core.gui.communication.views.spi.SelfRenderingNetworkViewNode;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.monitoring.system.api.SystemMonitoringDataPollingManager;
import de.rcenvironment.core.monitoring.system.api.SystemMonitoringDataSnapshotListener;
import de.rcenvironment.core.monitoring.system.api.model.FullSystemAndProcessDataSnapshot;
import de.rcenvironment.core.monitoring.system.api.model.ProcessInformation;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;

public class MonitoringDataContributor
extends NetworkViewContributorBase {
    private static final double DOUBLE_0_01 = 0.01;
    private static final double DOUBLE_0_2 = 0.2;
    private static final double DOUBLE_0_4 = 0.4;
    private static final double DOUBLE_0_6 = 0.6;
    private static final double DOUBLE_0_8 = 0.8;
    private static final double DOUBLE_0_99 = 0.99;
    private static final int MONITORING_DATA_PRIORITY = 15;
    private final Map<InstanceNodeSessionId, ContributedNetworkViewNode> idToNodeMap;
    private final Map<InstanceNodeSessionId, ContributedNetworkViewNode> expansionsMap;
    private final Map<InstanceNodeSessionId, List<RceNode>> nodeIdToRceNodeMap;
    private final Map<InstanceNodeSessionId, List<InstanceResourceInfoNode>> nodeIdToInstanceResourceInfoMap;
    private final SystemMonitoringDataPollingManager pollingManager;
    private final Image cpuMonitorImage0;
    private final Image cpuMonitorImage1;
    private final Image cpuMonitorImage2;
    private final Image cpuMonitorImage3;
    private final Image cpuMonitorImage4;
    private final Image cpuMonitorImage5;
    private final Image cpuMonitorImage6;
    private final Image ramMonitorImage0;
    private final Image ramMonitorImage1;
    private final Image ramMonitorImage2;
    private final Image ramMonitorImage3;
    private final Image ramMonitorImage4;
    private final Image ramMonitorImage5;
    private final Image ramMonitorImage6;
    private final Image sharedFolderImage;
    private final Image dummyImage;
    private final ServiceRegistryPublisherAccess servicePublisher;
    private final Log log = LogFactory.getLog(this.getClass());

    public MonitoringDataContributor() {
        ServiceRegistryAccess serviceAccess = ServiceRegistry.createAccessFor((Object)this);
        CommunicationService communicationService = (CommunicationService)serviceAccess.getService(CommunicationService.class);
        AsyncTaskService asyncTaskService = (AsyncTaskService)serviceAccess.getService(AsyncTaskService.class);
        this.pollingManager = new SystemMonitoringDataPollingManager(communicationService, asyncTaskService);
        this.sharedFolderImage = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.FOLDER_16);
        this.dummyImage = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.INFORMATION_16);
        this.cpuMonitorImage0 = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/cpuMonitor/cpuMonitor0_16.gif")).createImage();
        this.cpuMonitorImage1 = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/cpuMonitor/cpuMonitor1_16.gif")).createImage();
        this.cpuMonitorImage2 = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/cpuMonitor/cpuMonitor2_16.gif")).createImage();
        this.cpuMonitorImage3 = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/cpuMonitor/cpuMonitor3_16.gif")).createImage();
        this.cpuMonitorImage4 = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/cpuMonitor/cpuMonitor4_16.gif")).createImage();
        this.cpuMonitorImage5 = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/cpuMonitor/cpuMonitor5_16.gif")).createImage();
        this.cpuMonitorImage6 = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/cpuMonitor/cpuMonitor6_16.gif")).createImage();
        this.ramMonitorImage0 = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/ramMonitor/ramMonitor0_16.gif")).createImage();
        this.ramMonitorImage1 = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/ramMonitor/ramMonitor1_16.gif")).createImage();
        this.ramMonitorImage2 = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/ramMonitor/ramMonitor2_16.gif")).createImage();
        this.ramMonitorImage3 = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/ramMonitor/ramMonitor3_16.gif")).createImage();
        this.ramMonitorImage4 = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/ramMonitor/ramMonitor4_16.gif")).createImage();
        this.ramMonitorImage5 = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/ramMonitor/ramMonitor5_16.gif")).createImage();
        this.ramMonitorImage6 = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/ramMonitor/ramMonitor6_16.gif")).createImage();
        this.idToNodeMap = new HashMap<InstanceNodeSessionId, ContributedNetworkViewNode>();
        this.expansionsMap = new HashMap<InstanceNodeSessionId, ContributedNetworkViewNode>();
        this.nodeIdToRceNodeMap = new HashMap<InstanceNodeSessionId, List<RceNode>>();
        this.nodeIdToInstanceResourceInfoMap = new HashMap<InstanceNodeSessionId, List<InstanceResourceInfoNode>>();
        this.servicePublisher = ServiceRegistry.createPublisherAccessFor((Object)this);
        this.registerChangeListeners();
    }

    @Override
    public int getRootElementsPriority() {
        return 0;
    }

    @Override
    public Object[] getTopLevelElements(Object parentNode) {
        return null;
    }

    @Override
    public int getInstanceDataElementsPriority() {
        return 15;
    }

    @Override
    public Object[] getChildrenForNetworkInstanceNode(NetworkGraphNodeWithContext instanceNode) {
        Object[] objectArray = new Object[]{new MonitoringDataFolderRootNode(instanceNode)};
        return objectArray;
    }

    @Override
    public boolean hasChildren(Object parentNode) {
        if (parentNode instanceof MonitoringDataFolderRootNode) {
            return true;
        }
        if (parentNode instanceof InstanceResourceInfoNode) {
            return false;
        }
        if (parentNode instanceof RceNode) {
            List<ProcessInformation> children = ((RceNode)parentNode).getChildren();
            return !children.isEmpty();
        }
        if (parentNode instanceof ProcessInfoNode) {
            List<ProcessInformation> children = ((ProcessInfoNode)parentNode).getChildren();
            return !children.isEmpty();
        }
        return false;
    }

    @Override
    public Object[] getChildren(Object parentNode) {
        if (parentNode instanceof MonitoringDataFolderRootNode) {
            return this.createMonitoringRootFolderContent(parentNode);
        }
        if (parentNode instanceof RceNode) {
            return this.createRceNodeFolderContent(parentNode);
        }
        if (parentNode instanceof ProcessInfoNode) {
            return this.createProcessInfoNodeContent(parentNode);
        }
        return null;
    }

    @Override
    public Object getParent(Object node) {
        if (node instanceof MonitoringDataFolderRootNode) {
            return ((MonitoringDataFolderRootNode)node).getInstanceNode();
        }
        return null;
    }

    @Override
    public String getText(Object node) {
        if (node instanceof MonitoringDataFolderRootNode) {
            return "Monitoring Data";
        }
        if (node instanceof InstanceResourceInfoNode) {
            String text;
            InstanceResourceInfoNode infoNode = (InstanceResourceInfoNode)node;
            switch (infoNode.getInstanceNodeContext()) {
                case NODE_CPU_USAGE: {
                    text = StringUtils.format((String)"Total CPU usage: %.2f%% (Non-Instance processes: %.2f%%, Idle: %.2f%%)", (Object[])new Object[]{infoNode.getCpuUsage() * 100.0, infoNode.cpuOther * 100.0, infoNode.cpuIdle * 100.0});
                    break;
                }
                case NODE_RAM_USAGE: {
                    text = StringUtils.format((String)"Total RAM usage: %d / %d MiB", (Object[])new Object[]{infoNode.getRam(), infoNode.ramTotal});
                    break;
                }
                default: {
                    text = "Fail...";
                }
            }
            return text;
        }
        if (node instanceof RceNode) {
            RceNode rce = (RceNode)node;
            if (rce.getTypeIsSubProcessRoot()) {
                return StringUtils.format((String)"RCE Tools CPU Usage: %.2f%%", (Object[])new Object[]{rce.getCpuUsage() * 100.0});
            }
            return StringUtils.format((String)"RCE CPU Usage: %.2f%%", (Object[])new Object[]{rce.getCpuUsage() * 100.0});
        }
        if (node instanceof ProcessInfoNode) {
            ProcessInfoNode processInfo = (ProcessInfoNode)node;
            return StringUtils.format((String)(String.valueOf(processInfo.getProcessInfo().getName()) + ": %.2f%% [%d]"), (Object[])new Object[]{processInfo.getProcessInfo().getCpuUsage() * 100.0, processInfo.getProcessInfo().getPid()});
        }
        return null;
    }

    @Override
    public Image getImage(Object node) {
        if (node instanceof MonitoringDataFolderRootNode || node instanceof RceNode) {
            return this.sharedFolderImage;
        }
        if (node instanceof InstanceResourceInfoNode) {
            InstanceResourceInfoNode infoNode = (InstanceResourceInfoNode)node;
            switch (infoNode.getInstanceNodeContext()) {
                case NODE_CPU_USAGE: {
                    return this.getDynamicCPUImage(infoNode.getCpuUsage());
                }
                case NODE_RAM_USAGE: {
                    return this.getDynamicRamImage(infoNode.getRam(), infoNode.ramTotal);
                }
            }
            return this.dummyImage;
        }
        if (node instanceof ProcessInfoNode) {
            ProcessInfoNode infoNode = (ProcessInfoNode)node;
            return this.getDynamicCPUImage(infoNode.getProcessInfo().getCpuUsage());
        }
        return null;
    }

    private Image getDynamicRamImage(long ram, long ramTotal) {
        double percentage = (float)ram / (float)ramTotal;
        if (percentage > 0.99) {
            return this.ramMonitorImage6;
        }
        if (percentage > 0.8) {
            return this.ramMonitorImage5;
        }
        if (percentage > 0.6) {
            return this.ramMonitorImage4;
        }
        if (percentage > 0.4) {
            return this.ramMonitorImage3;
        }
        if (percentage > 0.2) {
            return this.ramMonitorImage2;
        }
        if (percentage > 0.01) {
            return this.ramMonitorImage1;
        }
        return this.ramMonitorImage0;
    }

    private Image getDynamicCPUImage(double percentage) {
        if (percentage > 0.99) {
            return this.cpuMonitorImage6;
        }
        if (percentage > 0.8) {
            return this.cpuMonitorImage5;
        }
        if (percentage > 0.6) {
            return this.cpuMonitorImage4;
        }
        if (percentage > 0.4) {
            return this.cpuMonitorImage3;
        }
        if (percentage > 0.2) {
            return this.cpuMonitorImage2;
        }
        if (percentage > 0.01) {
            return this.cpuMonitorImage1;
        }
        return this.cpuMonitorImage0;
    }

    @Override
    public void dispose() {
        this.servicePublisher.dispose();
    }

    @Override
    public void setTreeViewer(TreeViewer viewer) {
        super.setTreeViewer(viewer);
        this.treeViewer.addTreeListener(this.getTreeListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] createMonitoringRootFolderContent(Object parentNode) {
        Object ramUsage;
        Object node2;
        Object rce;
        ArrayList result = new ArrayList(7);
        MonitoringDataFolderRootNode rootNode = (MonitoringDataFolderRootNode)parentNode;
        FullSystemAndProcessDataSnapshot model = this.currentModel.getMonitoringDataModelMap().get(rootNode.getInstanceNode().getNode().getNodeId());
        if (model == null) {
            Object[] placeHolder = new Object[]{"Fetching monitoring data..."};
            return placeHolder;
        }
        InstanceNodeSessionId nodeId = rootNode.getInstanceNode().getNode().getNodeId();
        String nodeIdString = nodeId.getInstanceNodeSessionIdString();
        boolean keyExists = false;
        Map<InstanceNodeSessionId, List<InstanceResourceInfoNode>> map = this.nodeIdToInstanceResourceInfoMap;
        synchronized (map) {
            keyExists = this.nodeIdToRceNodeMap.containsKey(nodeId);
        }
        if (!keyExists) {
            RceNode subProcess = new RceNode(parentNode, true, model.getTotalSubProcessesCpuUsage(), model.getRceSubProcesses(), nodeIdString);
            rce = new RceNode(parentNode, false, model.getTotalRceOwnProcessesCpuUsage(), model.getRceProcessesInfo(), nodeIdString);
            ArrayList rceNodeList = new ArrayList(2);
            rceNodeList.add(rce);
            rceNodeList.add(subProcess);
            Map<InstanceNodeSessionId, List<InstanceResourceInfoNode>> map2 = this.nodeIdToInstanceResourceInfoMap;
            synchronized (map2) {
                this.nodeIdToRceNodeMap.put(nodeId, rceNodeList);
            }
            this.expansionsMap.put(nodeId, subProcess);
        } else {
            ArrayList rceList = new ArrayList();
            rce = this.nodeIdToInstanceResourceInfoMap;
            synchronized (rce) {
                rceList.addAll(this.nodeIdToRceNodeMap.get(nodeId));
            }
            for (Object node2 : rceList) {
                if (((RceNode)node2).getTypeIsSubProcessRoot()) {
                    ((RceNode)node2).setChildren(model.getRceSubProcesses());
                    ((RceNode)node2).setCpuUsage(model.getTotalSubProcessesCpuUsage());
                    continue;
                }
                ((RceNode)node2).setChildren(model.getRceProcessesInfo());
                ((RceNode)node2).setCpuUsage(model.getTotalRceOwnProcessesCpuUsage());
            }
        }
        boolean valid = false;
        node2 = this.nodeIdToInstanceResourceInfoMap;
        synchronized (node2) {
            valid = this.nodeIdToInstanceResourceInfoMap.containsKey(nodeId);
        }
        if (!valid) {
            InstanceResourceInfoNode cpuUsage = new InstanceResourceInfoNode(parentNode, InstanceNodeContext.NODE_CPU_USAGE, model.getNodeCPUusage(), model.getIdle(), model.getOtherProcessCpuUsage(), nodeIdString);
            ramUsage = new InstanceResourceInfoNode(parentNode, InstanceNodeContext.NODE_RAM_USAGE, model.getNodeRAMUsage(), model.getNodeSystemRAM());
            ArrayList<Object> instanceResourceInfoList = new ArrayList<Object>(5);
            instanceResourceInfoList.add(cpuUsage);
            instanceResourceInfoList.add(ramUsage);
            Map<InstanceNodeSessionId, List<InstanceResourceInfoNode>> map3 = this.nodeIdToInstanceResourceInfoMap;
            synchronized (map3) {
                this.nodeIdToInstanceResourceInfoMap.put(nodeId, instanceResourceInfoList);
            }
        }
        ArrayList nodeList = new ArrayList();
        ramUsage = this.nodeIdToInstanceResourceInfoMap;
        synchronized (ramUsage) {
            nodeList.addAll(this.nodeIdToInstanceResourceInfoMap.get(nodeId));
        }
        for (InstanceResourceInfoNode node3 : nodeList) {
            switch (node3.getInstanceNodeContext()) {
                case NODE_CPU_USAGE: {
                    node3.setCpuUsage(model.getNodeCPUusage(), model.getOtherProcessCpuUsage(), model.getIdle());
                    break;
                }
                case NODE_RAM_USAGE: {
                    node3.setRam(model.getNodeRAMUsage());
                    break;
                }
                default: {
                    this.log.info((Object)"Wrong context of InstanceResourceInfoNode");
                }
            }
        }
        Map<InstanceNodeSessionId, List<InstanceResourceInfoNode>> map4 = this.nodeIdToInstanceResourceInfoMap;
        synchronized (map4) {
            result.addAll(this.nodeIdToRceNodeMap.get(nodeId));
            result.addAll(this.nodeIdToInstanceResourceInfoMap.get(nodeId));
        }
        return result.toArray();
    }

    private Object[] createRceNodeFolderContent(Object parentNode) {
        RceNode rce = (RceNode)parentNode;
        List<ProcessInformation> childList = rce.getChildren();
        ArrayList<ProcessInfoNode> result = new ArrayList<ProcessInfoNode>(childList.size());
        for (ProcessInformation child : childList) {
            ProcessInfoNode processInfoNode = new ProcessInfoNode(parentNode, child);
            result.add(processInfoNode);
        }
        return result.toArray();
    }

    private Object[] createProcessInfoNodeContent(Object parentNode) {
        ProcessInfoNode processInfoNode = (ProcessInfoNode)parentNode;
        List<ProcessInformation> childList = processInfoNode.getChildren();
        ArrayList<ProcessInfoNode> result = new ArrayList<ProcessInfoNode>(childList.size());
        for (ProcessInformation child : childList) {
            ProcessInfoNode newProcessInfoNode = new ProcessInfoNode(parentNode, child);
            result.add(newProcessInfoNode);
        }
        return result.toArray();
    }

    private ITreeViewerListener getTreeListener() {
        return new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent expanded) {
                Object element = expanded.getElement();
                if (element instanceof MonitoringDataFolderRootNode) {
                    this.startSystemMonitoring(element);
                } else {
                    this.checkChildrenForSystemMonitoring(true, element);
                }
            }

            public void treeCollapsed(TreeExpansionEvent collapsed) {
                Object element = collapsed.getElement();
                if (element instanceof MonitoringDataFolderRootNode) {
                    this.stopSystemMonitoring((MonitoringDataFolderRootNode)element);
                } else {
                    this.checkChildrenForSystemMonitoring(false, element);
                }
            }

            private void checkChildrenForSystemMonitoring(boolean expanding, Object element) {
                IContentProvider tmpProvider = MonitoringDataContributor.this.treeViewer.getContentProvider();
                if (tmpProvider instanceof ITreeContentProvider) {
                    NetworkViewContentProvider provider = (NetworkViewContentProvider)tmpProvider;
                    Stack<Object> children = new Stack<Object>();
                    children.push(element);
                    while (!children.isEmpty()) {
                        Object child = children.pop();
                        if (child instanceof MonitoringDataFolderRootNode) {
                            if (!MonitoringDataContributor.this.treeViewer.getExpandedState(child)) continue;
                            if (expanding) {
                                this.startSystemMonitoring(child);
                                continue;
                            }
                            this.stopSystemMonitoring((MonitoringDataFolderRootNode)child);
                            continue;
                        }
                        if (child instanceof SelfRenderingNetworkViewNode || !provider.hasChildren(child)) continue;
                        Object[] objectArray = provider.getChildren(child);
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object tmpChild = objectArray[n2];
                            if (MonitoringDataContributor.this.treeViewer.getExpandedState(tmpChild)) {
                                children.add(tmpChild);
                            }
                            ++n2;
                        }
                    }
                } else {
                    MonitoringDataContributor.this.log.debug((Object)"The current content provider is not an instance of ITreeContentProvider");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void stopSystemMonitoring(MonitoringDataFolderRootNode element) {
                InstanceNodeSessionId nodeId = element.getInstanceNode().getNode().getNodeId();
                MonitoringDataContributor.this.pollingManager.cancelPollingTask(nodeId);
                Map<InstanceNodeSessionId, List<InstanceResourceInfoNode>> map = MonitoringDataContributor.this.nodeIdToInstanceResourceInfoMap;
                synchronized (map) {
                    MonitoringDataContributor.this.nodeIdToInstanceResourceInfoMap.clear();
                    MonitoringDataContributor.this.nodeIdToRceNodeMap.clear();
                }
            }

            private void startSystemMonitoring(Object element) {
                final InstanceNodeSessionId node = ((MonitoringDataFolderRootNode)element).getInstanceNode().getNode().getNodeId();
                MonitoringDataContributor.this.idToNodeMap.put(node, (ContributedNetworkViewNode)element);
                if (node != null) {
                    MonitoringDataContributor.this.pollingManager.startPollingTask(node, new SystemMonitoringDataSnapshotListener(){

                        public void onMonitoringDataChanged(final FullSystemAndProcessDataSnapshot monitoringModel) {
                            if ((this).MonitoringDataContributor.this.display.isDisposed()) {
                                (this).MonitoringDataContributor.this.pollingManager.cancelPollingTask(node);
                                return;
                            }
                            (this).MonitoringDataContributor.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ((this).this).MonitoringDataContributor.this.currentModel.monitoringDataModelMap.put(node, monitoringModel);
                                    if (((this).this).MonitoringDataContributor.this.treeViewer.getControl().isDisposed()) {
                                        ((this).this).MonitoringDataContributor.this.pollingManager.cancelPollingTask(node);
                                        return;
                                    }
                                    ContributedNetworkViewNode monitoringRootElementForInstance = ((this).this).MonitoringDataContributor.this.idToNodeMap.get(node);
                                    if (monitoringRootElementForInstance != null) {
                                        ((this).this).MonitoringDataContributor.this.treeViewer.refresh((Object)monitoringRootElementForInstance, true);
                                    } else {
                                        ((this).this).MonitoringDataContributor.this.log.debug((Object)("Root element is null for node " + node + " - skipping refresh"));
                                    }
                                    ContributedNetworkViewNode expansionNode = ((this).this).MonitoringDataContributor.this.expansionsMap.get(node);
                                    if (expansionNode != null) {
                                        ((this).this).MonitoringDataContributor.this.treeViewer.expandToLevel((Object)expansionNode, -1);
                                    } else {
                                        ((this).this).MonitoringDataContributor.this.log.debug((Object)("Expansion node is null for node " + node + " - skipping auto-expansion"));
                                    }
                                }
                            });
                        }
                    });
                }
            }
        };
    }

    private void registerChangeListeners() {
        this.servicePublisher.registerService(NetworkTopologyChangeListener.class, (Object)new NetworkTopologyChangeListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReachableNodesChanged(Set<InstanceNodeSessionId> reachableNodes, Set<InstanceNodeSessionId> addedNodes, Set<InstanceNodeSessionId> removedNodes) {
                Map<InstanceNodeSessionId, List<InstanceResourceInfoNode>> map = MonitoringDataContributor.this.nodeIdToInstanceResourceInfoMap;
                synchronized (map) {
                    for (InstanceNodeSessionId removedNode : removedNodes) {
                        if (MonitoringDataContributor.this.nodeIdToInstanceResourceInfoMap.containsKey(removedNode)) {
                            MonitoringDataContributor.this.nodeIdToInstanceResourceInfoMap.remove(removedNode);
                        }
                        if (!MonitoringDataContributor.this.nodeIdToRceNodeMap.containsKey(removedNode)) continue;
                        MonitoringDataContributor.this.nodeIdToRceNodeMap.remove(removedNode);
                    }
                }
                MonitoringDataContributor.this.pollingManager.cancelPollingTasks(removedNodes);
            }
        });
    }

    public static enum InstanceNodeContext {
        NODE_CPU_USAGE,
        NODE_RAM_USAGE;

    }

    private class InstanceResourceInfoNode
    implements ContributedNetworkViewNodeWithParent {
        private double cpuUsage;
        private double cpuOther;
        private double cpuIdle;
        private long ramUsed;
        private final long ramTotal;
        private final InstanceNodeContext context;
        private final String nodeIdString;
        private final Object parentNode;

        InstanceResourceInfoNode(Object parentNode, InstanceNodeContext context, double cpuUsage, double otherCpuUsage, double idleCpu, String nodeId) {
            this.parentNode = parentNode;
            this.cpuUsage = cpuUsage;
            this.context = context;
            this.cpuOther = otherCpuUsage;
            this.cpuIdle = idleCpu;
            this.ramTotal = 0L;
            this.nodeIdString = nodeId;
        }

        InstanceResourceInfoNode(Object parentNode, InstanceNodeContext context, long ram, long ramTotal) {
            this.parentNode = parentNode;
            this.ramUsed = ram;
            this.ramTotal = ramTotal;
            this.context = context;
            this.nodeIdString = null;
        }

        @Override
        public Object getParentNode() {
            return this.parentNode;
        }

        public double getCpuUsage() {
            return this.cpuUsage;
        }

        public InstanceNodeContext getInstanceNodeContext() {
            return this.context;
        }

        public long getRam() {
            return this.ramUsed;
        }

        public void setRam(long ram) {
            this.ramUsed = ram;
        }

        public void setCpuUsage(double usage, double other, double idle) {
            this.cpuUsage = usage;
            this.cpuOther = other;
            this.cpuIdle = idle;
        }

        @Override
        public NetworkViewContributor getContributor() {
            return MonitoringDataContributor.this;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = this.context == null ? (result *= 31) : 31 * result + this.context.hashCode();
            result = this.nodeIdString == null ? (result *= 31) : 31 * result + this.nodeIdString.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstanceResourceInfoNode other = (InstanceResourceInfoNode)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.context != other.context) {
                return false;
            }
            return !(this.nodeIdString == null ? other.nodeIdString != null : !this.nodeIdString.equals(other.nodeIdString));
        }

        private MonitoringDataContributor getOuterType() {
            return MonitoringDataContributor.this;
        }
    }

    private class MonitoringDataFolderRootNode
    implements ContributedNetworkViewNode {
        private final NetworkGraphNodeWithContext instanceNode;

        MonitoringDataFolderRootNode(NetworkGraphNodeWithContext instanceNode) {
            this.instanceNode = instanceNode;
        }

        public NetworkGraphNodeWithContext getInstanceNode() {
            return this.instanceNode;
        }

        @Override
        public NetworkViewContributor getContributor() {
            return MonitoringDataContributor.this;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = this.instanceNode == null ? (result *= 31) : 31 * result + this.instanceNode.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MonitoringDataFolderRootNode other = (MonitoringDataFolderRootNode)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.instanceNode == null ? other.instanceNode != null : !this.instanceNode.equals(other.instanceNode));
        }

        private MonitoringDataContributor getOuterType() {
            return MonitoringDataContributor.this;
        }
    }

    private class ProcessInfoNode
    implements ContributedNetworkViewNodeWithParent {
        private ProcessInformation processInfo;
        private long pid;
        private Object parentNode;

        ProcessInfoNode(Object parentNode, ProcessInformation processInfo) {
            this.parentNode = parentNode;
            this.processInfo = processInfo;
            this.pid = processInfo.getPid();
        }

        public ProcessInformation getProcessInfo() {
            return this.processInfo;
        }

        public List<ProcessInformation> getChildren() {
            return this.processInfo.getChildren();
        }

        @Override
        public Object getParentNode() {
            return this.parentNode;
        }

        @Override
        public NetworkViewContributor getContributor() {
            return MonitoringDataContributor.this;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (int)(this.pid ^ this.pid >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProcessInfoNode other = (ProcessInfoNode)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return this.pid == other.pid;
        }

        private MonitoringDataContributor getOuterType() {
            return MonitoringDataContributor.this;
        }
    }

    private class RceNode
    implements ContributedNetworkViewNodeWithParent {
        private final boolean typeIsSubProcessRoot;
        private double cpuUsage;
        private List<ProcessInformation> children;
        private String nodeIdString;
        private final Object parentNode;

        RceNode(Object parentNode, boolean typeIsSubProcessRoot, double cpuUsage, List<ProcessInformation> children, String nodeIdString) {
            this.parentNode = parentNode;
            this.typeIsSubProcessRoot = typeIsSubProcessRoot;
            this.cpuUsage = cpuUsage;
            this.children = children;
            this.nodeIdString = nodeIdString;
        }

        public boolean getTypeIsSubProcessRoot() {
            return this.typeIsSubProcessRoot;
        }

        public double getCpuUsage() {
            return this.cpuUsage;
        }

        public void setCpuUsage(double usage) {
            this.cpuUsage = usage;
        }

        public void setChildren(List<ProcessInformation> children) {
            this.children = children;
        }

        public List<ProcessInformation> getChildren() {
            return this.children;
        }

        @Override
        public Object getParentNode() {
            return this.parentNode;
        }

        @Override
        public NetworkViewContributor getContributor() {
            return MonitoringDataContributor.this;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = this.nodeIdString == null ? (result *= 31) : 31 * result + this.nodeIdString.hashCode();
            result = this.typeIsSubProcessRoot ? 31 * result + 1231 : 31 * result + 1237;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RceNode other = (RceNode)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.nodeIdString == null ? other.nodeIdString != null : !this.nodeIdString.equals(other.nodeIdString)) {
                return false;
            }
            return this.typeIsSubProcessRoot == other.typeIsSubProcessRoot;
        }

        private MonitoringDataContributor getOuterType() {
            return MonitoringDataContributor.this;
        }
    }
}

