/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import edu.uci.ics.jung.algorithms.layout.AbstractLayout;
import edu.uci.ics.jung.algorithms.layout.util.RandomLocationTransformer;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.util.ConcurrentModificationException;

public class SpringLayout<V, E>
extends AbstractLayout<V, E>
implements IterativeContext {
    protected double stretch = 0.7;
    protected Function<? super E, Integer> lengthFunction;
    protected int repulsion_range_sq = 10000;
    protected double force_multiplier = 0.3333333333333333;
    protected LoadingCache<V, SpringVertexData> springVertexData = CacheBuilder.newBuilder().build(new CacheLoader<V, SpringVertexData>(){

        @Override
        public SpringVertexData load(V vertex) {
            return new SpringVertexData();
        }
    });

    public SpringLayout(Graph<V, E> g) {
        this((Graph<V, Object>)g, Functions.constant(30));
    }

    public SpringLayout(Graph<V, E> g, Function<? super E, Integer> length_function) {
        super(g);
        this.lengthFunction = length_function;
    }

    public double getStretch() {
        return this.stretch;
    }

    @Override
    public void setSize(Dimension size) {
        if (!this.initialized) {
            this.setInitializer(new RandomLocationTransformer(size));
        }
        super.setSize(size);
    }

    public void setStretch(double stretch) {
        this.stretch = stretch;
    }

    public int getRepulsionRange() {
        return (int)Math.sqrt(this.repulsion_range_sq);
    }

    public void setRepulsionRange(int range) {
        this.repulsion_range_sq = range * range;
    }

    public double getForceMultiplier() {
        return this.force_multiplier;
    }

    public void setForceMultiplier(double force) {
        this.force_multiplier = force;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void step() {
        try {
            for (Object v : this.getGraph().getVertices()) {
                SpringVertexData svd = this.springVertexData.getUnchecked(v);
                if (svd == null) continue;
                svd.dx /= 4.0;
                svd.dy /= 4.0;
                svd.edgedy = 0.0;
                svd.edgedx = 0.0;
                svd.repulsiondy = 0.0;
                svd.repulsiondx = 0.0;
            }
        }
        catch (ConcurrentModificationException cme) {
            this.step();
        }
        this.relaxEdges();
        this.calculateRepulsion();
        this.moveNodes();
    }

    protected void relaxEdges() {
        try {
            for (Object e : this.getGraph().getEdges()) {
                Pair endpoints = this.getGraph().getEndpoints(e);
                Object v1 = endpoints.getFirst();
                Object v2 = endpoints.getSecond();
                Object p1 = this.apply(v1);
                Object p2 = this.apply(v2);
                if (p1 == null || p2 == null) continue;
                double vx = ((Point2D)p1).getX() - ((Point2D)p2).getX();
                double vy = ((Point2D)p1).getY() - ((Point2D)p2).getY();
                double len = Math.sqrt(vx * vx + vy * vy);
                double desiredLen = this.lengthFunction.apply(e).intValue();
                len = len == 0.0 ? 1.0E-4 : len;
                double f = this.force_multiplier * (desiredLen - len) / len;
                double dx = (f *= Math.pow(this.stretch, this.getGraph().degree(v1) + this.getGraph().degree(v2) - 2)) * vx;
                double dy = f * vy;
                SpringVertexData v1D = this.springVertexData.getUnchecked(v1);
                SpringVertexData v2D = this.springVertexData.getUnchecked(v2);
                v1D.edgedx += dx;
                v1D.edgedy += dy;
                v2D.edgedx += -dx;
                v2D.edgedy += -dy;
            }
        }
        catch (ConcurrentModificationException cme) {
            this.relaxEdges();
        }
    }

    protected void calculateRepulsion() {
        try {
            for (Object v : this.getGraph().getVertices()) {
                SpringVertexData svd;
                if (this.isLocked(v) || (svd = this.springVertexData.getUnchecked(v)) == null) continue;
                double dx = 0.0;
                double dy = 0.0;
                for (Object v2 : this.getGraph().getVertices()) {
                    if (v == v2) continue;
                    Object p = this.apply(v);
                    Object p2 = this.apply(v2);
                    if (p == null || p2 == null) continue;
                    double vx = ((Point2D)p).getX() - ((Point2D)p2).getX();
                    double vy = ((Point2D)p).getY() - ((Point2D)p2).getY();
                    double distanceSq = ((Point2D)p).distanceSq((Point2D)p2);
                    if (distanceSq == 0.0) {
                        dx += Math.random();
                        dy += Math.random();
                        continue;
                    }
                    if (!(distanceSq < (double)this.repulsion_range_sq)) continue;
                    double factor = 1.0;
                    dx += factor * vx / distanceSq;
                    dy += factor * vy / distanceSq;
                }
                double dlen = dx * dx + dy * dy;
                if (!(dlen > 0.0)) continue;
                dlen = Math.sqrt(dlen) / 2.0;
                svd.repulsiondx += dx / dlen;
                svd.repulsiondy += dy / dlen;
            }
        }
        catch (ConcurrentModificationException cme) {
            this.calculateRepulsion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveNodes() {
        Dimension dimension = this.getSize();
        synchronized (dimension) {
            try {
                for (Object v : this.getGraph().getVertices()) {
                    SpringVertexData vd;
                    if (this.isLocked(v) || (vd = this.springVertexData.getUnchecked(v)) == null) continue;
                    Object xyd = this.apply(v);
                    vd.dx += vd.repulsiondx + vd.edgedx;
                    vd.dy += vd.repulsiondy + vd.edgedy;
                    ((Point2D)xyd).setLocation(((Point2D)xyd).getX() + Math.max(-5.0, Math.min(5.0, vd.dx)), ((Point2D)xyd).getY() + Math.max(-5.0, Math.min(5.0, vd.dy)));
                    Dimension d = this.getSize();
                    int width = d.width;
                    int height = d.height;
                    if (((Point2D)xyd).getX() < 0.0) {
                        ((Point2D)xyd).setLocation(0.0, ((Point2D)xyd).getY());
                    } else if (((Point2D)xyd).getX() > (double)width) {
                        ((Point2D)xyd).setLocation(width, ((Point2D)xyd).getY());
                    }
                    if (((Point2D)xyd).getY() < 0.0) {
                        ((Point2D)xyd).setLocation(((Point2D)xyd).getX(), 0.0);
                        continue;
                    }
                    if (!(((Point2D)xyd).getY() > (double)height)) continue;
                    ((Point2D)xyd).setLocation(((Point2D)xyd).getX(), height);
                }
            }
            catch (ConcurrentModificationException cme) {
                this.moveNodes();
            }
        }
    }

    public boolean isIncremental() {
        return true;
    }

    @Override
    public boolean done() {
        return false;
    }

    @Override
    public void reset() {
    }

    public class SpringDimensionChecker
    extends ComponentAdapter {
        @Override
        public void componentResized(ComponentEvent e) {
            SpringLayout.this.setSize(e.getComponent().getSize());
        }
    }

    protected static class SpringVertexData {
        protected double edgedx;
        protected double edgedy;
        protected double repulsiondx;
        protected double repulsiondy;
        protected double dx;
        protected double dy;

        protected SpringVertexData() {
        }
    }
}

