/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.validation.spi;

import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.spi.ComponentValidator;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class AbstractComponentValidator
implements ComponentValidator {
    protected abstract List<ComponentValidationMessage> validateComponentSpecific(ComponentDescription var1);

    protected abstract List<ComponentValidationMessage> validateOnWorkflowStartComponentSpecific(ComponentDescription var1);

    @Override
    public List<ComponentValidationMessage> validate(ComponentDescription componentDescription, boolean onWorkflowStart) {
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        messages.addAll(this.defaultValidations(componentDescription));
        List<ComponentValidationMessage> componentSpecificMessages = this.validateComponentSpecific(componentDescription);
        if (componentSpecificMessages != null) {
            messages.addAll(componentSpecificMessages);
        }
        if (onWorkflowStart) {
            messages.addAll(this.validateOnWorkflowStart(componentDescription));
        }
        return messages;
    }

    protected List<ComponentValidationMessage> validateOnWorkflowStart(ComponentDescription componentDescription) {
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        List<ComponentValidationMessage> componentSpecificMessages = this.validateOnWorkflowStartComponentSpecific(componentDescription);
        if (componentSpecificMessages != null) {
            messages.addAll(componentSpecificMessages);
        }
        return messages;
    }

    protected List<ComponentValidationMessage> defaultValidations(ComponentDescription componentDescription) {
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        messages.addAll(this.validateInputExecutionConstraints(componentDescription));
        return messages;
    }

    protected List<ComponentValidationMessage> validateInputExecutionConstraints(ComponentDescription componentDescription) {
        LinkedList<ComponentValidationMessage> m = new LinkedList<ComponentValidationMessage>();
        for (EndpointDescription inputEp : this.getInputs(componentDescription)) {
            EndpointDefinition.InputExecutionContraint exeConstraint = inputEp.getEndpointDefinition().getDefaultInputExecutionConstraint();
            if (inputEp.getMetaDataValue("inputExecutionConstraint_4aae3eea") != null) {
                exeConstraint = EndpointDefinition.InputExecutionContraint.valueOf(inputEp.getMetaDataValue("inputExecutionConstraint_4aae3eea"));
            }
            if (!exeConstraint.equals((Object)EndpointDefinition.InputExecutionContraint.Required) || inputEp.isConnected()) continue;
            m.add(new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "", StringUtils.format((String)"Connect input '%s' to an output (of an enabled component) as it is required", (Object[])new Object[]{inputEp.getName()}), StringUtils.format((String)"Input '%s' is required but not connected to an output", (Object[])new Object[]{inputEp.getName()})));
        }
        return m;
    }

    protected Set<EndpointDescription> getInputs(ComponentDescription componentDescription) {
        return componentDescription.getInputDescriptionsManager().getEndpointDescriptions();
    }

    protected Set<EndpointDescription> getInputs(ComponentDescription componentDescription, DataType dataType) {
        HashSet<EndpointDescription> returnSet = new HashSet<EndpointDescription>();
        for (EndpointDescription endpointDescription : componentDescription.getInputDescriptionsManager().getEndpointDescriptions()) {
            if (!endpointDescription.getDataType().equals((Object)dataType)) continue;
            returnSet.add(endpointDescription);
        }
        return returnSet;
    }

    protected boolean hasInputs(ComponentDescription componentDescription) {
        return !componentDescription.getInputDescriptionsManager().getEndpointDescriptions().isEmpty();
    }

    protected Set<EndpointDescription> getOutputs(ComponentDescription componentDescription) {
        return componentDescription.getOutputDescriptionsManager().getEndpointDescriptions();
    }

    protected Set<EndpointDescription> getOutputs(ComponentDescription componentDescription, DataType dataType) {
        HashSet<EndpointDescription> returnSet = new HashSet<EndpointDescription>();
        for (EndpointDescription endpointDescription : componentDescription.getOutputDescriptionsManager().getEndpointDescriptions()) {
            if (!endpointDescription.getDataType().equals((Object)dataType)) continue;
            returnSet.add(endpointDescription);
        }
        return returnSet;
    }

    protected String getProperty(ComponentDescription componentDescription, String property) {
        return componentDescription.getConfigurationDescription().getConfigurationValue(property);
    }

    protected boolean isPropertySet(ComponentDescription componentDescription, String property) {
        return this.getProperty(componentDescription, property) != null;
    }
}

