/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.authorization.cryptography.internal;

import de.rcenvironment.core.authorization.cryptography.api.CryptographyOperationsProvider;
import de.rcenvironment.core.authorization.cryptography.api.SymmetricKey;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.Charsets;

public abstract class AbstractCryptographyOperationsProvider
implements CryptographyOperationsProvider {
    @Override
    public String encodeByteArray(byte[] input) {
        return Base64.encodeBase64URLSafeString((byte[])input);
    }

    @Override
    public String encryptAndEncodeByteArray(SymmetricKey key, byte[] input) throws OperationFailureException {
        return this.encodeByteArray(this.encrypt(key, input));
    }

    @Override
    public String encryptAndEncodeString(SymmetricKey key, String input) throws OperationFailureException {
        return this.encodeByteArray(this.encrypt(key, input.getBytes(Charsets.UTF_8)));
    }

    @Override
    public byte[] decodeAndDecryptByteArray(SymmetricKey key, String input) throws OperationFailureException {
        return this.decrypt(key, this.decodeByteArray(input));
    }

    @Override
    public String decodeAndDecryptString(SymmetricKey key, String input) throws OperationFailureException {
        return new String(this.decrypt(key, this.decodeByteArray(input)), Charsets.UTF_8);
    }

    @Override
    public byte[] decodeByteArray(String input) {
        return Base64.decodeBase64((String)input);
    }
}

