/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.network.channel.internal;

import de.rcenvironment.core.communication.uplink.client.execution.api.DirectoryDownloadReceiver;
import de.rcenvironment.core.communication.uplink.client.execution.api.DirectoryUploadContext;
import de.rcenvironment.core.communication.uplink.client.execution.api.DirectoryUploadProvider;
import de.rcenvironment.core.communication.uplink.client.execution.api.FileDataSource;
import de.rcenvironment.core.communication.uplink.common.internal.DataStreamDownloadWrapper;
import de.rcenvironment.core.communication.uplink.common.internal.DataStreamUploadWrapper;
import de.rcenvironment.core.communication.uplink.common.internal.MessageType;
import de.rcenvironment.core.communication.uplink.entities.FileHeader;
import de.rcenvironment.core.communication.uplink.entities.FileTransferSectionInfo;
import de.rcenvironment.core.communication.uplink.network.api.MessageBlockPriority;
import de.rcenvironment.core.communication.uplink.network.channel.internal.AbstractChannelEndpoint;
import de.rcenvironment.core.communication.uplink.network.channel.internal.ToolExecutionChannelState;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.communication.uplink.session.api.UplinkSession;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import java.io.IOException;
import java.io.PipedInputStream;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Semaphore;

public abstract class AbstractExecutionChannelEndpoint
extends AbstractChannelEndpoint {
    protected static final boolean VERBOSE_FILE_TRANSFER_LOGGING_ENABLED = DebugSettings.getVerboseLoggingEnabled((String)"uplink.filetransfers");
    private ToolExecutionChannelState channelState = ToolExecutionChannelState.EXPECTING_NO_MESSAGES;

    public AbstractExecutionChannelEndpoint(UplinkSession session, long channelId) {
        super(session, session.getLocalSessionId(), channelId);
    }

    protected void validateExpectedChannelState(ToolExecutionChannelState expectedState, MessageBlock message) throws ProtocolException {
        if (this.getChannelState() != expectedState) {
            throw new ProtocolException(String.valueOf(this.channelLogPrefix) + "Received a message of type " + (Object)((Object)message.getType()) + " in channel state " + this.getChannelState().name() + " when it should be " + expectedState.name());
        }
    }

    protected void validateActualVersusExpectedMessageType(MessageType actual, MessageType expected) throws ProtocolException {
        if (actual != expected) {
            throw new ProtocolException(String.valueOf(this.channelLogPrefix) + "Expected a message of type " + (Object)((Object)expected) + ", but received " + (Object)((Object)actual));
        }
    }

    protected void ensure(boolean condition) throws ProtocolException {
        if (!condition) {
            throw new ProtocolException(String.valueOf(this.channelLogPrefix) + "An internal check or condition was not in the required state; " + "this indicates a protocol violation or an internal error");
        }
    }

    protected void ensureNotDefinedYet(Object object) throws ProtocolException {
        if (object != null) {
            throw new ProtocolException(String.valueOf(this.channelLogPrefix) + "An internal field was about to be initialized, " + "but was already set; this indicates a protocol violation or an internal error");
        }
    }

    protected final synchronized ToolExecutionChannelState getChannelState() {
        return this.channelState;
    }

    protected final synchronized void setChannelState(ToolExecutionChannelState channelState) {
        this.channelState = channelState;
    }

    protected final class DirectoryDownloadWrapper {
        private DirectoryDownloadReceiver localReceiver;
        private boolean initialized;
        private DataStreamDownloadWrapper<FileDataSource> currentDownloadWrapper;
        private boolean receivedEndOfTransferMessage;
        private Semaphore receiveFileMethodsLock = new Semaphore(1);

        public DirectoryDownloadWrapper(DirectoryDownloadReceiver localReceiver) {
            this.localReceiver = localReceiver;
        }

        public void processMessageBlock(MessageBlock messageBlock) throws IOException {
            switch (messageBlock.getType()) {
                case FILE_TRANSFER_SECTION_START: {
                    AbstractExecutionChannelEndpoint.this.ensure(!this.initialized);
                    FileTransferSectionInfo fileTransferSectionInfo = AbstractExecutionChannelEndpoint.this.messageConverter.decodeFileTransferSectionStart(messageBlock);
                    Optional<List<String>> optionalListOfDirectories = fileTransferSectionInfo.getDirectoriesAsOptional();
                    if (optionalListOfDirectories.isPresent()) {
                        this.localReceiver.receiveDirectoryListing(optionalListOfDirectories.get());
                    }
                    this.initialized = true;
                    if (VERBOSE_FILE_TRANSFER_LOGGING_ENABLED) {
                        AbstractExecutionChannelEndpoint.this.log.debug((Object)(String.valueOf(AbstractExecutionChannelEndpoint.this.channelLogPrefix) + "Received start signal of file transfer section (local download)"));
                    }
                    return;
                }
                case FILE_HEADER: {
                    AbstractExecutionChannelEndpoint.this.ensure(this.initialized);
                    AbstractExecutionChannelEndpoint.this.ensure(this.currentDownloadWrapper == null);
                    final FileHeader fileHeader = AbstractExecutionChannelEndpoint.this.messageConverter.decodeFileHeader(messageBlock);
                    try {
                        this.receiveFileMethodsLock.acquire();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        AbstractExecutionChannelEndpoint.this.log.warn((Object)(String.valueOf(AbstractExecutionChannelEndpoint.this.channelLogPrefix) + "Interrupted while preparing download of " + fileHeader.getPath()));
                    }
                    AbstractExecutionChannelEndpoint.this.log.debug((Object)StringUtils.format((String)"%sStarting download of file '%s', size: %d bytes", (Object[])new Object[]{AbstractExecutionChannelEndpoint.this.channelLogPrefix, fileHeader.getPath(), fileHeader.getSize()}));
                    this.currentDownloadWrapper = new DataStreamDownloadWrapper<FileDataSource>(){

                        @Override
                        public FileDataSource createReturnObject(long sizeParam, PipedInputStream inputStream) {
                            return new FileDataSource(fileHeader.getPath(), sizeParam, inputStream);
                        }
                    };
                    FileDataSource fileDataSource = this.currentDownloadWrapper.initialize(fileHeader.getSize(), MessageType.FILE_CONTENT);
                    if (fileHeader.getSize() == 0L) {
                        this.currentDownloadWrapper = null;
                    }
                    ConcurrencyUtils.getAsyncTaskService().execute("Uplink: receive a file download", () -> {
                        try {
                            try {
                                this.localReceiver.receiveFile(fileDataSource);
                                AbstractExecutionChannelEndpoint.this.log.debug((Object)(String.valueOf(AbstractExecutionChannelEndpoint.this.channelLogPrefix) + "Finished download of " + fileHeader.getPath()));
                            }
                            catch (IOException e) {
                                if ("Pipe broken".equals(e.getMessage())) {
                                    AbstractExecutionChannelEndpoint.this.log.warn((Object)(String.valueOf(AbstractExecutionChannelEndpoint.this.channelLogPrefix) + "Error while downloading file " + fileHeader.getPath() + ": Either the execution was cancelled, or there was a connection error"));
                                } else {
                                    AbstractExecutionChannelEndpoint.this.log.warn((Object)(String.valueOf(AbstractExecutionChannelEndpoint.this.channelLogPrefix) + "Error while downloading file " + fileHeader.getPath()), (Throwable)e);
                                }
                                this.receiveFileMethodsLock.release();
                            }
                        }
                        finally {
                            this.receiveFileMethodsLock.release();
                        }
                    });
                    return;
                }
                case FILE_CONTENT: {
                    AbstractExecutionChannelEndpoint.this.ensure(this.currentDownloadWrapper != null);
                    boolean fileComplete = this.currentDownloadWrapper.processMessageBlock(messageBlock);
                    if (fileComplete) {
                        this.currentDownloadWrapper = null;
                    }
                    return;
                }
                case FILE_TRANSFER_SECTION_END: {
                    AbstractExecutionChannelEndpoint.this.ensure(this.initialized);
                    AbstractExecutionChannelEndpoint.this.ensure(this.currentDownloadWrapper == null);
                    this.receivedEndOfTransferMessage = true;
                    if (VERBOSE_FILE_TRANSFER_LOGGING_ENABLED) {
                        AbstractExecutionChannelEndpoint.this.log.debug((Object)(String.valueOf(AbstractExecutionChannelEndpoint.this.channelLogPrefix) + "Received end signal of file transfer section (local download)"));
                    }
                    return;
                }
            }
            throw new ProtocolException(String.valueOf(AbstractExecutionChannelEndpoint.this.channelLogPrefix) + "Unexpected message type during directory download: " + (Object)((Object)messageBlock.getType()));
        }

        public boolean isFinished() throws IOException {
            if (this.receivedEndOfTransferMessage) {
                try {
                    this.receiveFileMethodsLock.acquire();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new IOException(String.valueOf(AbstractExecutionChannelEndpoint.this.channelLogPrefix) + "Interrupted while waiting for all receiveFile() methods to complete");
                }
                return true;
            }
            return false;
        }
    }

    protected final class DirectoryUploadWrapper {
        private DirectoryUploadProvider localProvider;

        public DirectoryUploadWrapper(DirectoryUploadProvider localProvider) {
            this.localProvider = localProvider;
        }

        public void performDirectoryUpload() throws IOException {
            List<String> directoryListing = this.localProvider.provideDirectoryListing();
            AbstractExecutionChannelEndpoint.this.enqueueMessageBlockForSending(AbstractExecutionChannelEndpoint.this.messageConverter.encodeFileTransferSectionStart(new FileTransferSectionInfo(directoryListing)), MessageBlockPriority.BLOCKABLE_CHANNEL_OPERATION, true);
            if (VERBOSE_FILE_TRANSFER_LOGGING_ENABLED) {
                AbstractExecutionChannelEndpoint.this.log.debug((Object)(String.valueOf(AbstractExecutionChannelEndpoint.this.channelLogPrefix) + "Enqueued start signal of file transfer section (local upload)"));
            }
            this.localProvider.provideFiles(new DirectoryUploadContext(){

                @Override
                public void provideFile(FileDataSource dataSource) throws IOException {
                    FileHeader fileHeader = new FileHeader(dataSource.getSize(), dataSource.getRelativePath());
                    ((DirectoryUploadWrapper)DirectoryUploadWrapper.this).AbstractExecutionChannelEndpoint.this.log.debug((Object)StringUtils.format((String)"%sStarting upload of '%s', size: %d bytes", (Object[])new Object[]{((DirectoryUploadWrapper)DirectoryUploadWrapper.this).AbstractExecutionChannelEndpoint.this.channelLogPrefix, fileHeader.getPath(), fileHeader.getSize()}));
                    AbstractExecutionChannelEndpoint.this.enqueueMessageBlockForSending(((DirectoryUploadWrapper)DirectoryUploadWrapper.this).AbstractExecutionChannelEndpoint.this.messageConverter.encodeFileHeader(fileHeader), MessageBlockPriority.BLOCKABLE_CHANNEL_OPERATION, true);
                    new DataStreamUploadWrapper(((DirectoryUploadWrapper)DirectoryUploadWrapper.this).AbstractExecutionChannelEndpoint.this.asyncMessageBlockSender).uploadFromDataSource(((DirectoryUploadWrapper)DirectoryUploadWrapper.this).AbstractExecutionChannelEndpoint.this.channelId, MessageType.FILE_CONTENT, dataSource);
                    if (VERBOSE_FILE_TRANSFER_LOGGING_ENABLED) {
                        ((DirectoryUploadWrapper)DirectoryUploadWrapper.this).AbstractExecutionChannelEndpoint.this.log.debug((Object)StringUtils.format((String)"%sFinished upload of '%s'", (Object[])new Object[]{((DirectoryUploadWrapper)DirectoryUploadWrapper.this).AbstractExecutionChannelEndpoint.this.channelLogPrefix, fileHeader.getPath()}));
                    }
                }
            });
            AbstractExecutionChannelEndpoint.this.enqueueMessageBlockForSending(new MessageBlock(MessageType.FILE_TRANSFER_SECTION_END), MessageBlockPriority.BLOCKABLE_CHANNEL_OPERATION, true);
            if (VERBOSE_FILE_TRANSFER_LOGGING_ENABLED) {
                AbstractExecutionChannelEndpoint.this.log.debug((Object)(String.valueOf(AbstractExecutionChannelEndpoint.this.channelLogPrefix) + "Enqueued end signal of file transfer section (local upload)"));
            }
        }
    }
}

