/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.internal.ui.palette.PaletteColorUtil;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.ui.palette.editparts.PaletteEditPart;

public class SeparatorEditPart
extends PaletteEditPart {
    public SeparatorEditPart(PaletteSeparator separator) {
        super(separator);
    }

    @Override
    protected IFigure createFigure() {
        return new SeparatorFigure();
    }

    @Override
    protected String getToolTipText() {
        return null;
    }

    static class SeparatorFigure
    extends Figure {
        private static final Insets CROP = new Insets(1, 3, 2, 4);

        SeparatorFigure() {
        }

        public Dimension getPreferredSize(int wHint, int hHint) {
            if (this.getBackgroundColor().equals((Object)PaletteColorUtil.WIDGET_BACKGROUND)) {
                return new Dimension(wHint, 4);
            }
            return new Dimension(wHint, 5);
        }

        protected void paintFigure(Graphics g) {
            Rectangle r = this.getBounds().getCropped(CROP);
            if (this.getBackgroundColor().equals((Object)PaletteColorUtil.WIDGET_LIST_BACKGROUND)) {
                g.setForegroundColor(PaletteColorUtil.WIDGET_NORMAL_SHADOW);
                g.drawLine(r.getLeft(), r.getRight());
            } else {
                g.setForegroundColor(PaletteColorUtil.WIDGET_NORMAL_SHADOW);
                g.drawLine(r.getBottomLeft(), r.getTopLeft());
                g.drawLine(r.getTopLeft(), r.getTopRight());
                g.setForegroundColor(ColorConstants.buttonLightest);
                g.drawLine(r.getBottomLeft(), r.getBottomRight());
                g.drawLine(r.getBottomRight(), r.getTopRight());
            }
        }
    }
}

