/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.workflowintegration.editor.pages;

import de.rcenvironment.core.gui.integration.workflowintegration.editor.mappingtreenodes.ComponentNode;
import de.rcenvironment.core.gui.integration.workflowintegration.editor.mappingtreenodes.MappingNode;
import java.util.Arrays;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MappingTreeFilterWidget
implements ModifyListener,
KeyListener {
    private static final String FILTER_DELIMITER = ";";
    private static final int FILTER_TEXTFIELD_WIDTH = 150;
    private static final String FILTER_MESSAGE = "Filter tree...";
    private Text filterTextfield;
    private ViewerFilter filter;
    private String filterText;
    private boolean filterSet;
    private Object[] expandedElements;
    private CheckboxTreeViewer treeViewer;

    public MappingTreeFilterWidget(Composite parent, CheckboxTreeViewer treeViewer) {
        this.createControl(parent);
        this.treeViewer = treeViewer;
    }

    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(263184));
        GridLayout compositeLayout = new GridLayout(1, false);
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        this.filterTextfield = new Text(composite, 526336);
        GridData layoutData = new GridData(1808);
        layoutData.widthHint = 150;
        this.filterTextfield.setLayoutData((Object)layoutData);
        this.filterTextfield.setMessage(FILTER_MESSAGE);
        this.filterTextfield.addModifyListener((ModifyListener)this);
        this.filterTextfield.addKeyListener((KeyListener)this);
        this.createFilter();
        return composite;
    }

    private void createFilter() {
        this.filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object elementObject) {
                if (elementObject instanceof ComponentNode) {
                    ComponentNode node = (ComponentNode)elementObject;
                    boolean childMatch = Arrays.stream(node.getChildren()).anyMatch(child -> this.select(viewer, node, child));
                    return childMatch || node.getComponentName().toLowerCase().contains(MappingTreeFilterWidget.this.filterText.toLowerCase());
                }
                if (elementObject instanceof MappingNode) {
                    MappingNode node = (MappingNode)elementObject;
                    return Arrays.stream(node.getFilterString().split(MappingTreeFilterWidget.FILTER_DELIMITER)).anyMatch(n -> n.toLowerCase().contains(MappingTreeFilterWidget.this.filterText.toLowerCase()));
                }
                return false;
            }

            public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
                if (parent instanceof ComponentNode && ((ComponentNode)parent).getComponentName().toLowerCase().contains(MappingTreeFilterWidget.this.filterText.toLowerCase())) {
                    return elements;
                }
                return super.filter(viewer, parent, elements);
            }
        };
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget instanceof Text) {
            Text filterTextField = (Text)e.widget;
            this.filterText = filterTextField.getText();
            if (this.filterText != null && this.filterText.length() > 0) {
                if (!this.filterSet) {
                    this.filterSet = true;
                    this.expandedElements = this.treeViewer.getExpandedElements();
                }
                this.treeViewer.cancelEditing();
                this.treeViewer.getTree().deselectAll();
                this.treeViewer.getTree().setVisible(false);
                this.treeViewer.setFilters(new ViewerFilter[]{this.filter});
                this.treeViewer.expandAll();
                this.treeViewer.refresh();
                this.treeViewer.getTree().setVisible(true);
            } else {
                this.treeViewer.getTree().setVisible(false);
                this.treeViewer.resetFilters();
                this.filterSet = false;
                if (this.expandedElements != null) {
                    this.treeViewer.setExpandedElements(this.expandedElements);
                    this.treeViewer.refresh();
                }
                this.treeViewer.getTree().setVisible(true);
            }
        }
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.character == '\u001b') {
            this.filterTextfield.setText("");
            this.treeViewer.getTree().setFocus();
        }
    }
}

