/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.authorization;

import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.component.authorization.api.NamedComponentAuthorizationSelector;
import de.rcenvironment.core.gui.authorization.AuthorizationLabelProvider;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ToolbarFilterWidget
extends ControlContribution
implements ModifyListener {
    private static final int FILTER_TEXTFIELD_WIDTH = 120;
    private String defaultMessage;
    private String filterText;
    private StructuredViewer structuredViewer;
    private ViewerFilter filter;
    private Text filterTextfield;

    protected ToolbarFilterWidget(StructuredViewer structuredViewer) {
        this(structuredViewer, "Filter...");
    }

    protected ToolbarFilterWidget(StructuredViewer structuredViewer, String message) {
        super("viewerFilter");
        this.structuredViewer = structuredViewer;
        this.defaultMessage = message;
    }

    protected void setViewer(StructuredViewer viewer) {
        this.structuredViewer = viewer;
        this.filterText = "";
        this.filterTextfield.setText("");
    }

    protected void setMessage(String message) {
        if (this.filterTextfield != null && !this.filterTextfield.isDisposed()) {
            this.filterTextfield.setMessage(message);
        }
    }

    private void createFilter() {
        this.filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IBaseLabelProvider labelProvider;
                String compareString = "";
                if (element instanceof AuthorizationAccessGroup && parentElement instanceof NamedComponentAuthorizationSelector) {
                    return true;
                }
                if (element instanceof NamedComponentAuthorizationSelector && parentElement instanceof AuthorizationAccessGroup) {
                    return true;
                }
                if (viewer instanceof StructuredViewer && (labelProvider = ((StructuredViewer)viewer).getLabelProvider()) instanceof AuthorizationLabelProvider) {
                    compareString = ((AuthorizationLabelProvider)labelProvider).getText(element);
                    return compareString.toLowerCase().contains(ToolbarFilterWidget.this.filterText.toLowerCase().trim());
                }
                return true;
            }
        };
    }

    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, false);
        compositeLayout.marginHeight = 0;
        composite.setLayout((Layout)compositeLayout);
        this.filterTextfield = new Text(composite, 526336);
        GridData layoutData = new GridData(16384, 128, true, false);
        layoutData.widthHint = 120;
        layoutData.verticalAlignment = 2;
        this.filterTextfield.setLayoutData((Object)layoutData);
        this.setMessage(this.defaultMessage);
        this.filterTextfield.addModifyListener((ModifyListener)this);
        this.createFilter();
        return composite;
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget instanceof Text) {
            Text filterTextField = (Text)e.widget;
            this.filterText = filterTextField.getText();
            if (this.filterText != null && this.filterText.length() > 0) {
                this.structuredViewer.setFilters(new ViewerFilter[]{this.filter});
            } else {
                this.structuredViewer.resetFilters();
            }
        }
    }
}

