/*
 * Decompiled with CFR 0.152.
 */
package de.vonloesch.pdf4eclipse.model.jpedal;

import de.vonloesch.pdf4eclipse.model.IOutlineNode;
import de.vonloesch.pdf4eclipse.model.IPDFFile;
import de.vonloesch.pdf4eclipse.model.IPDFPage;
import de.vonloesch.pdf4eclipse.model.jpedal.JPedalOutlineNode;
import de.vonloesch.pdf4eclipse.model.jpedal.JPedalPDFPage;
import java.io.File;
import java.io.IOException;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.tt.TTGlyph;
import org.w3c.dom.Document;

public class JPedalPDFFile
implements IPDFFile {
    File input;
    PdfDecoder decoder;
    int pageNumbers;

    public JPedalPDFFile(File f) throws IOException {
        this.input = f;
        this.decoder = new PdfDecoder(false);
        FontMappings.setFontReplacements();
        TTGlyph.useHinting = false;
        this.reload();
    }

    @Override
    public int getNumPages() {
        return this.pageNumbers;
    }

    @Override
    public IOutlineNode getOutline() throws IOException {
        Document n = this.decoder.getOutlineAsXML();
        if (n != null) {
            return new JPedalOutlineNode(n.getFirstChild(), this.decoder);
        }
        return null;
    }

    @Override
    public void reload() throws IOException {
        this.decoder.closePdfFile();
        try {
            this.decoder.openPdfFile(this.input.getAbsolutePath());
            this.pageNumbers = this.decoder.getPageCount();
        }
        catch (PdfException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public IPDFPage getPage(int pageNr) {
        return new JPedalPDFPage(this.decoder, pageNr);
    }

    @Override
    public void close() {
        this.decoder.closePdfFile();
        this.decoder.dispose();
    }

    public PdfDecoder getInternalDecoder() {
        return this.decoder;
    }
}

