/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.parts;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.tools.ConnectionBendpointTracker;

public class CustomConnectionBendpointTracker
extends ConnectionBendpointTracker {
    private static final double NUMBER_1_5 = 1.5;
    private static final double NUMBER_0_5 = 0.5;
    private static final int MODIFIER_NO_SNAPPING = 65536;
    private PrecisionRectangle sourceRectangle;
    private Point originalLocation = null;
    private ConnectionEditPart host;

    public CustomConnectionBendpointTracker(ConnectionEditPart host, int index) {
        super(host, index);
        this.host = host;
    }

    protected void updateSourceRequest() {
        BendpointRequest request = (BendpointRequest)this.getSourceRequest();
        if (this.originalLocation == null) {
            this.originalLocation = this.getStartLocation().getCopy();
        }
        Dimension delta = this.getDragMoveDelta();
        if (this.getCurrentInput().isShiftKeyDown()) {
            float ratio = 0.0f;
            if (delta.width != 0) {
                ratio = (float)delta.height / (float)delta.width;
            }
            if ((double)(ratio = Math.abs(ratio)) > 0.5 && (double)ratio < 1.5) {
                if (Math.abs(delta.height) > Math.abs(delta.width)) {
                    delta.height = delta.height > 0 ? Math.abs(delta.width) : -Math.abs(delta.width);
                } else {
                    delta.width = delta.width > 0 ? Math.abs(delta.height) : -Math.abs(delta.height);
                }
            } else if (Math.abs(delta.width) > Math.abs(delta.height)) {
                delta.height = 0;
            } else {
                delta.width = 0;
            }
        }
        Point moveDelta = new Point(delta.width, delta.height);
        SnapToHelper snapToHelper = (SnapToHelper)this.getConnectionEditPart().getAdapter(SnapToHelper.class);
        Rectangle rect = new Rectangle(this.originalLocation.x, this.originalLocation.y, 1, 1);
        if (this.sourceRectangle == null) {
            this.sourceRectangle = new PrecisionRectangle(rect);
        }
        if (snapToHelper != null && !this.getCurrentInput().isModKeyDown(65536)) {
            PrecisionRectangle baseRect = this.sourceRectangle.getPreciseCopy();
            baseRect.translate(moveDelta);
            PrecisionPoint preciseDelta = new PrecisionPoint(moveDelta);
            snapToHelper.snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRect}, preciseDelta);
            Point newLocation = this.originalLocation.getCopy().translate((Point)preciseDelta);
            request.setLocation(newLocation);
        } else {
            request.setLocation(this.getLocation());
        }
    }

    protected boolean handleDragStarted() {
        this.originalLocation = null;
        this.sourceRectangle = null;
        this.host.getViewer().getControl().setData("DRAG_STATE_BENDPOINT", (Object)true);
        return super.handleDragStarted();
    }

    protected void performDrag() {
        this.host.getViewer().getControl().setData("DRAG_STATE_BENDPOINT", (Object)false);
        super.performDrag();
    }
}

