/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.text;

import com.googlecode.lanterna.LanternaException;
import com.googlecode.lanterna.input.GnomeTerminalProfile;
import com.googlecode.lanterna.input.Key;
import com.googlecode.lanterna.input.OSXKeyMappingProfile;
import com.googlecode.lanterna.input.PuttyProfile;
import com.googlecode.lanterna.terminal.TerminalSize;
import com.googlecode.lanterna.terminal.text.ANSITerminal;
import com.googlecode.lanterna.terminal.text.UnixTerminalSizeQuerier;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;

public class UnixTerminal
extends ANSITerminal {
    private final UnixTerminalSizeQuerier terminalSizeQuerier;
    private final Behaviour terminalBehaviour;
    private String sttyStatusToRestore;
    private boolean inPrivateMode;

    public UnixTerminal(InputStream terminalInput, OutputStream terminalOutput, Charset terminalCharset) {
        this(terminalInput, terminalOutput, terminalCharset, null);
    }

    public UnixTerminal(InputStream terminalInput, OutputStream terminalOutput, Charset terminalCharset, UnixTerminalSizeQuerier customSizeQuerier) {
        this(terminalInput, terminalOutput, terminalCharset, customSizeQuerier, Behaviour.DEFAULT);
    }

    public UnixTerminal(InputStream terminalInput, OutputStream terminalOutput, Charset terminalCharset, UnixTerminalSizeQuerier customSizeQuerier, Behaviour terminalBehaviour) {
        super(terminalInput, terminalOutput, terminalCharset);
        this.terminalSizeQuerier = customSizeQuerier;
        this.terminalBehaviour = terminalBehaviour;
        this.sttyStatusToRestore = null;
        this.inPrivateMode = false;
        this.addInputProfile(new GnomeTerminalProfile());
        this.addInputProfile(new PuttyProfile());
        this.addInputProfile(new OSXKeyMappingProfile());
        this.onResized(80, 20);
        try {
            Class<?> signalClass = Class.forName("sun.misc.Signal");
            for (Method m : signalClass.getDeclaredMethods()) {
                if (!"handle".equals(m.getName())) continue;
                Object windowResizeHandler = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Class.forName("sun.misc.SignalHandler")}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if ("handle".equals(method.getName())) {
                            UnixTerminal.this.queryTerminalSize();
                        }
                        return null;
                    }
                });
                m.invoke(null, signalClass.getConstructor(String.class).newInstance("WINCH"), windowResizeHandler);
            }
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
        }
    }

    @Override
    @Deprecated
    public TerminalSize queryTerminalSize() {
        if (this.terminalSizeQuerier != null) {
            return this.terminalSizeQuerier.queryTerminalSize();
        }
        return super.queryTerminalSize();
    }

    @Override
    public TerminalSize getTerminalSize() {
        if (this.terminalSizeQuerier != null) {
            return this.terminalSizeQuerier.queryTerminalSize();
        }
        return super.getTerminalSize();
    }

    @Override
    public Key readInput() {
        Key key = super.readInput();
        if (key != null && this.terminalBehaviour == Behaviour.CTRL_C_KILLS_APPLICATION && key.getCharacter() == 'c' && !key.isAltPressed() && key.isCtrlPressed()) {
            this.exitPrivateMode();
            System.exit(1);
        }
        return key;
    }

    @Override
    public void enterPrivateMode() {
        if (this.inPrivateMode) {
            return;
        }
        this.inPrivateMode = true;
        this.saveSTTY();
        super.enterPrivateMode();
        this.setCBreak(true);
        this.setEcho(false);
        UnixTerminal.sttyMinimumCharacterForRead(1);
        UnixTerminal.disableSpecialCharacters();
    }

    @Override
    public void exitPrivateMode() {
        super.exitPrivateMode();
        this.restoreSTTY();
        this.inPrivateMode = false;
    }

    @Override
    public void setCBreak(boolean cbreakOn) {
        UnixTerminal.sttyICanon(cbreakOn);
    }

    @Override
    public void setEcho(boolean echoOn) {
        UnixTerminal.sttyKeyEcho(echoOn);
    }

    private static void sttyKeyEcho(boolean enable) {
        UnixTerminal.exec("/bin/sh", "-c", "/bin/stty " + (enable ? "echo" : "-echo") + " < /dev/tty");
    }

    private static void sttyMinimumCharacterForRead(int nrCharacters) {
        UnixTerminal.exec("/bin/sh", "-c", "/bin/stty min " + nrCharacters + " < /dev/tty");
    }

    private static void sttyICanon(boolean enable) {
        UnixTerminal.exec("/bin/sh", "-c", "/bin/stty " + (enable ? "-icanon" : "icanon") + " < /dev/tty");
    }

    private static void restoreEOFCtrlD() {
        UnixTerminal.exec("/bin/sh", "-c", "/bin/stty eof ^d < /dev/tty");
    }

    private static void disableSpecialCharacters() {
        UnixTerminal.exec("/bin/sh", "-c", "/bin/stty intr undef < /dev/tty");
        UnixTerminal.exec("/bin/sh", "-c", "/bin/stty start undef < /dev/tty");
        UnixTerminal.exec("/bin/sh", "-c", "/bin/stty stop undef < /dev/tty");
        UnixTerminal.exec("/bin/sh", "-c", "/bin/stty susp undef < /dev/tty");
    }

    private static void restoreSpecialCharacters() {
        UnixTerminal.exec("/bin/sh", "-c", "/bin/stty intr ^C < /dev/tty");
        UnixTerminal.exec("/bin/sh", "-c", "/bin/stty start ^Q < /dev/tty");
        UnixTerminal.exec("/bin/sh", "-c", "/bin/stty stop ^S < /dev/tty");
        UnixTerminal.exec("/bin/sh", "-c", "/bin/stty susp ^Z < /dev/tty");
    }

    private void saveSTTY() {
        this.sttyStatusToRestore = UnixTerminal.exec("/bin/sh", "-c", "stty -g < /dev/tty").trim();
    }

    private void restoreSTTY() {
        if (this.sttyStatusToRestore == null) {
            return;
        }
        UnixTerminal.exec("/bin/sh", "-c", "stty " + this.sttyStatusToRestore + " < /dev/tty");
        this.sttyStatusToRestore = null;
    }

    private static String exec(String ... cmd) {
        try {
            ProcessBuilder pb = new ProcessBuilder(cmd);
            Process process = pb.start();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream stdout = process.getInputStream();
            int readByte = stdout.read();
            while (readByte >= 0) {
                baos.write(readByte);
                readByte = stdout.read();
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            BufferedReader reader = new BufferedReader(new InputStreamReader(bais));
            StringBuilder builder = new StringBuilder();
            while (reader.ready()) {
                builder.append(reader.readLine());
            }
            reader.close();
            return builder.toString();
        }
        catch (IOException e) {
            throw new LanternaException(e);
        }
    }

    public static enum Behaviour {
        DEFAULT,
        CTRL_C_KILLS_APPLICATION;

    }
}

