/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui;

import com.googlecode.lanterna.gui.Border;
import com.googlecode.lanterna.gui.Component;
import com.googlecode.lanterna.gui.Container;
import com.googlecode.lanterna.gui.GUIScreen;
import com.googlecode.lanterna.gui.Interactable;
import com.googlecode.lanterna.gui.InteractableContainer;
import com.googlecode.lanterna.gui.TextGraphics;
import com.googlecode.lanterna.gui.Theme;
import com.googlecode.lanterna.gui.component.EmptySpace;
import com.googlecode.lanterna.gui.component.Panel;
import com.googlecode.lanterna.gui.layout.LayoutParameter;
import com.googlecode.lanterna.gui.listener.ComponentAdapter;
import com.googlecode.lanterna.gui.listener.ContainerListener;
import com.googlecode.lanterna.gui.listener.WindowListener;
import com.googlecode.lanterna.input.Key;
import com.googlecode.lanterna.terminal.TerminalPosition;
import com.googlecode.lanterna.terminal.TerminalSize;
import java.util.ArrayList;
import java.util.List;

public class Window {
    private final List<WindowListener> windowListeners = new ArrayList<WindowListener>();
    private final List<ComponentInvalidatorAlert> invalidatorAlerts = new ArrayList<ComponentInvalidatorAlert>();
    private GUIScreen owner = null;
    private final WindowContentPane contentPane;
    private Interactable currentlyInFocus;
    private TerminalSize windowSizeOverride;
    private boolean soloWindow;
    private boolean drawShadow;

    public Window(String title) {
        this.contentPane = new WindowContentPane(title);
        this.currentlyInFocus = null;
        this.soloWindow = false;
        this.windowSizeOverride = null;
        this.drawShadow = true;
    }

    public void addWindowListener(WindowListener listener) {
        this.windowListeners.add(listener);
    }

    public GUIScreen getOwner() {
        return this.owner;
    }

    void setOwner(GUIScreen owner) {
        this.owner = owner;
    }

    public Border getBorder() {
        return this.contentPane.getBorder();
    }

    public void setBorder(Border border) {
        if (border != null) {
            this.contentPane.setBorder(border);
        }
    }

    public TerminalSize getWindowSizeOverride() {
        return this.windowSizeOverride;
    }

    public void setWindowSizeOverride(TerminalSize windowSizeOverride) {
        this.windowSizeOverride = windowSizeOverride;
    }

    TerminalSize getPreferredSize() {
        TerminalSize override = this.getWindowSizeOverride();
        if (override != null) {
            return override;
        }
        return this.contentPane.getPreferredSize();
    }

    void repaint(TextGraphics graphics) {
        graphics.applyTheme(graphics.getTheme().getDefinition(Theme.Category.DIALOG_AREA));
        graphics.fillRectangle(' ', new TerminalPosition(0, 0), new TerminalSize(graphics.getWidth(), graphics.getHeight()));
        this.contentPane.repaint(graphics);
    }

    private void invalidate() {
        for (WindowListener listener : this.windowListeners) {
            listener.onWindowInvalidated(this);
        }
    }

    @Deprecated
    public void addEmptyLine() {
        this.addComponent(new EmptySpace(1, 1), new LayoutParameter[0]);
    }

    public void addComponent(Component component, LayoutParameter ... layoutParameters) {
        if (component == null) {
            return;
        }
        this.contentPane.addComponent(component, layoutParameters);
        ComponentInvalidatorAlert invalidatorAlert = new ComponentInvalidatorAlert(component);
        this.invalidatorAlerts.add(invalidatorAlert);
        component.addComponentListener(invalidatorAlert);
        this.checkFocus();
        this.invalidate();
    }

    void checkFocus() {
        if (this.currentlyInFocus == null) {
            this.setFocus(this.contentPane.nextFocus(null));
            if (this.currentlyInFocus != null) {
                this.invalidate();
            }
        }
    }

    public void addContainerListener(ContainerListener cl) {
        this.contentPane.addContainerListener(cl);
    }

    public void removeContainerListener(ContainerListener cl) {
        this.contentPane.removeContainerListener(cl);
    }

    public Component getComponentAt(int index) {
        return this.contentPane.getComponentAt(index);
    }

    public int getComponentCount() {
        return this.contentPane.getComponentCount();
    }

    public void removeComponent(Component component) {
        if (component instanceof InteractableContainer) {
            InteractableContainer container = (InteractableContainer)((Object)component);
            if (container.hasInteractable(this.currentlyInFocus)) {
                Interactable original = this.currentlyInFocus;
                Interactable current = this.contentPane.nextFocus(original);
                while (container.hasInteractable(current) && original != current) {
                    current = this.contentPane.nextFocus(current);
                }
                if (container.hasInteractable(current)) {
                    this.setFocus(null);
                } else {
                    this.setFocus(current);
                }
            }
        } else if (component == this.currentlyInFocus) {
            this.setFocus(this.contentPane.nextFocus(this.currentlyInFocus));
        }
        this.contentPane.removeComponent(component);
        for (ComponentInvalidatorAlert invalidatorAlert : this.invalidatorAlerts) {
            if (component != invalidatorAlert.component) continue;
            component.removeComponentListener(invalidatorAlert);
            this.invalidatorAlerts.remove(invalidatorAlert);
            break;
        }
    }

    public void removeAllComponents() {
        while (this.getComponentCount() > 0) {
            this.removeComponent(this.getComponentAt(0));
        }
    }

    TerminalPosition getWindowHotspotPosition() {
        if (this.currentlyInFocus == null) {
            return null;
        }
        return this.currentlyInFocus.getHotspot();
    }

    public void onKeyPressed(Key key) {
        if (this.currentlyInFocus != null) {
            Interactable.Result result = this.currentlyInFocus.keyboardInteraction(key);
            if (result.isNextInteractable()) {
                Interactable nextItem = this.contentPane.nextFocus(this.currentlyInFocus);
                if (nextItem == null) {
                    nextItem = this.contentPane.nextFocus(null);
                }
                this.setFocus(nextItem, result.asFocusChangeDirection());
            } else if (result.isPreviousInteractable()) {
                Interactable prevItem = this.contentPane.previousFocus(this.currentlyInFocus);
                if (prevItem == null) {
                    prevItem = this.contentPane.previousFocus(null);
                }
                this.setFocus(prevItem, result.asFocusChangeDirection());
            } else if (result == Interactable.Result.EVENT_NOT_HANDLED) {
                if (this.currentlyInFocus instanceof Component) {
                    for (Container parentContainer = ((Component)((Object)this.currentlyInFocus)).getParent(); parentContainer != null; parentContainer = parentContainer.getParent()) {
                        if (!(parentContainer instanceof InteractableContainer) || !((InteractableContainer)((Object)parentContainer)).triggerShortcut(key)) continue;
                        return;
                    }
                }
                this.onUnhandledKeyPress(key);
            }
        } else {
            this.onUnhandledKeyPress(key);
        }
    }

    private void onUnhandledKeyPress(Key key) {
        for (WindowListener listener : this.windowListeners) {
            listener.onUnhandledKeyboardInteraction(this, key);
        }
    }

    public boolean isSoloWindow() {
        return this.soloWindow;
    }

    public void setSoloWindow(boolean soloWindow) {
        this.soloWindow = soloWindow;
    }

    public boolean isDrawShadow() {
        return this.drawShadow;
    }

    public void setDrawShadow(boolean drawShadow) {
        this.drawShadow = drawShadow;
    }

    boolean maximisesVertically() {
        return this.contentPane.maximisesVertically();
    }

    boolean maximisesHorisontally() {
        return this.contentPane.maximisesHorisontally();
    }

    protected void setFocus(Interactable newFocus) {
        this.setFocus(newFocus, null);
    }

    protected void setFocus(Interactable newFocus, Interactable.FocusChangeDirection direction) {
        if (newFocus == this.currentlyInFocus) {
            return;
        }
        if (this.currentlyInFocus != null) {
            this.currentlyInFocus.onLeaveFocus(direction);
        }
        for (WindowListener listener : this.windowListeners) {
            listener.onFocusChanged(this, this.currentlyInFocus, newFocus);
        }
        this.currentlyInFocus = newFocus;
        if (this.currentlyInFocus != null) {
            this.currentlyInFocus.onEnterFocus(direction);
        }
        this.invalidate();
    }

    protected Interactable getInputFocusedComponent() {
        return this.currentlyInFocus;
    }

    public void close() {
        if (this.owner != null) {
            this.owner.closeWindow(this);
        }
    }

    protected void onVisible() {
        for (WindowListener listener : this.windowListeners) {
            listener.onWindowShown(this);
        }
    }

    protected void onClosed() {
        for (WindowListener listener : this.windowListeners) {
            listener.onWindowClosed(this);
        }
    }

    public String toString() {
        return this.contentPane.getTitle();
    }

    private class WindowContentPane
    extends Panel {
        public WindowContentPane(String title) {
            super(title);
        }

        @Override
        public Window getWindow() {
            return Window.this;
        }
    }

    private class ComponentInvalidatorAlert
    extends ComponentAdapter {
        private Component component;

        public ComponentInvalidatorAlert(Component component) {
            this.component = component;
        }

        public Component getComponent() {
            return this.component;
        }

        @Override
        public void onComponentInvalidated(Component component) {
            Window.this.invalidate();
        }
    }
}

