/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.xpathchooser;

import de.rcenvironment.core.gui.xpathchooser.VariableEntry;
import de.rcenvironment.core.gui.xpathchooser.XPathChooserHelper;
import de.rcenvironment.core.utils.common.variables.legacy.VariableType;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class VariableEditingSupport
extends EditingSupport {
    private static final String[] VALUES = new String[]{VariableType.Integer.toString(), VariableType.Logic.toString(), VariableType.Real.toString(), VariableType.String.toString()};
    private final XPathChooserHelper helper;
    private final Table table;
    private final int column;

    public VariableEditingSupport(XPathChooserHelper parent, ColumnViewer viewer, int aColumn) {
        super(viewer);
        assert (parent != null);
        assert (viewer != null);
        assert (aColumn > 0);
        this.helper = parent;
        this.column = aColumn;
        this.table = ((TableViewer)viewer).getTable();
    }

    protected boolean canEdit(Object element) {
        assert (element instanceof VariableEntry);
        return element != null && this.column >= 1;
    }

    protected CellEditor getCellEditor(Object element) {
        TextCellEditor editor;
        assert (element instanceof VariableEntry);
        assert (this.column >= 1);
        VariableEntry variable = (VariableEntry)element;
        this.helper.updateTreeAttributesFromTableEntry(variable);
        if (this.column == 1) {
            editor = new TextCellEditor((Composite)this.table);
            Text control = (Text)editor.getControl();
            control.setText(variable.getName());
            control.setEditable(true);
            control.selectAll();
            control.setFocus();
        } else if (this.column == 2) {
            editor = new TextCellEditor((Composite)this.table);
            Text control = (Text)editor.getControl();
            control.setText(variable.getXpath());
            control.setEditable(true);
            control.selectAll();
            control.setFocus();
        } else if (this.column == 3) {
            editor = new ComboBoxCellEditor((Composite)this.table, VALUES);
            CCombo control = (CCombo)editor.getControl();
            control.setText(variable.getType().toString());
            control.setListVisible(true);
            control.setEditable(true);
            control.setFocus();
        } else {
            editor = null;
        }
        return editor;
    }

    protected Object getValue(Object element) {
        assert (element instanceof VariableEntry);
        assert (this.column >= 1);
        VariableEntry variable = (VariableEntry)element;
        if (this.column == 1) {
            return variable.getName();
        }
        if (this.column == 2) {
            return variable.getXpath();
        }
        if (this.column == 3) {
            int x = 0;
            int i = 0;
            while (i < VALUES.length) {
                if (VALUES[i].equals(variable.getType().toString())) {
                    x = i;
                    break;
                }
                ++i;
            }
            return x;
        }
        throw new RuntimeException("This should never happen! Missing column?");
    }

    protected void setValue(Object element, Object value) {
    }
}

