/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.parametricstudy.common.internal;

import de.rcenvironment.components.parametricstudy.common.ParametricStudyService;
import de.rcenvironment.components.parametricstudy.common.Study;
import de.rcenvironment.components.parametricstudy.common.StudyPublisher;
import de.rcenvironment.components.parametricstudy.common.StudyReceiver;
import de.rcenvironment.components.parametricstudy.common.StudyStructure;
import de.rcenvironment.components.parametricstudy.common.internal.StudyPublisherImpl;
import de.rcenvironment.components.parametricstudy.common.internal.StudyReceiverImpl;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.notification.DistributedNotificationService;
import de.rcenvironment.core.notification.Notification;
import de.rcenvironment.core.notification.NotificationService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public class ParametricStudyServiceImpl
implements ParametricStudyService {
    private NotificationService notificationService;
    private DistributedNotificationService distributedNotificationService;

    protected void bindNotificationService(NotificationService newNotificationService) {
        this.notificationService = newNotificationService;
    }

    protected void bindDistributedNotificationService(DistributedNotificationService newDistrNotificationService) {
        this.distributedNotificationService = newDistrNotificationService;
    }

    @Override
    public StudyPublisher createPublisher(String identifier, String title, StudyStructure structure) {
        Study study = new Study(identifier, title, structure);
        StudyPublisherImpl studyPublisher = new StudyPublisherImpl(study, this.notificationService);
        String notificationId = StringUtils.format((String)"study.structure.%s", (Object[])new Object[]{study.getIdentifier()});
        this.notificationService.setBufferSize(notificationId, 1);
        this.notificationService.send(notificationId, (Serializable)new Serializable[]{study.getStructure(), title});
        return studyPublisher;
    }

    @Override
    public StudyReceiver createReceiver(String identifier, ResolvableNodeId node) {
        String notificationId = StringUtils.format((String)"study.structure.%s", (Object[])new Object[]{identifier});
        try {
            List notifications = (List)this.distributedNotificationService.getNotifications(notificationId, node).get(notificationId);
            if (notifications != null && notifications.size() > 0) {
                Notification studyNotification = (Notification)notifications.get(notifications.size() - 1);
                Serializable[] notificationContent = (Serializable[])studyNotification.getBody();
                StudyStructure structure = (StudyStructure)notificationContent[0];
                String title = (String)((Object)notificationContent[1]);
                Study study = new Study(identifier, title, structure);
                StudyReceiverImpl studyReceiver = new StudyReceiverImpl(study, node, this.distributedNotificationService);
                return studyReceiver;
            }
        }
        catch (RemoteOperationException remoteOperationException) {
            LogFactory.getLog(this.getClass()).error((Object)"Failed to get remote notifications.");
        }
        return null;
    }
}

