/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.converger.execution;

import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.model.spi.AbstractNestedLoopComponent;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.FloatTD;
import de.rcenvironment.core.datamodel.types.api.IntegerTD;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.queue.CircularFifoQueue;

public class ConvergerComponent
extends AbstractNestedLoopComponent {
    private static final int NO_MAX_CONVERGENCE_CHECKS = -1;
    private Map<String, CircularFifoQueue<Double>> valueTuples;
    private double epsA;
    private double epsR;
    private int valueTuplesToConsider;
    private int valueTuplesProcessed = 0;
    private int maxConvergenceChecks = -1;
    private int convergenceChecks = 0;
    private NotConvergedBehavior notConvergedBehavior;
    private Boolean[] isConverged;
    private Map<String, Boolean[]> isSingleConverged;

    private NotConvergedBehavior getNotConvergedBehavior() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("notConvFail")).booleanValue()) {
            return NotConvergedBehavior.Fail;
        }
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("notConvNotAValue")).booleanValue()) {
            return NotConvergedBehavior.NotAValue;
        }
        return NotConvergedBehavior.Ignore;
    }

    public void startNestedComponentSpecific() throws ComponentException {
        this.epsA = Double.parseDouble(this.componentContext.getConfigurationValue("epsA"));
        this.epsR = Double.parseDouble(this.componentContext.getConfigurationValue("epsR"));
        String iterationsToConsiderAsString = this.componentContext.getConfigurationValue("iterationsToConsider");
        this.valueTuplesToConsider = Integer.parseInt(iterationsToConsiderAsString) + 1;
        String maxConvergenceChecksAsString = this.componentContext.getConfigurationValue("maxConvChecks");
        if (maxConvergenceChecksAsString != null && !maxConvergenceChecksAsString.isEmpty()) {
            this.maxConvergenceChecks = Integer.parseInt(maxConvergenceChecksAsString);
        }
        this.initializeIterationValues();
        this.isConverged = new Boolean[2];
        this.isConverged[0] = false;
        this.isConverged[1] = false;
        this.isSingleConverged = new HashMap<String, Boolean[]>();
        for (String inputName : this.componentContext.getInputs()) {
            Boolean[] isInputConverged = new Boolean[]{false, false};
            this.isSingleConverged.put(inputName, isInputConverged);
        }
        this.notConvergedBehavior = this.getNotConvergedBehavior();
        if (!this.hasStartValueInputs()) {
            this.sendValuesNestedComponentSpecific();
        }
    }

    public boolean treatStartAsComponentRun() {
        return !this.hasStartValueInputs();
    }

    private boolean hasStartValueInputs() {
        for (String input : this.componentContext.getInputs()) {
            if (!input.endsWith("_start")) continue;
            return true;
        }
        return false;
    }

    private void initializeIterationValues() {
        this.valueTuples = new HashMap<String, CircularFifoQueue<Double>>();
        for (String inputName : this.componentContext.getInputs()) {
            if (this.componentContext.isDynamicInput(inputName) && this.componentContext.getDynamicInputIdentifier(inputName).equals("valueToConverge") && !inputName.endsWith("_start")) {
                this.valueTuples.put(inputName, (CircularFifoQueue<Double>)new CircularFifoQueue(this.valueTuplesToConsider));
            }
            if (inputName.endsWith("_start") || !Boolean.parseBoolean(this.componentContext.getInputMetaDataValue(inputName, "hasStartValue"))) continue;
            this.valueTuples.get(inputName).add((Object)Double.parseDouble(this.componentContext.getInputMetaDataValue(inputName, "startValue")));
        }
    }

    private void addValuesToLastIterationsValues(boolean startValues) {
        for (String inputName : this.valueTuples.keySet()) {
            if (startValues && this.componentContext.getInputs().contains(String.valueOf(inputName) + "_start")) {
                this.valueTuples.get(inputName).add((Object)((FloatTD)this.componentContext.readInput(String.valueOf(inputName) + "_start")).getFloatValue());
                continue;
            }
            if (startValues) continue;
            if (this.componentContext.getInputDataType(inputName) == DataType.Float) {
                this.valueTuples.get(inputName).add((Object)((FloatTD)this.componentContext.readInput(inputName)).getFloatValue());
                continue;
            }
            if (this.componentContext.getInputDataType(inputName) != DataType.Integer) continue;
            this.valueTuples.get(inputName).add((Object)((IntegerTD)this.componentContext.readInput(inputName)).getIntValue());
        }
    }

    private boolean areMaxConvergenceChecksReached() {
        return this.maxConvergenceChecks != -1 && this.convergenceChecks >= this.maxConvergenceChecks;
    }

    private Map<String, Boolean[]> isSingleConverged() {
        boolean convergenceCheckSkipped = false;
        HashMap<String, Boolean[]> isInputConverged = new HashMap<String, Boolean[]>();
        for (String inputName : this.valueTuples.keySet()) {
            boolean isCurrentConvergedRel;
            boolean isCurrentConvergedAbs;
            CircularFifoQueue<Double> values = this.valueTuples.get(inputName);
            int valueCount = values.size();
            int[] range = this.getValueTupleRange();
            if (valueCount >= this.valueTuplesToConsider) {
                double minValue;
                double maxValue = Collections.max(values);
                isCurrentConvergedAbs = Math.abs(maxValue - (minValue = Collections.min(values).doubleValue())) <= this.epsA;
                isCurrentConvergedRel = Math.abs((maxValue - minValue) / maxValue) <= this.epsR;
                this.componentLog.componentInfo(StringUtils.format((String)"%s [%d->%d] -> min: %s; max: %s; conv abs: %s; conv rel: %s; #conv check: %d", (Object[])new Object[]{inputName, range[0], range[1], minValue, maxValue, isCurrentConvergedAbs, isCurrentConvergedRel, this.convergenceChecks + 1}));
            } else {
                isCurrentConvergedAbs = false;
                isCurrentConvergedRel = false;
                convergenceCheckSkipped = true;
                this.componentLog.componentInfo(StringUtils.format((String)"%s [%d->%d] -> skipped convergence check - not enough values yet (current: %s, required: %s)", (Object[])new Object[]{inputName, range[0], range[1], valueCount, this.valueTuplesToConsider}));
            }
            Boolean[] isThisInputConverged = new Boolean[]{isCurrentConvergedAbs, isCurrentConvergedRel};
            isInputConverged.put(inputName, isThisInputConverged);
        }
        if (!convergenceCheckSkipped) {
            ++this.convergenceChecks;
        }
        return isInputConverged;
    }

    private Boolean[] isConverged(Map<String, Boolean[]> isInputConverged) {
        boolean isConvergedAbs = !this.valueTuples.isEmpty();
        boolean isConvergedRel = !this.valueTuples.isEmpty();
        for (String inputName : this.valueTuples.keySet()) {
            Boolean[] isThisInputConverged = isInputConverged.get(inputName);
            if (!isThisInputConverged[0].booleanValue()) {
                isConvergedAbs = false;
            }
            if (isThisInputConverged[1].booleanValue()) continue;
            isConvergedRel = false;
        }
        return new Boolean[]{isConvergedAbs, isConvergedRel};
    }

    private int[] getValueTupleRange() {
        int rangeStart = this.valueTuplesProcessed - this.valueTuplesToConsider + 1;
        if (rangeStart < 0) {
            rangeStart = 0;
        }
        return new int[]{rangeStart, this.valueTuplesProcessed};
    }

    protected void sendValuesNestedComponentSpecific() {
        for (String inputName : this.valueTuples.keySet()) {
            if (this.valueTuples.get(inputName).isEmpty()) continue;
            if (this.componentContext.getInputDataType(inputName) == DataType.Float) {
                this.writeOutput(inputName, (TypedDatum)this.typedDatumFactory.createFloat(((Double)this.valueTuples.get(inputName).get(this.valueTuples.get(inputName).size() - 1)).doubleValue()));
            } else if (this.componentContext.getInputDataType(inputName) == DataType.Integer) {
                double value = (Double)this.valueTuples.get(inputName).get(this.valueTuples.get(inputName).size() - 1);
                this.writeOutput(inputName, (TypedDatum)this.typedDatumFactory.createInteger((long)value));
            }
            this.writeOutput(String.valueOf(inputName) + "_is_converged", (TypedDatum)this.typedDatumFactory.createBoolean(this.isSingleConverged.get(inputName)[0] != false || this.isSingleConverged.get(inputName)[1] != false));
        }
    }

    private void forwardFinalValues() {
        Set inputs = this.componentContext.getInputsWithDatum();
        for (String input : inputs) {
            if (!this.componentContext.getDynamicInputIdentifier(input).equals("toForward")) continue;
            this.writeOutput(String.valueOf(input) + "_converged", this.componentContext.readInput(input));
        }
    }

    private void sendConvergedValues() {
        if (this.notConvergedBehavior == NotConvergedBehavior.NotAValue && this.areMaxConvergenceChecksReached()) {
            TypedDatumFactory factory = ((TypedDatumService)this.componentContext.getService(TypedDatumService.class)).getFactory();
            this.componentContext.writeOutput("Converged", (TypedDatum)factory.createNotAValue());
            this.componentContext.writeOutput("Converged absolute", (TypedDatum)factory.createNotAValue());
            this.componentContext.writeOutput("Converged relative", (TypedDatum)factory.createNotAValue());
        } else {
            this.writeOutput("Converged", (TypedDatum)this.typedDatumFactory.createBoolean(this.isConverged[0] | this.isConverged[1]));
            this.writeOutput("Converged absolute", (TypedDatum)this.typedDatumFactory.createBoolean(this.isConverged[0].booleanValue()));
            this.writeOutput("Converged relative", (TypedDatum)this.typedDatumFactory.createBoolean(this.isConverged[1].booleanValue()));
        }
    }

    protected void resetNestedComponentSpecific() {
        this.convergenceChecks = 0;
        for (CircularFifoQueue<Double> queues : this.valueTuples.values()) {
            queues.clear();
        }
        this.isConverged[0] = false;
        this.isConverged[1] = false;
        this.valueTuplesProcessed = 0;
    }

    protected void finishLoopNestedComponentSpecific() {
        this.componentLog.componentInfo("Finished: converged abs: " + this.isConverged[0] + "; converged rel: " + this.isConverged[1] + "; reached max. conv checks: " + this.areMaxConvergenceChecksReached());
    }

    protected boolean isDoneNestedComponentSpecific() {
        return this.isConverged[0] != false || this.isConverged[1] != false || this.areMaxConvergenceChecksReached();
    }

    protected void processInputsNestedComponentSpecific() {
        this.addValuesToLastIterationsValues(((String)this.componentContext.getInputsWithDatum().iterator().next()).endsWith("_start"));
        this.isSingleConverged = this.isSingleConverged();
        this.isConverged = this.isConverged(this.isSingleConverged);
        ++this.valueTuplesProcessed;
    }

    protected void sendFinalValues() throws ComponentException {
        boolean maxIterationsReached = this.areMaxConvergenceChecksReached();
        TypedDatumFactory factory = ((TypedDatumService)this.componentContext.getService(TypedDatumService.class)).getFactory();
        if (this.notConvergedBehavior == NotConvergedBehavior.Fail && maxIterationsReached) {
            throw new ComponentException("Maximum number of checks reached without convergence.");
        }
        if (this.notConvergedBehavior == NotConvergedBehavior.NotAValue && maxIterationsReached) {
            this.componentContext.getLog().componentError(StringUtils.format((String)"Maximum number of checks (%d) reached without convergence", (Object[])new Object[]{this.maxConvergenceChecks}));
        }
        for (String key : this.valueTuples.keySet()) {
            int valueCount = this.valueTuples.get(key).size();
            if (valueCount <= 0) continue;
            if (this.notConvergedBehavior == NotConvergedBehavior.NotAValue && maxIterationsReached) {
                this.componentContext.writeOutput(String.valueOf(key) + "_converged", (TypedDatum)factory.createNotAValue());
                continue;
            }
            if (this.componentContext.getOutputDataType(key).equals((Object)DataType.Float)) {
                this.writeOutput(String.valueOf(key) + "_converged", (TypedDatum)this.typedDatumFactory.createFloat(((Double)this.valueTuples.get(key).get(valueCount - 1)).doubleValue()));
                continue;
            }
            if (!this.componentContext.getOutputDataType(key).equals((Object)DataType.Integer)) continue;
            long value = (long)((Double)this.valueTuples.get(key).get(valueCount - 1)).doubleValue();
            this.writeOutput(String.valueOf(key) + "_converged", (TypedDatum)this.typedDatumFactory.createInteger(value));
        }
        this.forwardFinalValues();
        this.sendConvergedValues();
    }

    private static enum NotConvergedBehavior {
        Ignore,
        Fail,
        NotAValue;

    }
}

