/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.bootstrap.launcher.internal;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public final class RCELauncherCustomization {
    private static final String CONFIGURATION_FILE_NAME = "logging.xml";
    private static final boolean CONFIGURE_ALL_LOG4J2_LOGGERS_AS_ASYNCHRONOUS = true;
    static final String SYSTEM_PROPERTY_KEY_BUNDLE_CONFIGURATION_LOCATION = "bundles.configuration.location";
    static final String SYSTEM_PROPERTY_KEY_OSGI_INSTALL_AREA = "osgi.install.area";
    private static final String SYSTEM_PROPERTY_KEY_RCE_INSTANCE_RUN_ID = "rce.instanceRunId";
    private static final String FILE_SCHEMA = "file:";
    @Deprecated
    private static final String PROP_RCE_LAUNCHER = "de.rcenvironment.launcher";
    private static final String ERROR_MESSAGE_OSGI_INSTALL_AREA_MISCONFIGURED = "osgi.install.area is not configured correctly: ";
    private static RCELauncherCustomization RCE_LAUNCHER_CONTEXT;
    private boolean verboseOutputEnabled = false;
    private boolean privilegedModeAllowed = false;
    private final String instanceRunId;

    private RCELauncherCustomization(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if ("--rce.debug.launcher".equals(arg)) {
                this.verboseOutputEnabled = true;
            } else if ("--allow-privileged".equals(arg)) {
                this.privilegedModeAllowed = true;
            }
            ++n2;
        }
        this.instanceRunId = String.valueOf(Long.toString(System.currentTimeMillis())) + "-" + Long.toString(new Random().nextLong() & Long.MAX_VALUE);
    }

    public static void initialize(String[] args) {
        if (RCE_LAUNCHER_CONTEXT != null) {
            throw new IllegalArgumentException();
        }
        RCE_LAUNCHER_CONTEXT = new RCELauncherCustomization(args);
        RCELauncherCustomization.setRceLauncherMarkerSystemProperty();
        RCELauncherCustomization.setLauncherVersionAsSystemProperty();
        RCELauncherCustomization.setInstanceRunIdAsSystemProperty(RCELauncherCustomization.RCE_LAUNCHER_CONTEXT.instanceRunId);
    }

    public static void hookAfterInitialConfigurationProcessing() {
        Optional<File> configurationLocation = RCELauncherCustomization.resolveAndStandardizeConfigurationLocation();
        if (configurationLocation.isPresent()) {
            File configurationLocationFile = configurationLocation.get();
            if (RCELauncherCustomization.verboseOutputEnabled()) {
                System.err.println("Resolved configuration location: " + configurationLocationFile);
            }
            RCELauncherCustomization.configurePaxLogging(configurationLocationFile);
        } else {
            System.err.println("Failed to resolve configuration location; logging will not be configured properly");
        }
        RCELauncherCustomization.abortStartupIfPrivileged();
        if (RCELauncherCustomization.verboseOutputEnabled()) {
            RCELauncherCustomization.dumpFinalSystemProperties();
        }
    }

    private static void abortStartupIfPrivileged() {
        boolean privilegedIsNotAllowed;
        boolean isPrivileged = RCELauncherCustomization.checkPrivileged();
        boolean bl = privilegedIsNotAllowed = !RCELauncherCustomization.RCE_LAUNCHER_CONTEXT.privilegedModeAllowed;
        if (isPrivileged && privilegedIsNotAllowed) {
            String privilegeError = "RCE was started with admin privileges without setting the --allow-privileged flag";
            System.err.println(privilegeError);
            throw new IllegalStateException(privilegeError);
        }
    }

    private static boolean checkPrivileged() {
        PrintStream err = System.err;
        System.setErr(new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
            }
        }));
        try {
            Preferences preferences = Preferences.systemRoot();
            String privilegeCheckKey = "rce_d47c7287-4e4d-4970-840a-b65b69c2a4e7";
            preferences.put(privilegeCheckKey, "temp_privileged_process_check");
            preferences.remove(privilegeCheckKey);
            preferences.flush();
            return true;
        }
        catch (SecurityException | BackingStoreException exception) {
            return false;
        }
        finally {
            System.setErr(err);
        }
    }

    public static String[] rewriteCommandLineArguments(String[] args) {
        if (RCELauncherCustomization.verboseOutputEnabled()) {
            System.err.println("Command-line parameters as seen by the launcher JAR:");
            RCELauncherCustomization.dumpArgumentsArray(args);
        }
        HashSet<String> implicitNoSplashArguments = new HashSet<String>();
        implicitNoSplashArguments.add("--headless");
        implicitNoSplashArguments.add("--server");
        implicitNoSplashArguments.add("--configure");
        implicitNoSplashArguments.add("--batch");
        implicitNoSplashArguments.add("--exec");
        implicitNoSplashArguments.add("--shutdown");
        implicitNoSplashArguments.add("--version");
        ArrayList<String> rewrittenArgs = new ArrayList<String>(args.length);
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.equals("--console")) {
                rewrittenArgs.add("-console");
            } else if (arg.startsWith("--rce.")) {
                String argWithoutDashes = arg.substring(2);
                RCELauncherCustomization.convertCompositeArgumentIntoSystemProperty(argWithoutDashes);
            } else {
                if (implicitNoSplashArguments.contains(arg)) {
                    rewrittenArgs.add("-nosplash");
                }
                rewrittenArgs.add(arg);
            }
            ++n2;
        }
        args = rewrittenArgs.toArray(new String[rewrittenArgs.size()]);
        if (RCELauncherCustomization.verboseOutputEnabled()) {
            System.err.println("Command-line parameters after rewriting:");
            RCELauncherCustomization.dumpArgumentsArray(args);
        }
        return args;
    }

    private static void convertCompositeArgumentIntoSystemProperty(String withoutDashes) {
        String[] parts = withoutDashes.split("=", 2);
        if (parts.length == 2) {
            if (RCELauncherCustomization.verboseOutputEnabled()) {
                System.err.println("Converted RCE command-line parameter to system property '" + parts[0] + "' with value '" + parts[1] + "'");
            }
            System.setProperty(parts[0], parts[1]);
        } else {
            if (RCELauncherCustomization.verboseOutputEnabled()) {
                System.err.println("Converted RCE command-line flag to system property '" + parts[0] + "' with empty value");
            }
            System.setProperty(parts[0], "");
        }
    }

    private static void dumpArgumentsArray(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            System.err.println("| " + arg);
            ++n2;
        }
    }

    private static void dumpFinalSystemProperties() {
        TreeMap<Object, Object> sortedMap = new TreeMap<Object, Object>(System.getProperties());
        System.err.println("Final System Properties:");
        sortedMap.forEach((key, value) -> System.err.println("| " + key + " = \"" + value + "\""));
    }

    private static void setRceLauncherMarkerSystemProperty() {
        System.getProperties().put(PROP_RCE_LAUNCHER, PROP_RCE_LAUNCHER);
    }

    private static void setLauncherVersionAsSystemProperty() {
        System.getProperties().put("de.rcenvironment.launcher.version", Integer.toString(810));
    }

    private static void setInstanceRunIdAsSystemProperty(String instanceRunId) {
        System.getProperties().put(SYSTEM_PROPERTY_KEY_RCE_INSTANCE_RUN_ID, instanceRunId);
    }

    private static Optional<File> resolveAndStandardizeConfigurationLocation() {
        String bundleConfigurationLocation = System.getProperty(SYSTEM_PROPERTY_KEY_BUNDLE_CONFIGURATION_LOCATION);
        if (bundleConfigurationLocation == null) {
            return Optional.empty();
        }
        File bundleConfigurationLocationFile = new File(bundleConfigurationLocation);
        boolean absolute = bundleConfigurationLocationFile.isAbsolute();
        if (absolute) {
            return Optional.of(bundleConfigurationLocationFile);
        }
        String osgiInstallArea = System.getProperty(SYSTEM_PROPERTY_KEY_OSGI_INSTALL_AREA);
        if (osgiInstallArea == null) {
            System.err.println(ERROR_MESSAGE_OSGI_INSTALL_AREA_MISCONFIGURED + osgiInstallArea);
            return Optional.empty();
        }
        File osgiInstallAreaFile = osgiInstallArea.startsWith(FILE_SCHEMA) ? new File(osgiInstallArea.substring(FILE_SCHEMA.length())) : new File(osgiInstallArea);
        if (osgiInstallAreaFile.exists() && osgiInstallAreaFile.isDirectory()) {
            File resolvedBundleConfigurationLocation = new File(osgiInstallAreaFile, bundleConfigurationLocation).getAbsoluteFile();
            System.setProperty(SYSTEM_PROPERTY_KEY_BUNDLE_CONFIGURATION_LOCATION, resolvedBundleConfigurationLocation.getAbsolutePath());
            return Optional.of(resolvedBundleConfigurationLocation);
        }
        System.err.println(ERROR_MESSAGE_OSGI_INSTALL_AREA_MISCONFIGURED + osgiInstallArea);
        return Optional.empty();
    }

    private static void configurePaxLogging(File configurationLocationDir) {
        if (!RCELauncherCustomization.verboseOutputEnabled()) {
            System.setProperty("org.ops4j.pax.logging.DefaultServiceLog.level", "ERROR");
        } else {
            System.setProperty("org.ops4j.pax.logging.DefaultServiceLog.level", "DEBUG");
        }
        File startupLogsDir = new File(System.getProperty("user.home"), ".rce/common/startup_logs");
        startupLogsDir.mkdirs();
        if (!startupLogsDir.isDirectory() && startupLogsDir.canWrite()) {
            throw new IllegalStateException("Startup log directory is not writable: " + startupLogsDir.getAbsolutePath());
        }
        System.setProperty("rce.startupLogsPath", startupLogsDir.getAbsolutePath());
        System.setProperty("org.ops4j.pax.logging.property.file", new File(configurationLocationDir, CONFIGURATION_FILE_NAME).getAbsolutePath());
        System.setProperty("log4j2.formatMsgNoLookups", "true");
        System.setProperty("log4j2.contextSelector", "org.apache.logging.log4j.core.async.AsyncLoggerContextSelector");
    }

    private static boolean verboseOutputEnabled() {
        return RCELauncherCustomization.RCE_LAUNCHER_CONTEXT.verboseOutputEnabled;
    }
}

