/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.logging;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

@Plugin(name="RCELogEventRewritePolicy", elementType="rewritePolicy", category="Core")
public class RCELogEventRewritePolicy
implements RewritePolicy {
    @PluginFactory
    public static RCELogEventRewritePolicy createInstance() {
        return new RCELogEventRewritePolicy();
    }

    public LogEvent rewrite(LogEvent event) {
        Throwable cause;
        Level originalLevel = event.getLevel();
        String messageTemplate = event.getMessage().getFormat();
        if (messageTemplate == null) {
            return event;
        }
        if (originalLevel == Level.DEBUG && messageTemplate.startsWith("bundle ")) {
            return this.suppressMessage(event);
        }
        if (originalLevel == Level.WARN && messageTemplate.endsWith("stream is already closed")) {
            return this.reduceLogLevelWithMessagePrefix(event, Level.DEBUG);
        }
        if (originalLevel == Level.ERROR && messageTemplate.startsWith("FrameworkEvent ") && (cause = event.getThrown()) != null && cause.getMessage() != null && cause.getMessage().startsWith("Exception in org.eclipse.debug.core.DebugPlugin.stop()")) {
            return this.reduceLogLevelWithMessagePrefix(event, Level.DEBUG);
        }
        if (originalLevel == Level.WARN && messageTemplate.startsWith("Unable to consume Lucene index from bundle 'org.eclipse.")) {
            return this.reduceLogLevelWithMessagePrefix(event, Level.DEBUG);
        }
        if (originalLevel == Level.WARN && messageTemplate.startsWith("Couldn't flush system prefs")) {
            return this.reduceLogLevelWithMessagePrefix(event, Level.DEBUG);
        }
        return event;
    }

    private Log4jLogEvent suppressMessage(LogEvent event) {
        return this.reduceLogLevel(event, Level.TRACE);
    }

    private Log4jLogEvent reduceLogLevel(LogEvent event, Level newLevel) {
        return new Log4jLogEvent.Builder(event).setLevel(newLevel).build();
    }

    private Log4jLogEvent reduceLogLevelWithMessagePrefix(LogEvent event, Level newLevel) {
        Message originalMessage = event.getMessage();
        FormattedMessage substituteMessage = new FormattedMessage(String.format("[Log level reduced from %s] %s", event.getLevel().name(), originalMessage.getFormat()), originalMessage.getParameters());
        return new Log4jLogEvent.Builder(event).setMessage((Message)substituteMessage).setLevel(newLevel).build();
    }
}

