/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.gui;

import de.rcenvironment.components.switchcmp.gui.SwitchConditionSection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.AddDynamicEndpointCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import java.util.HashMap;
import java.util.Map;

public class SwitchAddDynamicEndpointCommand
extends AddDynamicEndpointCommand {
    public SwitchAddDynamicEndpointCommand(EndpointType direction, String id, String name, DataType type, Map<String, String> metaData, Refreshable[] refreshable) {
        super(direction, id, name, type, metaData, refreshable);
    }

    public void execute() {
        super.execute();
        WorkflowNode workflowNode = this.getWorkflowNode();
        String conTable = workflowNode.getConfigurationDescription().getConfigurationValue("conditionKey");
        int numOfCon = SwitchConditionSection.getTableContentLength(conTable);
        if (numOfCon != 0) {
            HashMap outputMetaData = new HashMap();
            int i = 1;
            while (i <= numOfCon) {
                workflowNode.getOutputDescriptionsManager().addDynamicEndpointDescription("dataToOutput", String.valueOf(this.name) + "_condition" + " " + i, this.type, outputMetaData);
                if (i == 1) {
                    workflowNode.getOutputDescriptionsManager().addDynamicEndpointDescription("dataToOutput", String.valueOf(this.name) + "_no match", this.type, outputMetaData);
                }
                ++i;
            }
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }

    public void undo() {
        super.undo();
        WorkflowNode workflowNode = this.getWorkflowNode();
        String conTable = workflowNode.getConfigurationDescription().getConfigurationValue("conditionKey");
        int numOfCon = SwitchConditionSection.getTableContentLength(conTable);
        if (numOfCon != 0) {
            int i = 1;
            while (i <= numOfCon) {
                workflowNode.getOutputDescriptionsManager().removeDynamicEndpointDescription(String.valueOf(this.name) + "_condition" + " " + i);
                if (i == 1) {
                    workflowNode.getOutputDescriptionsManager().removeDynamicEndpointDescription(String.valueOf(this.name) + "_no match");
                }
                ++i;
            }
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }
}

