/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.instancemanagement.internal;

import de.rcenvironment.core.instancemanagement.internal.InstanceOperationsUtils;
import de.rcenvironment.core.shutdown.HeadlessShutdown;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;

public class InstanceShutdownTask
implements Runnable {
    private static final String SINGLE_QUOTE = "'";
    private static final String FAILED_TO_SHUTDOWN_MESSAGE = "Failed to shut down instance '%s' - aborted with message '%s'";
    private final File profile;
    private final long timeout;
    private final TextOutputReceiver userOutputReceiver;
    private final CountDownLatch globalLatch;
    private final CountDownLatch indicatesShutdownSuccess;

    public InstanceShutdownTask(File profile, long timeout, TextOutputReceiver userOutputReceiver, CountDownLatch globalLatch, CountDownLatch indicatesShutdownSuccess) {
        this.profile = profile;
        this.timeout = timeout;
        this.userOutputReceiver = userOutputReceiver;
        this.globalLatch = globalLatch;
        this.indicatesShutdownSuccess = indicatesShutdownSuccess;
    }

    @Override
    @TaskDescription(value="Instance Management: Shutting down an instance")
    public void run() {
        try {
            InstanceOperationsUtils.lockIMLockFile(this.profile, this.timeout);
        }
        catch (IOException iOException) {
            this.userOutputReceiver.addOutput(StringUtils.format((String)"Timeout reached while trying to acquire the lock, aborting startup of instance with id: %s.", (Object[])new Object[]{this.profile.getName()}));
            this.releaseLockIfErrorOccurs();
            return;
        }
        try {
            if (!InstanceOperationsUtils.isProfileLocked(this.profile)) {
                this.releaseLockIfErrorOccurs();
                return;
            }
        }
        catch (IOException e) {
            this.userOutputReceiver.addOutput("Couldn't check if instance '" + this.profile.getName() + "' is running - aborted with message '" + e.getMessage() + SINGLE_QUOTE);
            this.releaseLockIfErrorOccurs();
            return;
        }
        try {
            if (!InstanceOperationsUtils.awaitShutdownFile(this.profile.toPath(), 30000)) {
                this.releaseLockIfErrorOccurs();
            }
        }
        catch (IOException iOException) {
            this.userOutputReceiver.addOutput("Unexpected failure while detecting shutdown file.");
            this.releaseLockIfErrorOccurs();
            return;
        }
        try {
            this.userOutputReceiver.addOutput("Trying to shutdown instance '" + this.profile.getName() + SINGLE_QUOTE);
            new HeadlessShutdown().shutdownExternalInstance(this.profile);
        }
        catch (IOException e) {
            this.userOutputReceiver.addOutput(StringUtils.format((String)FAILED_TO_SHUTDOWN_MESSAGE, (Object[])new Object[]{this.profile.getName(), e.getMessage()}));
            this.releaseLockIfErrorOccurs();
            return;
        }
        int i = 0;
        while (i < 50) {
            try {
                if (!InstanceOperationsUtils.isProfileLocked(this.profile)) {
                    InstanceOperationsUtils.deleteInstanceLockFromProfileFolder(this.profile);
                    this.globalLatch.countDown();
                    this.indicatesShutdownSuccess.countDown();
                    this.userOutputReceiver.addOutput("Successfully shut down instance '" + this.profile.getName() + SINGLE_QUOTE);
                    return;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    this.userOutputReceiver.addOutput(StringUtils.format((String)FAILED_TO_SHUTDOWN_MESSAGE, (Object[])new Object[]{this.profile.getName(), e.getMessage()}));
                    this.releaseLockIfErrorOccurs();
                    return;
                }
            }
            catch (IOException iOException) {
                this.userOutputReceiver.addOutput("Failed to check profile lock of instance '" + this.profile.getName() + SINGLE_QUOTE);
                this.releaseLockIfErrorOccurs();
                return;
            }
            ++i;
        }
        this.releaseLockIfErrorOccurs();
        this.userOutputReceiver.addOutput(StringUtils.format((String)FAILED_TO_SHUTDOWN_MESSAGE, (Object[])new Object[]{this.profile.getName(), "unexpected failure."}));
    }

    private void releaseLockIfErrorOccurs() {
        this.indicatesShutdownSuccess.countDown();
        this.globalLatch.countDown();
    }
}

