/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.backend.metadata.derby.internal;

import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.datamanagement.DataManagementIdMapping;
import de.rcenvironment.core.datamanagement.commons.BinaryReference;
import de.rcenvironment.core.datamanagement.commons.ComponentInstance;
import de.rcenvironment.core.datamanagement.commons.ComponentRun;
import de.rcenvironment.core.datamanagement.commons.ComponentRunInterval;
import de.rcenvironment.core.datamanagement.commons.DataReference;
import de.rcenvironment.core.datamanagement.commons.EndpointData;
import de.rcenvironment.core.datamanagement.commons.EndpointInstance;
import de.rcenvironment.core.datamanagement.commons.TimelineInterval;
import de.rcenvironment.core.datamanagement.commons.WorkflowRun;
import de.rcenvironment.core.datamanagement.commons.WorkflowRunDescription;
import de.rcenvironment.core.datamodel.api.CompressionFormat;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.datamodel.api.FinalComponentRunState;
import de.rcenvironment.core.datamodel.api.FinalComponentState;
import de.rcenvironment.core.datamodel.api.FinalWorkflowState;
import de.rcenvironment.core.datamodel.api.TimelineIntervalType;
import de.rcenvironment.core.utils.common.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DerbyMetaDataBackendOperationsImpl {
    private static final String IS_NULL = " IS NULL ";
    private static final String SINGE_QOUTE = "'";
    private static final String NOT_EQUAL = " != ";
    private static final int NOT_MARKED_TO_BE_DELETED = 0;
    private static final int WORKFLOW_RUN_TO_BE_DELETED = 1;
    private static final int MAX_VALUE_LENGTH = 32672;
    private static final String BRACKET_STRING_PLACEHOLDER = "(%s)";
    private static final String DB_PREFIX = "APP.";
    private static final String STRING_PLACEHOLDER = "%s";
    private static final String PLACEHOLDER_FOUR_VALUES = "(?,?,?,?)";
    private static final String PLACEHOLDER_THREE_VALUES = "(?,?,?)";
    private static final String PLACEHOLDER_TWO_VALUES = "(?,?)";
    private static final String QMARK = " ? ";
    private static final String WHERE = " WHERE ";
    private static final String EQUAL = " = ";
    private static final String COMMA = " , ";
    private static final String AND = " AND ";
    private static final String SELECT = " SELECT ";
    private static final String FROM = " FROM ";
    private static final String ORDER_BY = " ORDER BY ";
    private static final String DELETE_FROM = " DELETE FROM ";
    private static final String INSERT_INTO = " INSERT INTO ";
    private static final String UPDATE = " UPDATE ";
    private static final String SET = " SET ";
    private static final String VALUES = " VALUES ";
    private static final String DESCENDING = " DESC ";
    private static final String DOT = ".";
    private static final String INNER_JOIN = " INNER JOIN ";
    private static final String ON = " ON ";
    private static final String SELECT_ALL = " SELECT * ";
    private static final String IN = " IN ";

    public Long addWorkflowRun(String workflowTitle, String workflowControllerNodeId, String workflowDataManagementNodeId, Connection connection, Boolean isRetry) throws SQLException {
        Long id;
        String sql = " INSERT INTO APP.WORKFLOW_RUN(NAME , CONTROLLER_NODE_ID , DATAMANAGEMENT_NODE_ID , TO_BE_DELETED) VALUES (?,?,?,?)";
        try (PreparedStatement stmt = null;){
            stmt = connection.prepareStatement(sql, 1);
            stmt.setString(1, workflowTitle);
            stmt.setString(2, workflowControllerNodeId);
            stmt.setString(3, workflowDataManagementNodeId);
            stmt.setInt(4, 0);
            stmt.executeUpdate();
            id = DerbyMetaDataBackendOperationsImpl.getGeneratedKey(stmt);
        }
        return id;
    }

    public void addWorkflowFileToWorkflowRun(Long workflowRunId, String wfFileReference, Connection connection, boolean isRetry) throws SQLException {
        String sql = " UPDATE APP.WORKFLOW_RUN SET WORKFLOW_FILE_REFERENCE =  ?  WHERE WORKFLOW_RUN_ID =  ? ";
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setString(1, wfFileReference);
            stmt.setLong(2, workflowRunId);
            stmt.execute();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void addProperties(String propertiesTableName, Long relatedId, Map<String, String> properties, Connection connection, boolean isRetry) throws SQLException {
        String idColumnName;
        switch (propertiesTableName) {
            case "COMPONENT_INSTANCE_PROPERTIES": {
                idColumnName = "COMPONENT_INSTANCE_ID";
                break;
            }
            case "ENDPOINT_INSTANCE_PROPERTIES": {
                idColumnName = "ENDPOINT_INSTANCE_ID";
                break;
            }
            case "COMPONENT_RUN_PROPERTIES": {
                idColumnName = "COMPONENT_RUN_ID";
                break;
            }
            default: {
                idColumnName = "WORKFLOW_RUN_ID";
            }
        }
        String sql = StringUtils.format((String)(" INSERT INTO APP.%s(" + idColumnName + COMMA + "KEY_" + COMMA + "VALUE" + ")" + VALUES + PLACEHOLDER_THREE_VALUES), (Object[])new Object[]{propertiesTableName});
        Throwable throwable = null;
        Object var10_11 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            for (String key : properties.keySet()) {
                stmt.setLong(1, relatedId);
                stmt.setString(2, key);
                stmt.setString(3, properties.get(key));
                stmt.execute();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Map<String, Long> addComponentInstances(Long workflowRunId, Collection<ComponentInstance> componentInstances, Connection connection, boolean isRetry) throws SQLException {
        HashMap<String, Long> result = new HashMap<String, Long>();
        String sql = " INSERT INTO APP.COMPONENT_INSTANCE(WORKFLOW_RUN_ID , COMPONENT_ID , COMPONENT_INSTANCE_NAME) VALUES (?,?,?)";
        Throwable throwable = null;
        Object var8_9 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql, 1);){
            for (ComponentInstance ci : componentInstances) {
                stmt.setLong(1, workflowRunId);
                stmt.setString(2, ci.getComponentID());
                stmt.setString(3, ci.getComponentInstanceName());
                stmt.execute();
                ResultSet rs = stmt.getGeneratedKeys();
                if (rs == null || !rs.next()) continue;
                result.put(ci.getComponentExecutionID(), rs.getLong(1));
                rs.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    private static Long getGeneratedKey(PreparedStatement stmt) throws SQLException {
        ResultSet rs = stmt.getGeneratedKeys();
        Long id = null;
        if (rs != null && rs.next()) {
            id = rs.getLong(1);
            rs.close();
        }
        return id;
    }

    public Long addTimelineInterval(Long workflowRunId, TimelineIntervalType intervalType, long starttime, Long relatedComponentId, Connection connection, boolean isRetry) throws SQLException {
        Long id;
        String sql = " INSERT INTO APP.TIMELINE_INTERVAL(WORKFLOW_RUN_ID , TYPE , STARTTIME , COMPONENT_RUN_ID) VALUES (?,?,?,?)";
        Throwable throwable = null;
        Object var11_10 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql, 1);){
            stmt.setLong(1, workflowRunId);
            stmt.setString(2, intervalType.toString());
            stmt.setTimestamp(3, new Timestamp(starttime));
            if (relatedComponentId != null) {
                stmt.setLong(4, relatedComponentId);
            } else {
                stmt.setNull(4, -5);
            }
            stmt.executeUpdate();
            id = DerbyMetaDataBackendOperationsImpl.getGeneratedKey(stmt);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return id;
    }

    public Long addComponentRun(Long componentInstanceId, String nodeId, Integer count, Long starttime, Connection connection, boolean isRetry) throws SQLException {
        Long id;
        String sql = " INSERT INTO APP.COMPONENT_RUN(COMPONENT_INSTANCE_ID , NODE_ID , COUNTER , REFERENCES_DELETED) VALUES (?,?,?,?)";
        Throwable throwable = null;
        Object var10_10 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql, 1);){
            stmt.setLong(1, componentInstanceId);
            stmt.setString(2, nodeId);
            stmt.setInt(3, count);
            stmt.setBoolean(4, false);
            stmt.executeUpdate();
            id = DerbyMetaDataBackendOperationsImpl.getGeneratedKey(stmt);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return id;
    }

    public Long addEndpointDatum(Long componentRunId, Long typedDatumId, Long endpointInstanceId, Integer count, Connection connection, boolean isRetry) throws SQLException {
        Long endpointDataId;
        String endpointSql = " INSERT INTO APP.ENDPOINT_DATA(COMPONENT_RUN_ID , TYPED_DATUM_ID , ENDPOINT_INSTANCE_ID , COUNTER) VALUES (?,?,?,?)";
        Throwable throwable = null;
        Object var10_10 = null;
        try (PreparedStatement stmt = connection.prepareStatement(endpointSql, 1);){
            stmt.setLong(1, componentRunId);
            stmt.setLong(2, typedDatumId);
            stmt.setLong(3, endpointInstanceId);
            stmt.setInt(4, count);
            stmt.executeUpdate();
            endpointDataId = DerbyMetaDataBackendOperationsImpl.getGeneratedKey(stmt);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return endpointDataId;
    }

    public Long addTypedDatum(String dataType, String value, Connection connection, boolean isRetry) throws SQLException {
        Long id;
        String sql = " INSERT INTO APP.TYPED_DATUM(TYPE , %s) VALUES (?,?)";
        String valueColumn = value.length() <= 32672 ? "VALUE" : "BIG_VALUE";
        Throwable throwable = null;
        Object var9_9 = null;
        try (PreparedStatement stmt = connection.prepareStatement(StringUtils.format((String)sql, (Object[])new Object[]{valueColumn}), 1);){
            stmt.setString(1, dataType);
            stmt.setString(2, value);
            stmt.executeUpdate();
            id = DerbyMetaDataBackendOperationsImpl.getGeneratedKey(stmt);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return id;
    }

    public Set<Long> addBinaryReferences(Set<BinaryReference> binaryReferences, Connection connection, boolean isRetry) throws SQLException {
        String sql = " INSERT INTO APP.BINARY_REFERENCE(BINARY_REFERENCE_KEY , COMPRESSION , REVISION) VALUES (?,?,?)";
        HashSet<Long> ids = new HashSet<Long>();
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql, 1);){
            for (BinaryReference br : binaryReferences) {
                stmt.setString(1, br.getBinaryReferenceKey());
                stmt.setString(2, br.getCompression().toString());
                stmt.setString(3, br.getRevision());
                stmt.executeUpdate();
                ids.add(DerbyMetaDataBackendOperationsImpl.getGeneratedKey(stmt));
                stmt.clearParameters();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return ids;
    }

    public Long addDataReference(String dataReferenceKey, String nodeIdentifier, Connection connection, boolean isRetry) throws SQLException {
        Long id;
        String sql = " INSERT INTO APP.DATA_REFERENCE(DATA_REFERENCE_KEY , NODE_ID) VALUES (?,?)";
        Throwable throwable = null;
        Object var8_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql, 1);){
            stmt.setString(1, dataReferenceKey);
            stmt.setString(2, nodeIdentifier);
            stmt.executeUpdate();
            id = DerbyMetaDataBackendOperationsImpl.getGeneratedKey(stmt);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return id;
    }

    public Long addBinaryReference(BinaryReference binaryReference, Connection connection, boolean isRetry) throws SQLException {
        Long id;
        String sql = " INSERT INTO APP.BINARY_REFERENCE(BINARY_REFERENCE_KEY , COMPRESSION , REVISION) VALUES (?,?,?)";
        Throwable throwable = null;
        Object var7_7 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql, 1);){
            stmt.setString(1, binaryReference.getBinaryReferenceKey());
            stmt.setString(2, binaryReference.getCompression().toString());
            stmt.setString(3, binaryReference.getRevision());
            stmt.executeUpdate();
            id = DerbyMetaDataBackendOperationsImpl.getGeneratedKey(stmt);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return id;
    }

    public DataReference getDataReference(String dataReferenceKey, Connection connection, boolean isRetry) throws SQLException {
        String sql = " SELECT DATA_REFERENCE_ID , NODE_ID FROM APP.DATA_REFERENCE WHERE DATA_REFERENCE_KEY =  ? ";
        Long dataRefId = null;
        String dataRefNodeId = null;
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql, 1003, 1007);){
            stmt.setString(1, dataReferenceKey);
            ResultSet rs = stmt.executeQuery();
            if (rs != null && rs.next()) {
                dataRefId = rs.getLong("DATA_REFERENCE_ID");
                dataRefNodeId = rs.getString("NODE_ID").trim();
                rs.close();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        if (dataRefId == null) {
            return null;
        }
        sql = " SELECT BINARY_REFERENCE.BINARY_REFERENCE_KEY , BINARY_REFERENCE.COMPRESSION , BINARY_REFERENCE.REVISION FROM APP.REL_DR_BR INNER JOIN APP.BINARY_REFERENCE ON BINARY_REFERENCE.BINARY_REFERENCE_ID = REL_DR_BR.BINARY_REFERENCE_ID WHERE REL_DR_BR.DATA_REFERENCE_ID =  ? ";
        DataReference dataRef = null;
        throwable2 = null;
        Object var9_12 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql, 1003, 1007);){
            stmt.setLong(1, dataRefId);
            ResultSet rs = stmt.executeQuery();
            HashSet<BinaryReference> binaryReferences = new HashSet<BinaryReference>();
            if (rs != null) {
                while (rs.next()) {
                    binaryReferences.add(new BinaryReference(rs.getString("BINARY_REFERENCE_KEY").trim(), CompressionFormat.valueOf((String)rs.getString("COMPRESSION")), rs.getString("REVISION")));
                }
                dataRef = new DataReference(dataReferenceKey, NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)dataRefNodeId), binaryReferences);
                rs.close();
            }
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        return dataRef;
    }

    public Map<Long, Set<String>> getDataReferenceBinaryKeys(Long workflowRunId, Connection connection, boolean isRetry) throws SQLException {
        String sqlBinaryRefs = " SELECT V_WORKFLOWRUN_DATAREFERENCE.DATA_REFERENCE_ID , BINARY_REFERENCE.BINARY_REFERENCE_KEY FROM V_WORKFLOWRUN_DATAREFERENCE , APP.BINARY_REFERENCE , REL_DR_BR WHERE BINARY_REFERENCE.BINARY_REFERENCE_ID = REL_DR_BR.BINARY_REFERENCE_ID AND REL_DR_BR.DATA_REFERENCE_ID = V_WORKFLOWRUN_DATAREFERENCE.DATA_REFERENCE_ID AND V_WORKFLOWRUN_DATAREFERENCE.WORKFLOW_RUN_ID =  ?  ORDER BY DATA_REFERENCE_ID";
        HashMap<Long, Set<String>> keys = new HashMap<Long, Set<String>>();
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmtBinaryRefs = connection.prepareStatement(sqlBinaryRefs, 1003, 1007);){
            stmtBinaryRefs.setLong(1, workflowRunId);
            ResultSet rs = stmtBinaryRefs.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    if (keys.get(rs.getLong("DATA_REFERENCE_ID")) == null) {
                        keys.put(rs.getLong("DATA_REFERENCE_ID"), new HashSet());
                    }
                    ((Set)keys.get(rs.getLong("DATA_REFERENCE_ID"))).add(rs.getString("BINARY_REFERENCE_KEY").trim());
                }
                rs.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return keys;
    }

    public void addDataReferenceWorkflowRunRelation(Long dataReferenceId, Long workflowRunId, Connection connection, boolean isRetry) throws SQLException {
        String sql = " INSERT INTO APP.REL_WFR_DR(DATA_REFERENCE_ID , WORKFLOW_RUN_ID) VALUES (?,?)";
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setLong(1, dataReferenceId);
            stmt.setLong(2, workflowRunId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void addDataReferenceComponentInstanceRelation(Long dataReferenceId, Long componentInstanceId, Connection connection, boolean isRetry) throws SQLException {
        String sql = " INSERT INTO APP.REL_CI_DR(DATA_REFERENCE_ID , COMPONENT_INSTANCE_ID) VALUES (?,?)";
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setLong(1, dataReferenceId);
            stmt.setLong(2, componentInstanceId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void addDataReferenceComponentRunRelation(Long dataReferenceId, Long componentRunId, Connection connection, boolean isRetry) throws SQLException {
        String sql = " INSERT INTO APP.REL_CR_DR(DATA_REFERENCE_ID , COMPONENT_RUN_ID) VALUES (?,?)";
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setLong(1, dataReferenceId);
            stmt.setLong(2, componentRunId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void addDataBinaryReferenceRelations(Long dataReferenceId, Set<Long> binaryReferenceIds, Connection connection, boolean isRetry) throws SQLException {
        String sql = " INSERT INTO APP.REL_DR_BR(DATA_REFERENCE_ID , BINARY_REFERENCE_ID) VALUES (?,?)";
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            for (Long id : binaryReferenceIds) {
                stmt.setLong(1, dataReferenceId);
                stmt.setLong(2, id);
                stmt.executeUpdate();
                stmt.clearParameters();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void markDeletion(Long workflowRunId, Integer type, Connection connection, boolean isRetry) throws SQLException {
        String sql = " UPDATE APP.WORKFLOW_RUN SET TO_BE_DELETED =  ?  WHERE WORKFLOW_RUN_ID =  ? ";
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setInt(1, type);
            stmt.setLong(2, workflowRunId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void markDataReferencesDeleted(Long workflowRunId, Connection connection, boolean isRetry) throws SQLException {
        Object stmtWorkflowRunProperty;
        String sqlProperty = " INSERT INTO APP.WORKFLOW_RUN_PROPERTIES(WORKFLOW_RUN_ID , KEY_ , VALUE) VALUES (?,?,?)";
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            stmtWorkflowRunProperty = connection.prepareStatement(sqlProperty);
            try {
                stmtWorkflowRunProperty.setLong(1, workflowRunId);
                stmtWorkflowRunProperty.setString(2, "FILES_DELETED");
                stmtWorkflowRunProperty.setString(3, "DELETED_MANUALLY");
                try {
                    stmtWorkflowRunProperty.executeUpdate();
                }
                catch (SQLException e) {
                    if (!"23503".equals(e.getSQLState())) {
                        throw e;
                    }
                }
            }
            finally {
                if (stmtWorkflowRunProperty != null) {
                    stmtWorkflowRunProperty.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String sqlComponentRunIds = " SELECT COMPONENT_RUN_ID FROM V_WORKFLOW_COMPONENTRUN WHERE WORKFLOW_RUN_ID =  ? ";
        ArrayList<Long> crIds = new ArrayList<Long>();
        stmtWorkflowRunProperty = null;
        Throwable throwable3 = null;
        try (PreparedStatement stmtComponentRunIds = connection.prepareStatement(sqlComponentRunIds, 1003, 1007);){
            stmtComponentRunIds.setLong(1, workflowRunId);
            ResultSet rs = stmtComponentRunIds.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    crIds.add(rs.getLong("COMPONENT_RUN_ID"));
                }
                rs.close();
            }
        }
        catch (Throwable throwable4) {
            if (stmtWorkflowRunProperty == null) {
                stmtWorkflowRunProperty = throwable4;
            } else if (stmtWorkflowRunProperty != throwable4) {
                ((Throwable)stmtWorkflowRunProperty).addSuppressed(throwable4);
            }
            throw stmtWorkflowRunProperty;
        }
        if (!crIds.isEmpty()) {
            String sql = " UPDATE APP.COMPONENT_RUN SET REFERENCES_DELETED =  ?  WHERE COMPONENT_RUN_ID =  ? ";
            throwable3 = null;
            Object var9_15 = null;
            try (PreparedStatement stmt = connection.prepareStatement(sql);){
                for (Long id : crIds) {
                    stmt.setBoolean(1, true);
                    stmt.setLong(2, id);
                    stmt.executeUpdate();
                }
            }
            catch (Throwable throwable5) {
                if (throwable3 == null) {
                    throwable3 = throwable5;
                } else if (throwable3 != throwable5) {
                    throwable3.addSuppressed(throwable5);
                }
                throw throwable3;
            }
        }
    }

    public boolean isWorkflowFinished(Long workflowRunId, Connection connection, boolean isRetry) throws SQLException {
        String sql = " SELECT FINAL_STATE FROM APP.WORKFLOW_RUN WHERE WORKFLOW_RUN_ID =  ? ";
        boolean finished = false;
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql, 1003, 1007);){
            stmt.setLong(1, workflowRunId);
            ResultSet rs = stmt.executeQuery();
            if (rs != null && rs.next()) {
                finished = rs.getString("FINAL_STATE") != null;
                rs.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return finished;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteTypedDatums(Long workflowRunId, Connection connection, boolean isRetry) throws SQLException {
        String sql = " SELECT TYPED_DATUM_ID FROM APP.V_WORKFLOWRUN_TYPEDDATUM WHERE WORKFLOW_RUN_ID =  ? ";
        HashSet<Long> typedDatumIds = new HashSet<Long>();
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql, 1003, 1007);){
            stmt.setLong(1, workflowRunId);
            ResultSet rs = stmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    typedDatumIds.add(rs.getLong("TYPED_DATUM_ID"));
                }
                rs.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            } else {
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String sqlEndpointData = " DELETE FROM APP.ENDPOINT_DATA WHERE TYPED_DATUM_ID =  ? ";
        String sqlTypedDatum = " DELETE FROM APP.TYPED_DATUM WHERE TYPED_DATUM_ID =  ? ";
        Throwable throwable3 = null;
        Object var9_12 = null;
        try {
            PreparedStatement stmtEndpointData = connection.prepareStatement(sqlEndpointData, 1003, 1007);
            try {
                try (PreparedStatement stmtTypedDatum = connection.prepareStatement(sqlTypedDatum, 1003, 1007);){
                    for (Long id : typedDatumIds) {
                        stmtEndpointData.setLong(1, id);
                        stmtTypedDatum.setLong(1, id);
                        stmtEndpointData.execute();
                        stmtTypedDatum.execute();
                    }
                }
                if (stmtEndpointData == null) return;
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                if (stmtEndpointData == null) throw throwable3;
                stmtEndpointData.close();
                throw throwable3;
            }
            stmtEndpointData.close();
            return;
        }
        catch (Throwable throwable5) {
            if (throwable3 == null) {
                throwable3 = throwable5;
                throw throwable3;
            } else {
                if (throwable3 == throwable5) throw throwable3;
                throwable3.addSuppressed(throwable5);
            }
            throw throwable3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean deleteDataReferences(Map<Long, Set<String>> dataReferenceKeys, Connection connection, boolean isRetry) throws SQLException {
        if (dataReferenceKeys.isEmpty()) {
            return true;
        }
        boolean result = true;
        String sqlRelBinaryDataRef = " DELETE FROM APP.REL_DR_BR WHERE DATA_REFERENCE_ID =  ? ";
        String sqlRelCompRunDataRef = " DELETE FROM APP.REL_CR_DR WHERE DATA_REFERENCE_ID =  ? ";
        String sqlRelCompInstanceDataRef = " DELETE FROM APP.REL_CI_DR WHERE DATA_REFERENCE_ID =  ? ";
        String sqlRelWorkflowRunDataRef = " DELETE FROM APP.REL_WFR_DR WHERE DATA_REFERENCE_ID =  ? ";
        String sqlBinaryRef = " DELETE FROM APP.BINARY_REFERENCE WHERE BINARY_REFERENCE_KEY =  ? ";
        String sqlDataRef = " DELETE FROM APP.DATA_REFERENCE WHERE DATA_REFERENCE_ID =  ? ";
        Throwable throwable = null;
        Object var12_13 = null;
        try {
            PreparedStatement stmtRelBinaryDataRef = connection.prepareStatement(sqlRelBinaryDataRef, 1003, 1007);
            try {
                block40: {
                    PreparedStatement stmtRelCompRunDataRef = connection.prepareStatement(sqlRelCompRunDataRef, 1003, 1007);
                    try {
                        block39: {
                            PreparedStatement stmtRelCompInstanceDataRef = connection.prepareStatement(sqlRelCompInstanceDataRef, 1003, 1007);
                            try {
                                block38: {
                                    PreparedStatement stmtRelWorkflowRunDataRef = connection.prepareStatement(sqlRelWorkflowRunDataRef, 1003, 1007);
                                    try {
                                        block37: {
                                            PreparedStatement stmtBinaryRef = connection.prepareStatement(sqlBinaryRef, 1003, 1007);
                                            try {
                                                try (PreparedStatement stmtDataRef = connection.prepareStatement(sqlDataRef, 1003, 1007);){
                                                    for (Long id : dataReferenceKeys.keySet()) {
                                                        stmtRelBinaryDataRef.setLong(1, id);
                                                        result &= !stmtRelBinaryDataRef.execute();
                                                        stmtRelCompRunDataRef.setLong(1, id);
                                                        result &= !stmtRelCompRunDataRef.execute();
                                                        stmtRelCompInstanceDataRef.setLong(1, id);
                                                        result &= !stmtRelCompInstanceDataRef.execute();
                                                        stmtRelWorkflowRunDataRef.setLong(1, id);
                                                        result &= !stmtRelWorkflowRunDataRef.execute();
                                                        Iterator<String> iterator = dataReferenceKeys.get(id).iterator();
                                                        while (true) {
                                                            if (!iterator.hasNext()) {
                                                                stmtDataRef.setLong(1, id);
                                                            }
                                                            String key = iterator.next();
                                                            stmtBinaryRef.setString(1, key);
                                                            result &= !stmtBinaryRef.execute();
                                                        }
                                                        result &= !stmtDataRef.execute();
                                                    }
                                                }
                                                if (stmtBinaryRef == null) break block37;
                                            }
                                            catch (Throwable throwable2) {
                                                if (throwable == null) {
                                                    throwable = throwable2;
                                                } else if (throwable != throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                                if (stmtBinaryRef == null) throw throwable;
                                                stmtBinaryRef.close();
                                                throw throwable;
                                            }
                                            stmtBinaryRef.close();
                                        }
                                        if (stmtRelWorkflowRunDataRef == null) break block38;
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable == null) {
                                            throwable = throwable3;
                                        } else if (throwable != throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        if (stmtRelWorkflowRunDataRef == null) throw throwable;
                                        stmtRelWorkflowRunDataRef.close();
                                        throw throwable;
                                    }
                                    stmtRelWorkflowRunDataRef.close();
                                }
                                if (stmtRelCompInstanceDataRef == null) break block39;
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                if (stmtRelCompInstanceDataRef == null) throw throwable;
                                stmtRelCompInstanceDataRef.close();
                                throw throwable;
                            }
                            stmtRelCompInstanceDataRef.close();
                        }
                        if (stmtRelCompRunDataRef == null) break block40;
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        if (stmtRelCompRunDataRef == null) throw throwable;
                        stmtRelCompRunDataRef.close();
                        throw throwable;
                    }
                    stmtRelCompRunDataRef.close();
                }
                if (stmtRelBinaryDataRef == null) return result;
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                if (stmtRelBinaryDataRef == null) throw throwable;
                stmtRelBinaryDataRef.close();
                throw throwable;
            }
            stmtRelBinaryDataRef.close();
            return result;
        }
        catch (Throwable throwable7) {
            if (throwable == null) {
                throwable = throwable7;
                throw throwable;
            }
            if (throwable == throwable7) throw throwable;
            throwable.addSuppressed(throwable7);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean deleteWorkflowRunContent(Long workflowRunId, Connection connection, boolean isRetry) throws SQLException {
        int affectedLines;
        block55: {
            String sqlTimelineInt = " DELETE FROM APP.TIMELINE_INTERVAL WHERE WORKFLOW_RUN_ID =  ? ";
            String sqlCompInstIds = " SELECT COMPONENT_INSTANCE_ID FROM APP.COMPONENT_INSTANCE WHERE WORKFLOW_RUN_ID =  ? ";
            String sqlCompRunIds = " SELECT COMPONENT_RUN.COMPONENT_RUN_ID FROM APP.COMPONENT_RUN , APP.COMPONENT_INSTANCE WHERE COMPONENT_RUN.COMPONENT_INSTANCE_ID = COMPONENT_INSTANCE.COMPONENT_INSTANCE_ID AND COMPONENT_INSTANCE.WORKFLOW_RUN_ID =  ? ";
            String sqlcompRunProp = " DELETE FROM APP.COMPONENT_RUN_PROPERTIES WHERE COMPONENT_RUN_ID IN (%s)";
            String sqlcompInstProp = " DELETE FROM APP.COMPONENT_INSTANCE_PROPERTIES WHERE COMPONENT_INSTANCE_ID IN (%s)";
            String sqlEndpointInstProp = " DELETE FROM APP.ENDPOINT_INSTANCE_PROPERTIES WHERE ENDPOINT_INSTANCE_ID IN (%s)";
            String sqlEndInstIds = " SELECT ENDPOINT_INSTANCE_ID FROM ENDPOINT_INSTANCE , COMPONENT_INSTANCE WHERE ENDPOINT_INSTANCE.COMPONENT_INSTANCE_ID = COMPONENT_INSTANCE.COMPONENT_INSTANCE_ID AND COMPONENT_INSTANCE.WORKFLOW_RUN_ID =  ? ";
            String sqlEndpointInst = " DELETE FROM APP.ENDPOINT_INSTANCE WHERE ENDPOINT_INSTANCE_ID IN (%s)";
            String sqlCompRun = " DELETE FROM APP.COMPONENT_RUN WHERE COMPONENT_INSTANCE_ID IN (%s)";
            String sqlCompInst = " DELETE FROM APP.COMPONENT_INSTANCE WHERE WORKFLOW_RUN_ID =  ? ";
            String sqlWorkflowRunProp = " DELETE FROM APP.WORKFLOW_RUN_PROPERTIES WHERE WORKFLOW_RUN_ID =  ? ";
            String sqlWorkflowRun = " DELETE FROM APP.WORKFLOW_RUN WHERE WORKFLOW_RUN_ID =  ? ";
            Throwable throwable = null;
            Object var18_18 = null;
            try {
                PreparedStatement stmtCompRunProp = connection.prepareStatement(StringUtils.format((String)sqlcompRunProp, (Object[])new Object[]{StringUtils.format((String)sqlCompRunIds, (Object[])new Object[]{sqlCompInstIds})}), 1003, 1007);
                try {
                    block54: {
                        PreparedStatement stmtCompInstProp = connection.prepareStatement(StringUtils.format((String)sqlcompInstProp, (Object[])new Object[]{sqlCompInstIds}), 1003, 1007);
                        try {
                            block53: {
                                PreparedStatement stmtEndpointInstProp = connection.prepareStatement(StringUtils.format((String)sqlEndpointInstProp, (Object[])new Object[]{sqlEndInstIds}), 1003, 1007);
                                try {
                                    block52: {
                                        PreparedStatement stmtEndpointInst = connection.prepareStatement(StringUtils.format((String)sqlEndpointInst, (Object[])new Object[]{sqlEndInstIds}), 1003, 1007);
                                        try {
                                            block51: {
                                                PreparedStatement stmtCompRun = connection.prepareStatement(StringUtils.format((String)sqlCompRun, (Object[])new Object[]{sqlCompInstIds}), 1003, 1007);
                                                try {
                                                    block50: {
                                                        PreparedStatement stmtCompInst = connection.prepareStatement(sqlCompInst, 1003, 1007);
                                                        try {
                                                            block49: {
                                                                PreparedStatement stmtWorkflowRunProp = connection.prepareStatement(sqlWorkflowRunProp, 1003, 1007);
                                                                try {
                                                                    block48: {
                                                                        PreparedStatement stmtWorkflowRun = connection.prepareStatement(sqlWorkflowRun, 1003, 1007);
                                                                        try {
                                                                            try (PreparedStatement stmtTimelineInt = connection.prepareStatement(sqlTimelineInt, 1003, 1007);){
                                                                                stmtTimelineInt.setLong(1, workflowRunId);
                                                                                stmtTimelineInt.execute();
                                                                                stmtCompRunProp.setLong(1, workflowRunId);
                                                                                stmtCompRunProp.execute();
                                                                                stmtCompInstProp.setLong(1, workflowRunId);
                                                                                stmtCompInstProp.execute();
                                                                                stmtEndpointInstProp.setLong(1, workflowRunId);
                                                                                stmtEndpointInstProp.execute();
                                                                                stmtEndpointInst.setLong(1, workflowRunId);
                                                                                stmtEndpointInst.execute();
                                                                                stmtCompRun.setLong(1, workflowRunId);
                                                                                stmtCompRun.execute();
                                                                                stmtCompInst.setLong(1, workflowRunId);
                                                                                stmtCompInst.execute();
                                                                                stmtWorkflowRunProp.setLong(1, workflowRunId);
                                                                                stmtWorkflowRunProp.execute();
                                                                                stmtWorkflowRun.setLong(1, workflowRunId);
                                                                                affectedLines = stmtWorkflowRun.executeUpdate();
                                                                            }
                                                                            if (stmtWorkflowRun == null) break block48;
                                                                        }
                                                                        catch (Throwable throwable2) {
                                                                            if (throwable == null) {
                                                                                throwable = throwable2;
                                                                            } else if (throwable != throwable2) {
                                                                                throwable.addSuppressed(throwable2);
                                                                            }
                                                                            if (stmtWorkflowRun == null) throw throwable;
                                                                            stmtWorkflowRun.close();
                                                                            throw throwable;
                                                                        }
                                                                        stmtWorkflowRun.close();
                                                                    }
                                                                    if (stmtWorkflowRunProp == null) break block49;
                                                                }
                                                                catch (Throwable throwable3) {
                                                                    if (throwable == null) {
                                                                        throwable = throwable3;
                                                                    } else if (throwable != throwable3) {
                                                                        throwable.addSuppressed(throwable3);
                                                                    }
                                                                    if (stmtWorkflowRunProp == null) throw throwable;
                                                                    stmtWorkflowRunProp.close();
                                                                    throw throwable;
                                                                }
                                                                stmtWorkflowRunProp.close();
                                                            }
                                                            if (stmtCompInst == null) break block50;
                                                        }
                                                        catch (Throwable throwable4) {
                                                            if (throwable == null) {
                                                                throwable = throwable4;
                                                            } else if (throwable != throwable4) {
                                                                throwable.addSuppressed(throwable4);
                                                            }
                                                            if (stmtCompInst == null) throw throwable;
                                                            stmtCompInst.close();
                                                            throw throwable;
                                                        }
                                                        stmtCompInst.close();
                                                    }
                                                    if (stmtCompRun == null) break block51;
                                                }
                                                catch (Throwable throwable5) {
                                                    if (throwable == null) {
                                                        throwable = throwable5;
                                                    } else if (throwable != throwable5) {
                                                        throwable.addSuppressed(throwable5);
                                                    }
                                                    if (stmtCompRun == null) throw throwable;
                                                    stmtCompRun.close();
                                                    throw throwable;
                                                }
                                                stmtCompRun.close();
                                            }
                                            if (stmtEndpointInst == null) break block52;
                                        }
                                        catch (Throwable throwable6) {
                                            if (throwable == null) {
                                                throwable = throwable6;
                                            } else if (throwable != throwable6) {
                                                throwable.addSuppressed(throwable6);
                                            }
                                            if (stmtEndpointInst == null) throw throwable;
                                            stmtEndpointInst.close();
                                            throw throwable;
                                        }
                                        stmtEndpointInst.close();
                                    }
                                    if (stmtEndpointInstProp == null) break block53;
                                }
                                catch (Throwable throwable7) {
                                    if (throwable == null) {
                                        throwable = throwable7;
                                    } else if (throwable != throwable7) {
                                        throwable.addSuppressed(throwable7);
                                    }
                                    if (stmtEndpointInstProp == null) throw throwable;
                                    stmtEndpointInstProp.close();
                                    throw throwable;
                                }
                                stmtEndpointInstProp.close();
                            }
                            if (stmtCompInstProp == null) break block54;
                        }
                        catch (Throwable throwable8) {
                            if (throwable == null) {
                                throwable = throwable8;
                            } else if (throwable != throwable8) {
                                throwable.addSuppressed(throwable8);
                            }
                            if (stmtCompInstProp == null) throw throwable;
                            stmtCompInstProp.close();
                            throw throwable;
                        }
                        stmtCompInstProp.close();
                    }
                    if (stmtCompRunProp == null) break block55;
                }
                catch (Throwable throwable9) {
                    if (throwable == null) {
                        throwable = throwable9;
                    } else if (throwable != throwable9) {
                        throwable.addSuppressed(throwable9);
                    }
                    if (stmtCompRunProp == null) throw throwable;
                    stmtCompRunProp.close();
                    throw throwable;
                }
                stmtCompRunProp.close();
            }
            catch (Throwable throwable10) {
                if (throwable == null) {
                    throwable = throwable10;
                    throw throwable;
                }
                if (throwable == throwable10) throw throwable;
                throwable.addSuppressed(throwable10);
                throw throwable;
            }
        }
        if (affectedLines != 1) return false;
        return true;
    }

    public Long addDataReference(DataReference dataReference, Connection connection, boolean isRetry) throws SQLException {
        Long dataReferenceId = this.addDataReference(dataReference.getDataReferenceKey(), DataManagementIdMapping.mapLogicalNodeIdToDbString((LogicalNodeId)dataReference.getStorageNodeId().convertToDefaultLogicalNodeId()), connection, isRetry);
        Set<Long> binaryReferenceIds = this.addBinaryReferences(dataReference.getBinaryReferences(), connection, isRetry);
        this.addDataBinaryReferenceRelations(dataReferenceId, binaryReferenceIds, connection, isRetry);
        return dataReferenceId;
    }

    public Map<String, String> getProperties(String tableName, Long relatedId, Connection connection, boolean isRetry) throws SQLException {
        String relatedIdColumn;
        switch (tableName) {
            case "COMPONENT_RUN_PROPERTIES": {
                relatedIdColumn = "COMPONENT_RUN_ID";
                break;
            }
            case "WORKFLOW_RUN_PROPERTIES": {
                relatedIdColumn = "WORKFLOW_RUN_ID";
                break;
            }
            case "COMPONENT_INSTANCE_PROPERTIES": {
                relatedIdColumn = "COMPONENT_INSTANCE_ID";
                break;
            }
            case "ENDPOINT_INSTANCE_PROPERTIES": {
                relatedIdColumn = "ENDPOINT_INSTANCE_ID";
                break;
            }
            default: {
                relatedIdColumn = null;
            }
        }
        String sql = StringUtils.format((String)" SELECT KEY_ , VALUE FROM APP.%s WHERE %s =  ? ", (Object[])new Object[]{tableName, relatedIdColumn});
        HashMap<String, String> results = new HashMap<String, String>();
        Throwable throwable = null;
        Object var10_11 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql, 1003, 1007);){
            stmt.setLong(1, relatedId);
            ResultSet rs = stmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    results.put(rs.getString("KEY_"), rs.getString("VALUE"));
                }
                rs.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return results;
    }

    public List<ComponentRunInterval> getComponentRunIntervals(Long workflowRunId, Connection connection, boolean isRetry) throws SQLException {
        String sql = " SELECT STARTTIME , ENDTIME , TYPE , COMPONENT_ID , COMPONENT_INSTANCE_NAME FROM APP.V_COMPONENT_TIMELINE_INTERVALS WHERE WORKFLOW_RUN_ID =  ? ";
        ArrayList<ComponentRunInterval> results = new ArrayList<ComponentRunInterval>();
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql, 1003, 1007);){
            stmt.setLong(1, workflowRunId);
            ResultSet rs = stmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    Long endtime = null;
                    if (rs.getTimestamp("ENDTIME") != null) {
                        endtime = rs.getTimestamp("ENDTIME").getTime();
                    }
                    results.add(new ComponentRunInterval(rs.getString("COMPONENT_ID"), rs.getString("COMPONENT_INSTANCE_NAME"), TimelineIntervalType.valueOf((String)rs.getString("TYPE")), Long.valueOf(rs.getTimestamp("STARTTIME").getTime()), endtime));
                }
                rs.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return results;
    }

    public TimelineInterval getWorkflowInterval(Long workflowRunId, Connection connection, boolean isRetry) throws SQLException {
        String sql = " SELECT STARTTIME , ENDTIME FROM APP.TIMELINE_INTERVAL WHERE WORKFLOW_RUN_ID =  ?  AND TYPE =  ? ";
        TimelineInterval ti = null;
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql, 1003, 1007);){
            stmt.setLong(1, workflowRunId);
            stmt.setString(2, TimelineIntervalType.WORKFLOW_RUN.toString());
            ResultSet rs = stmt.executeQuery();
            if (rs != null && rs.next()) {
                Long endtime = null;
                if (rs.getTimestamp("ENDTIME") != null) {
                    endtime = rs.getTimestamp("ENDTIME").getTime();
                }
                ti = new TimelineInterval(TimelineIntervalType.WORKFLOW_RUN, Long.valueOf(rs.getTimestamp("STARTTIME").getTime()), endtime);
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return ti;
    }

    public String getWorkflowRunName(Long workflowRunId, Connection connection, boolean isRetry) throws SQLException {
        String sql = " SELECT NAME FROM APP.WORKFLOW_RUN WHERE WORKFLOW_RUN_ID =  ? ";
        String name = null;
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql, 1003, 1007);){
            stmt.setLong(1, workflowRunId);
            ResultSet rs = stmt.executeQuery();
            if (rs != null && rs.next()) {
                name = rs.getString("NAME");
                rs.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return name;
    }

    public void setTimelineIntervalFinished(Long timelineIntervalId, long endtime, Connection connection, boolean isRetry) throws SQLException {
        String sql = " UPDATE APP.TIMELINE_INTERVAL SET ENDTIME =  ?  WHERE TIMELINE_INTERVAL_ID =  ? ";
        Throwable throwable = null;
        Object var8_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setTimestamp(1, new Timestamp(endtime));
            stmt.setLong(2, timelineIntervalId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, Long> addEndpointInstances(Long componentInstanceId, Collection<EndpointInstance> endpointInstances, Connection connection, boolean isRetry) throws SQLException {
        HashMap<String, Long> result = new HashMap<String, Long>();
        String sql = " INSERT INTO APP.ENDPOINT_INSTANCE(COMPONENT_INSTANCE_ID , NAME , TYPE) VALUES (?,?,?)";
        String sqlProperties = " INSERT INTO APP.ENDPOINT_INSTANCE_PROPERTIES(ENDPOINT_INSTANCE_ID , KEY_ , VALUE) VALUES (?,?,?)";
        Throwable throwable = null;
        Object var9_10 = null;
        try {
            PreparedStatement stmt = connection.prepareStatement(sql, 1);
            try {
                try (PreparedStatement stmtProperties = connection.prepareStatement(sqlProperties);){
                    for (EndpointInstance ei : endpointInstances) {
                        stmt.setLong(1, componentInstanceId);
                        stmt.setString(2, ei.getEndpointName());
                        stmt.setString(3, ei.getEndpointType().name());
                        stmt.execute();
                        ResultSet rs = stmt.getGeneratedKeys();
                        if (rs == null || !rs.next()) continue;
                        Long id = rs.getLong(1);
                        result.put(ei.getEndpointName(), id);
                        for (String key : ei.getMetaData().keySet()) {
                            stmtProperties.setLong(1, id);
                            stmtProperties.setString(2, key);
                            stmtProperties.setString(3, (String)ei.getMetaData().get(key));
                            stmtProperties.execute();
                        }
                        rs.close();
                    }
                }
                if (stmt == null) return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return result;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public Collection<ComponentRun> getComponentRuns(Long componentInstanceId, Connection connection, boolean isRetry) throws SQLException {
        Long endpointInstanceId22;
        Object rsEndpointProperties;
        HashMap endpointProperties = new HashMap();
        String sqlEndpointProperties = " SELECT *  FROM APP.V_ENDPOINT_INSTANCE_PROPERTIES WHERE ENDPOINT_INSTANCE_ID IN (%s)";
        String sqlEndpointInstanceId = " SELECT ENDPOINT_INSTANCE_ID FROM APP.ENDPOINT_INSTANCE WHERE COMPONENT_INSTANCE_ID =  ? ";
        Throwable throwable = null;
        Object var8_9 = null;
        try (PreparedStatement stmtEndpointProperties = connection.prepareStatement(StringUtils.format((String)sqlEndpointProperties, (Object[])new Object[]{sqlEndpointInstanceId}), 1003, 1007);){
            stmtEndpointProperties.setLong(1, componentInstanceId);
            rsEndpointProperties = stmtEndpointProperties.executeQuery();
            if (rsEndpointProperties != null) {
                while (rsEndpointProperties.next()) {
                    endpointInstanceId22 = rsEndpointProperties.getLong("ENDPOINT_INSTANCE_ID");
                    String key = rsEndpointProperties.getString("KEY_");
                    String value = rsEndpointProperties.getString("VALUE");
                    if (endpointProperties.get(endpointInstanceId22) != null) {
                        ((Map)endpointProperties.get(endpointInstanceId22)).put(key, value);
                        continue;
                    }
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(key, value);
                    endpointProperties.put(endpointInstanceId22, map);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        HashMap endpointData = new HashMap();
        String sqlEndpointData = " SELECT COMPONENT_INSTANCE.WORKFLOW_RUN_ID , ENDPOINT_DATA.COMPONENT_RUN_ID , ENDPOINT_DATA.COUNTER , ENDPOINT_INSTANCE.ENDPOINT_INSTANCE_ID , ENDPOINT_INSTANCE.NAME , ENDPOINT_INSTANCE.TYPE AS ENDPOINT_TYPE , TYPED_DATUM.TYPE AS DATUM_TYPE , TYPED_DATUM.VALUE , TYPED_DATUM.BIG_VALUE FROM COMPONENT_INSTANCE , COMPONENT_RUN , ENDPOINT_DATA , ENDPOINT_INSTANCE , TYPED_DATUM WHERE COMPONENT_INSTANCE.COMPONENT_INSTANCE_ID = COMPONENT_RUN.COMPONENT_INSTANCE_ID AND COMPONENT_RUN.COMPONENT_RUN_ID = ENDPOINT_DATA.COMPONENT_RUN_ID AND ENDPOINT_INSTANCE.ENDPOINT_INSTANCE_ID = ENDPOINT_DATA.ENDPOINT_INSTANCE_ID AND TYPED_DATUM.TYPED_DATUM_ID = ENDPOINT_DATA.TYPED_DATUM_ID AND ENDPOINT_DATA.COMPONENT_RUN_ID IN (%s)";
        String sqlComponentRunId = " SELECT COMPONENT_RUN_ID FROM APP.COMPONENT_RUN WHERE COMPONENT_INSTANCE_ID =  ? ";
        rsEndpointProperties = null;
        endpointInstanceId22 = null;
        try (PreparedStatement stmtEndpointData = connection.prepareStatement(StringUtils.format((String)sqlEndpointData, (Object[])new Object[]{sqlComponentRunId}), 1003, 1007);){
            stmtEndpointData.setLong(1, componentInstanceId);
            ResultSet rsEndpointData = stmtEndpointData.executeQuery();
            if (rsEndpointData != null) {
                while (rsEndpointData.next()) {
                    Long id;
                    String value = rsEndpointData.getString("VALUE");
                    if (value == null) {
                        value = rsEndpointData.getString("BIG_VALUE");
                    }
                    if (endpointData.get(id = Long.valueOf(rsEndpointData.getLong("COMPONENT_RUN_ID"))) == null) {
                        endpointData.put(id, new HashSet());
                    }
                    Long endpointInstanceId = rsEndpointData.getLong("ENDPOINT_INSTANCE_ID");
                    ((Set)endpointData.get(id)).add(new EndpointData(new EndpointInstance(rsEndpointData.getString("NAME"), EndpointType.valueOf((String)rsEndpointData.getString("ENDPOINT_TYPE")), (Map)endpointProperties.get(endpointInstanceId)), Integer.valueOf(rsEndpointData.getInt("COUNTER")), value));
                }
                rsEndpointData.close();
            }
        }
        catch (Throwable endpointInstanceId22) {
            if (rsEndpointProperties == null) {
                rsEndpointProperties = endpointInstanceId22;
            } else if (rsEndpointProperties != endpointInstanceId22) {
                ((Throwable)rsEndpointProperties).addSuppressed(endpointInstanceId22);
            }
            throw rsEndpointProperties;
        }
        String sql = " SELECT COMPONENT_RUN.COMPONENT_RUN_ID , COMPONENT_RUN.COMPONENT_INSTANCE_ID , COMPONENT_RUN.NODE_ID , COMPONENT_RUN.COUNTER , TIMELINE_INTERVAL.STARTTIME , TIMELINE_INTERVAL.ENDTIME , COMPONENT_RUN.HISTORY_DATA_ITEM , COMPONENT_RUN.COMPONENT_RUN_FINAL_STATE , COMPONENT_RUN.REFERENCES_DELETED FROM APP.COMPONENT_RUN , APP.TIMELINE_INTERVAL WHERE TIMELINE_INTERVAL.COMPONENT_RUN_ID = COMPONENT_RUN.COMPONENT_RUN_ID AND TIMELINE_INTERVAL.TYPE =  ?  AND COMPONENT_RUN.COMPONENT_INSTANCE_ID =  ?  ORDER BY TIMELINE_INTERVAL.STARTTIME DESC ";
        TreeSet<ComponentRun> results = new TreeSet<ComponentRun>();
        Throwable throwable3 = null;
        Object var13_18 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql, 1003, 1007);){
            stmt.setString(1, TimelineIntervalType.COMPONENT_RUN.toString());
            stmt.setLong(2, componentInstanceId);
            ResultSet rs = stmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    Long endtime = null;
                    if (rs.getTimestamp("ENDTIME") != null) {
                        endtime = rs.getTimestamp("ENDTIME").getTime();
                    }
                    FinalComponentRunState finalState = null;
                    if (rs.getString("COMPONENT_RUN_FINAL_STATE") != null) {
                        finalState = FinalComponentRunState.valueOf((String)rs.getString("COMPONENT_RUN_FINAL_STATE"));
                    }
                    Long componentRunId = rs.getLong("COMPONENT_RUN_ID");
                    ComponentRun cr = new ComponentRun(componentRunId, Long.valueOf(rs.getLong("COMPONENT_INSTANCE_ID")), rs.getString("NODE_ID").trim(), Integer.valueOf(rs.getInt("COUNTER")), Long.valueOf(rs.getTimestamp("STARTTIME").getTime()), endtime, rs.getString("HISTORY_DATA_ITEM"), Boolean.valueOf(rs.getBoolean("REFERENCES_DELETED")), this.getProperties("COMPONENT_RUN_PROPERTIES", rs.getLong("COMPONENT_RUN_ID"), connection, isRetry), finalState);
                    cr.setEndpointData((Set)endpointData.get(componentRunId));
                    results.add(cr);
                }
                rs.close();
            }
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
        return results;
    }

    public WorkflowRun getWorkflowRun(Long workflowRunId, Connection connection, boolean isRetry) throws SQLException {
        String value;
        Object stmtEndpointProperties;
        ResultSet rs22;
        Object stmt;
        String sql = " SELECT WORKFLOW_RUN.WORKFLOW_RUN_ID , WORKFLOW_RUN.NAME , WORKFLOW_RUN.CONTROLLER_NODE_ID , WORKFLOW_RUN.DATAMANAGEMENT_NODE_ID , TIMELINE_INTERVAL.STARTTIME , TIMELINE_INTERVAL.ENDTIME , WORKFLOW_RUN.FINAL_STATE , WORKFLOW_RUN.WORKFLOW_FILE_REFERENCE FROM APP.WORKFLOW_RUN INNER JOIN APP.TIMELINE_INTERVAL ON TIMELINE_INTERVAL.WORKFLOW_RUN_ID = WORKFLOW_RUN.WORKFLOW_RUN_ID WHERE WORKFLOW_RUN.WORKFLOW_RUN_ID =  ?  AND TIMELINE_INTERVAL.TYPE =  ? ";
        WorkflowRun workflowRun = null;
        Throwable throwable = null;
        Object var7_8 = null;
        try {
            stmt = connection.prepareStatement(sql, 1003, 1007);
            try {
                stmt.setLong(1, workflowRunId);
                stmt.setString(2, TimelineIntervalType.WORKFLOW_RUN.toString());
                rs22 = stmt.executeQuery();
                if (rs22 != null && rs22.next()) {
                    Long endtime = null;
                    if (rs22.getTimestamp("ENDTIME") != null) {
                        endtime = rs22.getTimestamp("ENDTIME").getTime();
                    }
                    FinalWorkflowState finalState = null;
                    if (rs22.getString("FINAL_STATE") != null) {
                        finalState = FinalWorkflowState.valueOf((String)rs22.getString("FINAL_STATE"));
                    }
                    Long wfRunId = rs22.getLong("WORKFLOW_RUN_ID");
                    String wfFileReference = rs22.getString("WORKFLOW_FILE_REFERENCE");
                    workflowRun = new WorkflowRun(wfRunId, rs22.getString("NAME"), rs22.getString("CONTROLLER_NODE_ID").trim(), rs22.getString("DATAMANAGEMENT_NODE_ID").trim(), Long.valueOf(rs22.getTimestamp("STARTTIME").getTime()), endtime, finalState, null, null, this.getProperties("WORKFLOW_RUN_PROPERTIES", workflowRunId, connection, isRetry), wfFileReference);
                    rs22.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (workflowRun == null) {
            return null;
        }
        HashMap endpointProperties = new HashMap();
        String sqlEndpointProperties = " SELECT *  FROM APP.V_ENDPOINT_INSTANCE_PROPERTIES WHERE WORKFLOW_RUN_ID =  ? ";
        stmt = null;
        rs22 = null;
        try {
            stmtEndpointProperties = connection.prepareStatement(sqlEndpointProperties, 1003, 1007);
            try {
                stmtEndpointProperties.setLong(1, workflowRunId);
                ResultSet rsEndpointProperties = stmtEndpointProperties.executeQuery();
                if (rsEndpointProperties != null) {
                    while (rsEndpointProperties.next()) {
                        Long endpointInstanceId = rsEndpointProperties.getLong("ENDPOINT_INSTANCE_ID");
                        String key = rsEndpointProperties.getString("KEY_");
                        value = rsEndpointProperties.getString("VALUE");
                        if (endpointProperties.get(endpointInstanceId) != null) {
                            ((Map)endpointProperties.get(endpointInstanceId)).put(key, value);
                            continue;
                        }
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put(key, value);
                        endpointProperties.put(endpointInstanceId, map);
                    }
                }
                rsEndpointProperties.close();
            }
            finally {
                if (stmtEndpointProperties != null) {
                    stmtEndpointProperties.close();
                }
            }
        }
        catch (Throwable rs22) {
            if (stmt == null) {
                stmt = rs22;
            } else if (stmt != rs22) {
                ((Throwable)stmt).addSuppressed(rs22);
            }
            throw stmt;
        }
        HashMap endpointData = new HashMap();
        String sqlEndpointData = " SELECT COMPONENT_INSTANCE.WORKFLOW_RUN_ID , ENDPOINT_DATA.COMPONENT_RUN_ID , ENDPOINT_DATA.COUNTER , ENDPOINT_INSTANCE.ENDPOINT_INSTANCE_ID , ENDPOINT_INSTANCE.NAME , ENDPOINT_INSTANCE.TYPE AS ENDPOINT_TYPE , TYPED_DATUM.TYPE AS DATUM_TYPE , TYPED_DATUM.VALUE , TYPED_DATUM.BIG_VALUE FROM COMPONENT_INSTANCE , COMPONENT_RUN , ENDPOINT_DATA , ENDPOINT_INSTANCE , TYPED_DATUM WHERE COMPONENT_INSTANCE.COMPONENT_INSTANCE_ID = COMPONENT_RUN.COMPONENT_INSTANCE_ID AND COMPONENT_RUN.COMPONENT_RUN_ID = ENDPOINT_DATA.COMPONENT_RUN_ID AND ENDPOINT_INSTANCE.ENDPOINT_INSTANCE_ID = ENDPOINT_DATA.ENDPOINT_INSTANCE_ID AND TYPED_DATUM.TYPED_DATUM_ID = ENDPOINT_DATA.TYPED_DATUM_ID AND COMPONENT_INSTANCE.WORKFLOW_RUN_ID =  ? ";
        stmtEndpointProperties = null;
        Throwable throwable3 = null;
        try (PreparedStatement stmtEndpointData = connection.prepareStatement(sqlEndpointData, 1003, 1007);){
            stmtEndpointData.setLong(1, workflowRunId);
            ResultSet rsEndpointData = stmtEndpointData.executeQuery();
            if (rsEndpointData != null) {
                while (rsEndpointData.next()) {
                    Long id;
                    value = rsEndpointData.getString("VALUE");
                    if (value == null) {
                        value = rsEndpointData.getString("BIG_VALUE");
                    }
                    if (endpointData.get(id = Long.valueOf(rsEndpointData.getLong("COMPONENT_RUN_ID"))) == null) {
                        endpointData.put(id, new HashSet());
                    }
                    Long endpointInstanceId = rsEndpointData.getLong("ENDPOINT_INSTANCE_ID");
                    ((Set)endpointData.get(id)).add(new EndpointData(new EndpointInstance(rsEndpointData.getString("NAME"), EndpointType.valueOf((String)rsEndpointData.getString("ENDPOINT_TYPE")), (Map)endpointProperties.get(endpointInstanceId)), Integer.valueOf(rsEndpointData.getInt("COUNTER")), value));
                }
                rsEndpointData.close();
            }
        }
        catch (Throwable throwable4) {
            if (stmtEndpointProperties == null) {
                stmtEndpointProperties = throwable4;
            } else if (stmtEndpointProperties != throwable4) {
                ((Throwable)stmtEndpointProperties).addSuppressed(throwable4);
            }
            throw stmtEndpointProperties;
        }
        String sqlComponentRuns = " SELECT *  FROM APP.V_COMPONENT_RUNS WHERE WORKFLOW_RUN_ID =  ? ";
        throwable3 = null;
        Object var12_19 = null;
        try (PreparedStatement stmtComponentRuns = connection.prepareStatement(sqlComponentRuns, 1004, 1007);){
            stmtComponentRuns.setLong(1, workflowRunId);
            ResultSet rsComponentRuns = stmtComponentRuns.executeQuery();
            if (rsComponentRuns != null) {
                while (rsComponentRuns.next()) {
                    Long endtime = null;
                    if (rsComponentRuns.getTimestamp("ENDTIME") != null) {
                        endtime = rsComponentRuns.getTimestamp("ENDTIME").getTime();
                    }
                    ComponentInstance ci = new ComponentInstance(rsComponentRuns.getString("COMPONENT_ID"), rsComponentRuns.getString("COMPONENT_INSTANCE_NAME"), rsComponentRuns.getString("FINAL_STATE"));
                    Long crId = rsComponentRuns.getLong("COMPONENT_RUN_ID");
                    FinalComponentRunState finalState = null;
                    if (rsComponentRuns.getString("COMPONENT_RUN_FINAL_STATE") != null) {
                        finalState = FinalComponentRunState.valueOf((String)rsComponentRuns.getString("COMPONENT_RUN_FINAL_STATE"));
                    }
                    ComponentRun cr = new ComponentRun(Long.valueOf(rsComponentRuns.getLong("COMPONENT_RUN_ID")), rsComponentRuns.getString("NODE_ID").trim(), Integer.valueOf(rsComponentRuns.getInt("COUNTER")), Long.valueOf(rsComponentRuns.getTimestamp("STARTTIME").getTime()), endtime, rsComponentRuns.getString("HISTORY_DATA_ITEM"), Boolean.valueOf(rsComponentRuns.getBoolean("REFERENCES_DELETED")), this.getProperties("COMPONENT_RUN_PROPERTIES", crId, connection, isRetry), finalState);
                    cr.setEndpointData((Set)endpointData.get(crId));
                    workflowRun.addComponentRun(ci, cr);
                }
                rsComponentRuns.close();
            }
        }
        catch (Throwable throwable5) {
            if (throwable3 == null) {
                throwable3 = throwable5;
            } else if (throwable3 != throwable5) {
                throwable3.addSuppressed(throwable5);
            }
            throw throwable3;
        }
        return workflowRun;
    }

    public Set<WorkflowRunDescription> getWorkflowRunDescriptions(Connection connection, boolean isRetry) throws SQLException {
        Map<Long, String> deletionStates = DerbyMetaDataBackendOperationsImpl.getDeletionStates(connection, isRetry);
        String sql = " SELECT WORKFLOW_RUN.WORKFLOW_RUN_ID , WORKFLOW_RUN.NAME , WORKFLOW_RUN.CONTROLLER_NODE_ID , WORKFLOW_RUN.DATAMANAGEMENT_NODE_ID , WORKFLOW_RUN.TO_BE_DELETED , TIMELINE_INTERVAL.STARTTIME , TIMELINE_INTERVAL.ENDTIME , WORKFLOW_RUN.FINAL_STATE FROM APP.WORKFLOW_RUN INNER JOIN APP.TIMELINE_INTERVAL ON TIMELINE_INTERVAL.WORKFLOW_RUN_ID = WORKFLOW_RUN.WORKFLOW_RUN_ID WHERE TIMELINE_INTERVAL.TYPE =  ?  AND TO_BE_DELETED !=  ?  ORDER BY STARTTIME DESC ";
        HashSet<WorkflowRunDescription> results = new HashSet<WorkflowRunDescription>();
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql, 1003, 1007);){
            stmt.setString(1, TimelineIntervalType.WORKFLOW_RUN.toString());
            stmt.setInt(2, 1);
            ResultSet rs = stmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    Long endtime = null;
                    if (rs.getTimestamp("ENDTIME") != null) {
                        endtime = rs.getTimestamp("ENDTIME").getTime();
                    }
                    FinalWorkflowState finalState = null;
                    if (rs.getString("FINAL_STATE") != null) {
                        finalState = FinalWorkflowState.valueOf((String)rs.getString("FINAL_STATE"));
                    }
                    Long wfRunId = rs.getLong("WORKFLOW_RUN_ID");
                    boolean markedForDeletion = rs.getInt("TO_BE_DELETED") != 0;
                    Boolean areFilesDeleted = deletionStates.get(wfRunId) != null && deletionStates.get(wfRunId).equals("DELETED_MANUALLY");
                    results.add(new WorkflowRunDescription(wfRunId, rs.getString("NAME"), rs.getString("CONTROLLER_NODE_ID").trim(), rs.getString("DATAMANAGEMENT_NODE_ID").trim(), Long.valueOf(rs.getTimestamp("STARTTIME").getTime()), endtime, finalState, areFilesDeleted, Boolean.valueOf(markedForDeletion), this.getProperties("WORKFLOW_RUN_PROPERTIES", wfRunId, connection, isRetry)));
                }
                rs.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return results;
    }

    private static Map<Long, String> getDeletionStates(Connection connection, boolean isRetry) throws SQLException {
        String sql = " SELECT WORKFLOW_RUN_ID , VALUE FROM WORKFLOW_RUN_PROPERTIES WHERE KEY_ =  ? ";
        HashMap<Long, String> counts = new HashMap<Long, String>();
        Throwable throwable = null;
        Object var5_6 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setString(1, "FILES_DELETED");
            ResultSet rs = stmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    counts.put(rs.getLong("WORKFLOW_RUN_ID"), rs.getString("VALUE"));
                }
                rs.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return counts;
    }

    public void setComponentInstanceFinalState(Long componentInstanceId, FinalComponentState finalState, Connection connection, boolean isRetry) throws SQLException {
        String sql = " UPDATE APP.COMPONENT_INSTANCE SET FINAL_STATE =  ?  WHERE COMPONENT_INSTANCE_ID =  ? ";
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setString(1, finalState.toString());
            stmt.setLong(2, componentInstanceId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setComponentRunFinished(Long componentRunId, Long endtime, FinalComponentRunState finalState, Connection connection, boolean isRetry) throws SQLException {
        String sql = " UPDATE APP.TIMELINE_INTERVAL SET ENDTIME =  ?  WHERE COMPONENT_RUN_ID =  ?  AND TYPE =  ? ";
        String sql2 = " UPDATE APP.COMPONENT_RUN SET COMPONENT_RUN_FINAL_STATE =  ?  WHERE COMPONENT_RUN_ID =  ? ";
        Throwable throwable = null;
        Object var9_10 = null;
        try {
            PreparedStatement stmt = connection.prepareStatement(sql);
            try {
                try (PreparedStatement stmt2 = connection.prepareStatement(sql2);){
                    stmt.setTimestamp(1, new Timestamp(endtime));
                    stmt.setLong(2, componentRunId);
                    stmt.setString(3, TimelineIntervalType.COMPONENT_RUN.toString());
                    stmt.executeUpdate();
                    stmt2.setString(1, finalState.toString());
                    stmt2.setLong(2, componentRunId);
                    stmt2.executeUpdate();
                }
                if (stmt == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void setWorkflowRunEndtime(Long workflowRunId, Long endtime, Connection connection, boolean isRetry) throws SQLException {
        String sql = " UPDATE APP.TIMELINE_INTERVAL SET ENDTIME =  ?  WHERE WORKFLOW_RUN_ID =  ?  AND TYPE =  ? ";
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setTimestamp(1, new Timestamp(endtime));
            stmt.setLong(2, workflowRunId);
            stmt.setString(3, TimelineIntervalType.WORKFLOW_RUN.toString());
            stmt.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void setWorkflowRunFinalState(Long workflowRunId, FinalWorkflowState finalState, Connection connection, boolean isRetry) throws SQLException {
        String sql = " UPDATE APP.WORKFLOW_RUN SET FINAL_STATE =  ?  WHERE WORKFLOW_RUN_ID =  ? ";
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setString(1, finalState.toString());
            stmt.setLong(2, workflowRunId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void setOrUpdateTimelineDataItem(Long workflowRunId, String timelineDataItem, Connection connection, boolean isRetry) throws SQLException {
        String sql = " UPDATE APP.WORKFLOW_RUN SET TIMELINE_DATA_ITEM =  ?  WHERE WORKFLOW_RUN_ID =  ? ";
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setString(1, timelineDataItem);
            stmt.setLong(2, workflowRunId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Long getWorkflowRunIdByComponentInstanceId(Long componentInstanceId, Connection connection, boolean isRetry) throws SQLException {
        String sql = " SELECT WORKFLOW_RUN.WORKFLOW_RUN_ID FROM APP.WORKFLOW_RUN INNER JOIN COMPONENT_INSTANCE ON COMPONENT_INSTANCE.WORKFLOW_RUN_ID = WORKFLOW_RUN.WORKFLOW_RUN_ID WHERE COMPONENT_INSTANCE.COMPONENT_INSTANCE_ID =  ? ";
        Long id = null;
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql, 1003, 1007);){
            stmt.setLong(1, componentInstanceId);
            ResultSet rs = stmt.executeQuery();
            if (rs != null && rs.next()) {
                id = rs.getLong("WORKFLOW_RUN_ID");
                rs.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return id;
    }

    public void setOrUpdateHistoryDataItem(Long componentRunId, String historyDataItem, Connection connection, boolean isRetry) throws SQLException {
        String sql = " UPDATE APP.COMPONENT_RUN SET HISTORY_DATA_ITEM =  ?  WHERE COMPONENT_RUN_ID =  ? ";
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql);){
            stmt.setString(1, historyDataItem);
            stmt.setLong(2, componentRunId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Integer cleanUpWorkflowRunFinalStates(Connection connection, boolean isRetry) throws SQLException {
        int affectedLines;
        String sql = " UPDATE WORKFLOW_RUN SET FINAL_STATE = '%s' WHERE FINAL_STATE IS NULL ";
        Throwable throwable = null;
        Object var6_6 = null;
        try (Statement stmt = connection.createStatement();){
            affectedLines = stmt.executeUpdate(StringUtils.format((String)sql, (Object[])new Object[]{FinalWorkflowState.CORRUPTED}));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return affectedLines;
    }

    public Map<Long, Integer> getWorkflowRunsToBeDeleted(Connection connection, boolean isRetry) throws SQLException {
        String sql = " SELECT WORKFLOW_RUN_ID , TO_BE_DELETED FROM WORKFLOW_RUN WHERE TO_BE_DELETED !=  ? ";
        HashMap<Long, Integer> wfsToBeDeleted = new HashMap<Long, Integer>();
        Throwable throwable = null;
        Object var6_7 = null;
        try (PreparedStatement stmt = connection.prepareStatement(sql, 1003, 1007);){
            stmt.setInt(1, 0);
            ResultSet rs = stmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    wfsToBeDeleted.put(rs.getLong("WORKFLOW_RUN_ID"), rs.getInt("TO_BE_DELETED"));
                }
                rs.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return wfsToBeDeleted;
    }
}

