/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.internal;

import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.configuration.SecureStorageSection;
import de.rcenvironment.core.configuration.SecureStorageService;
import de.rcenvironment.core.configuration.bootstrap.RuntimeDetection;
import de.rcenvironment.core.configuration.internal.SecureStorageSectionSecurePreferencesImpl;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.utils.common.IdGenerator;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public final class SecureStorageServiceImpl
implements SecureStorageService {
    protected static final String SECURE_SETTINGS_FILE_NAME = "settings.secure.dat";
    protected static final String SECURE_SETTINGS_BACKUP_FILE_NAME = "settings.secure.bak";
    protected static final String KEY_FILE_NAME = "secure_storage_key";
    protected static final String PASSWORD_OVERRIDE_PROPERTY = "rce.overrideSecureStoragePassword";
    private static final int EXPECTED_KEY_LENGTH = 64;
    private ConfigurationService configurationService;
    private File secureStorageFile;
    private File secureStorageBackupFile;
    private ISecurePreferences rootNode;
    private final Log log = LogFactory.getLog(this.getClass());

    @Activate
    protected void activate() throws IOException {
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            return;
        }
        this.initialize();
    }

    public void initialize() throws IOException {
        String storePassword = this.determineStorePassword();
        File profileInternalDir = this.configurationService.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_INTERNAL_DATA);
        this.secureStorageFile = new File(profileInternalDir, SECURE_SETTINGS_FILE_NAME);
        this.secureStorageBackupFile = new File(profileInternalDir, SECURE_SETTINGS_BACKUP_FILE_NAME);
        if (this.secureStorageFile.isFile()) {
            if (this.secureStorageBackupFile.isFile()) {
                Files.delete(this.secureStorageBackupFile.toPath());
            }
            Files.copy(this.secureStorageFile.toPath(), this.secureStorageBackupFile.toPath(), new CopyOption[0]);
        }
        this.rootNode = this.openSecurePreferencesStoreWithPassword(storePassword);
        try {
            this.rootNode.put("writeTest", "RCE Secure Storage", false);
            this.rootNode.flush();
        }
        catch (StorageException storageException) {
            throw new IOException("Test write to Secure Storage failed - aborting startup");
        }
        this.checkExistingEntriesRecursively(this.rootNode);
        this.log.debug((Object)"Secure Storage initialized");
    }

    private void checkExistingEntriesRecursively(ISecurePreferences node) {
        String nodeName = node.name();
        if (nodeName == null) {
            nodeName = "<root>";
        }
        String[] stringArray = node.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            try {
                node.get(key, null);
                this.log.debug((Object)StringUtils.format((String)"Successfully tested decryption of existing entry %s/%s", (Object[])new Object[]{nodeName, key}));
            }
            catch (StorageException e) {
                String formatString = e.getMessage() != null && e.getMessage().contains("bad key") ? "Failed to decrypt existing Secure Storage entry %s/%s as it was written with a different Secure Storage login/password. You can open the Secure Storage file %s (while RCE is not running) and delete the line starting with this entry to remove this warning." : "Failed to decrypt existing Secure Storage entry %s/%s due to an unknown error. You can open the Secure Storage file %s (while RCE is not running) and delete the line beginning with this entry to remove this warning.";
                this.log.warn((Object)StringUtils.format((String)formatString, (Object[])new Object[]{nodeName, key, this.secureStorageFile.getAbsolutePath()}));
            }
            ++n2;
        }
        stringArray = node.childrenNames();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String subNode = stringArray[n2];
            ISecurePreferences section = node.node(subNode);
            this.checkExistingEntriesRecursively(section);
            ++n2;
        }
    }

    @Reference
    protected void bindConfigurationService(ConfigurationService newConfigurationService) {
        this.configurationService = newConfigurationService;
    }

    @Override
    public SecureStorageSection getSecureStorageSection(String sectionId) throws IOException {
        return new SecureStorageSectionSecurePreferencesImpl(sectionId, this.rootNode.node(sectionId));
    }

    private String determineStorePassword() throws IOException {
        String passwordOverrideProperty = System.getProperty(PASSWORD_OVERRIDE_PROPERTY);
        if (passwordOverrideProperty == null) {
            passwordOverrideProperty = System.getenv(PASSWORD_OVERRIDE_PROPERTY);
        }
        if (passwordOverrideProperty != null && !(passwordOverrideProperty = passwordOverrideProperty.trim()).isEmpty()) {
            return passwordOverrideProperty;
        }
        return this.readOrGenerateAutomaticPassword();
    }

    private String readOrGenerateAutomaticPassword() throws IOException {
        File keyFile = new File(this.configurationService.getConfigurablePath(ConfigurationService.ConfigurablePathId.SHARED_USER_SETTINGS_ROOT), KEY_FILE_NAME);
        if (keyFile.exists()) {
            String fileContent = FileUtils.readFileToString((File)keyFile).trim();
            if (fileContent.length() != 64) {
                throw new IOException("Unexpected content in key file " + keyFile.getAbsolutePath() + ": expected an auto-generated password of " + 64 + " characters. You can fix this error by deleting the key file if it is actually broken, " + "or restoring it from a backup if one is available.");
            }
            this.log.debug((Object)"Reusing existing cross-profile keyfile");
            return fileContent;
        }
        String password = IdGenerator.secureRandomHexString((int)64);
        FileUtils.writeStringToFile((File)keyFile, (String)password);
        this.log.debug((Object)"Generated a new cross-profile keyfile");
        return password;
    }

    private ISecurePreferences openSecurePreferencesStoreWithPassword(String password) throws IOException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("org.eclipse.equinox.security.storage.defaultPassword", new PBEKeySpec(password.toCharArray()));
        options.put("org.eclipse.equinox.security.storage.promptUser", false);
        return this.openSecurePreferencesStoreInternal(options);
    }

    private ISecurePreferences openSecurePreferencesStoreInternal(Map<String, Object> options) throws IOException {
        URL secureStorageFileUrl;
        try {
            secureStorageFileUrl = this.secureStorageFile.toURL();
        }
        catch (MalformedURLException e) {
            throw new IOException("Failed to open/unlock the Secure Storage", e);
        }
        ISecurePreferences securePreferences = SecurePreferencesFactory.open((URL)secureStorageFileUrl, options);
        if (securePreferences == null) {
            throw new IOException("Failed to open/unlock the Secure Storage: received a null reference");
        }
        return securePreferences;
    }
}

