/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.datamanagement.stateful;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.component.datamanagement.stateful.StatefulComponentDataManagementService;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TempFileMockComponentDataManagementService
implements StatefulComponentDataManagementService {
    private static Log log = LogFactory.getLog(TempFileMockComponentDataManagementService.class);
    private TempFileService tempFileService = TempFileServiceAccess.getInstance();

    @Override
    public void copyReferenceToLocalFile(String reference, File targetFile, Collection<NetworkDestination> platforms) throws IOException {
        FileUtils.copyFile((File)new File(reference), (File)targetFile, (boolean)false);
    }

    @Override
    public void copyReferenceToLocalFile(String reference, File targetFile, NetworkDestination platform) throws IOException {
        FileUtils.copyFile((File)new File(reference), (File)targetFile, (boolean)false);
    }

    @Override
    public String retrieveStringFromReference(String reference, InstanceNodeSessionId nodeId) throws IOException {
        return FileUtils.readFileToString((File)new File(reference));
    }

    @Override
    public String createTaggedReferenceFromLocalFile(File file, String filename) throws IOException {
        File tmpFile = this.tempFileService.createTempFileFromPattern("DMMock-" + file.getName() + "-*.tmp");
        FileUtils.copyFile((File)file, (File)tmpFile, (boolean)false);
        String reference = tmpFile.getAbsolutePath();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created reference " + reference + " for local file " + file.getAbsolutePath()));
        }
        return reference;
    }

    @Override
    public String createTaggedReferenceFromString(String object) throws IOException {
        File tmpFile = this.tempFileService.createTempFileFromPattern("DMMock-*.tmp");
        FileUtils.writeStringToFile((File)tmpFile, (String)object);
        String reference = tmpFile.getAbsolutePath();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created reference " + reference + " for String"));
        }
        return reference;
    }

    @Override
    public void addHistoryDataPoint(Serializable historyData, String userInfoText) throws IOException {
    }

    @Override
    public FileReferenceTD createFileReferenceTDFromLocalFile(File file, String filename) throws IOException {
        return null;
    }

    @Override
    public DirectoryReferenceTD createDirectoryReferenceTDFromLocalDirectory(File dir, String dirname) throws IOException {
        return null;
    }

    @Override
    public void copyFileReferenceTDToLocalFile(FileReferenceTD fileReference, File targetFile, InstanceNodeSessionId node) throws IOException {
    }

    @Override
    public void copyDirectoryReferenceTDToLocalDirectory(DirectoryReferenceTD dirReference, File targetDir, InstanceNodeSessionId node) throws IOException {
    }
}

