/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.transport.jms.common;

import de.rcenvironment.core.communication.channel.MessageChannelIdFactory;
import de.rcenvironment.core.communication.channel.ServerContactPoint;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.communication.model.InitialNodeInformation;
import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.transport.jms.common.JMSHandshakeInformation;
import de.rcenvironment.core.communication.transport.jms.common.JmsArtifactFactory;
import de.rcenvironment.core.communication.transport.jms.common.JmsBroker;
import de.rcenvironment.core.communication.transport.jms.common.JmsMessageChannel;
import de.rcenvironment.core.communication.transport.jms.common.RemoteInitiatedJmsMessageChannel;
import de.rcenvironment.core.communication.transport.jms.common.RemoteInitiatedMessageChannelFactory;
import de.rcenvironment.core.communication.transport.jms.common.RequestResponseQueuesManager;
import de.rcenvironment.core.communication.transport.jms.common.SelfInitiatedJmsMessageChannel;
import de.rcenvironment.core.communication.transport.spi.BrokenMessageChannelListener;
import de.rcenvironment.core.communication.transport.spi.HandshakeInformation;
import de.rcenvironment.core.communication.transport.spi.MessageChannel;
import de.rcenvironment.core.communication.transport.spi.MessageChannelEndpointHandler;
import de.rcenvironment.core.communication.transport.spi.NetworkTransportProvider;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractJmsTransportProvider
implements NetworkTransportProvider {
    protected final Map<ServerContactPoint, JmsBroker> serverEndpoints = new HashMap<ServerContactPoint, JmsBroker>();
    protected final MessageChannelIdFactory connectionIdFactory;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final AsyncTaskService threadPool = ConcurrencyUtils.getAsyncTaskService();
    protected final JmsArtifactFactory artifactFactory;

    public AbstractJmsTransportProvider(MessageChannelIdFactory connectionIdFactory, JmsArtifactFactory artifactFactory) {
        this.connectionIdFactory = connectionIdFactory;
        this.artifactFactory = artifactFactory;
    }

    public MessageChannel connect(NetworkContactPoint ncp, InitialNodeInformation ownNodeInformation, String ownProtocolVersion, boolean allowInverseConnection, MessageChannelEndpointHandler inverseConnectionEndpointHandler, BrokenMessageChannelListener brokenConnectionListener) throws CommunicationException {
        SelfInitiatedJmsMessageChannel newChannel = null;
        try {
            try {
                ConnectionFactory connectionFactory = this.artifactFactory.createConnectionFactory(ncp);
                InstanceNodeSessionId localNodeId = ownNodeInformation.getInstanceNodeSessionId();
                newChannel = new SelfInitiatedJmsMessageChannel(localNodeId, connectionFactory, brokenConnectionListener);
                newChannel.setChannelId(this.connectionIdFactory.generateId(true));
                newChannel.connectToJmsBroker();
                this.log.debug((Object)("Connected to JMS broker; sending initial handshake with identity '" + localNodeId + "'"));
                JMSHandshakeInformation ownHandshakeInformation = new JMSHandshakeInformation();
                ownHandshakeInformation.setProtocolVersionString(ownProtocolVersion);
                ownHandshakeInformation.setInitialNodeInformation(ownNodeInformation);
                ownHandshakeInformation.setChannelId(newChannel.getChannelId());
                HandshakeInformation remoteHandshakeInformation = newChannel.performInitialHandshake(ownHandshakeInformation, inverseConnectionEndpointHandler);
                InitialNodeInformation remoteNodeInformation = remoteHandshakeInformation.getInitialNodeInformation();
                newChannel.setRemoteNodeInformation(remoteNodeInformation);
                this.log.debug((Object)("Successfully performed JMS handshake with remote node " + remoteNodeInformation.getLogDescription()));
                if (remoteNodeInformation.getInstanceNodeSessionId().isSameInstanceNodeAs((ResolvableNodeId)localNodeId)) {
                    throw new CommunicationException("Invalid setup: Remote and local node share the same instance node id: " + localNodeId.getInstanceNodeIdString());
                }
                newChannel.markAsEstablished();
                return newChannel;
            }
            catch (IOException e) {
                throw new CommunicationException("Failed to initiate JMS connection", (Throwable)e);
            }
            catch (RuntimeException e) {
                throw new CommunicationException("Failed to establish JMS connection", (Throwable)e);
            }
            catch (JMSException e) {
                throw new CommunicationException("Failed to establish JMS connection. Reason: " + e.toString());
            }
            catch (TimeoutException e) {
                throw new CommunicationException("Timeout while establishing JMS connection", (Throwable)e);
            }
        }
        catch (CommunicationException e) {
            if (newChannel != null) {
                newChannel.onClosedOrBroken();
            }
            throw e;
        }
    }

    public boolean supportsRemoteInitiatedConnections() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer(ServerContactPoint scp) throws CommunicationException {
        JmsBroker broker = this.artifactFactory.createBroker(scp, new RemoteInitiatedMessageChannelFactoryImpl());
        try {
            broker.start();
        }
        catch (Exception e) {
            throw new CommunicationException("Failed to start JMS broker for SCP " + scp, (Throwable)e);
        }
        Map<ServerContactPoint, JmsBroker> map = this.serverEndpoints;
        synchronized (map) {
            this.serverEndpoints.put(scp, broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer(ServerContactPoint scp) {
        JmsBroker broker;
        Map<ServerContactPoint, JmsBroker> map = this.serverEndpoints;
        synchronized (map) {
            broker = this.serverEndpoints.get(scp);
        }
        broker.stop();
    }

    public class RemoteInitiatedMessageChannelFactoryImpl
    implements RemoteInitiatedMessageChannelFactory {
        @Override
        public JmsMessageChannel createRemoteInitiatedMessageChannel(InitialNodeInformation receivingNodeInformation, JMSHandshakeInformation remoteHandshakeInformation, JMSHandshakeInformation ownHandshakeInformation, ServerContactPoint associatedSCP, Connection localJmsConnection, Session session) throws JMSException, ProtocolException {
            InitialNodeInformation remoteNodeInformation = remoteHandshakeInformation.getInitialNodeInformation();
            String connectionId = AbstractJmsTransportProvider.this.connectionIdFactory.generateId(false);
            RemoteInitiatedJmsMessageChannel remoteInitiatedConnection = new RemoteInitiatedJmsMessageChannel(receivingNodeInformation.getInstanceNodeSessionId(), localJmsConnection, associatedSCP);
            remoteInitiatedConnection.setRemoteNodeInformation(remoteNodeInformation);
            remoteInitiatedConnection.setAssociatedMirrorChannelId(remoteHandshakeInformation.getChannelId());
            remoteInitiatedConnection.setShutdownSecurityToken("passive." + remoteNodeInformation.getInstanceNodeSessionIdString());
            remoteInitiatedConnection.setChannelId(connectionId);
            remoteInitiatedConnection.setInitiatedByRemote(true);
            RequestResponseQueuesManager tempQueueManager = new RequestResponseQueuesManager();
            String serverQueueInfo = tempQueueManager.initServerSide(session, remoteHandshakeInformation.getTemporaryQueueInformation());
            ownHandshakeInformation.setTemporaryQueueInformation(serverQueueInfo);
            String outgoingRequestQueueName = tempQueueManager.getB2CRequestQueue();
            String incomingResponseQueueName = tempQueueManager.getB2CResponseQueue();
            remoteInitiatedConnection.setupNonBlockingRequestSending(outgoingRequestQueueName, incomingResponseQueueName);
            return remoteInitiatedConnection;
        }
    }
}

