/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.internal;

import de.rcenvironment.core.configuration.ConfigurationException;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.core.utils.common.osgi.BundleUtils;
import java.io.File;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class UnpackedFilesDirectoryResolver {
    public static final String MANIFEST_PROPERTY_FILESET_ID = "RCE-Unpacked-Fileset-Id";
    public static final String MANIFEST_PROPERTY_BUNDLE_RELATIVE_PATH = "RCE-Unpacked-Fileset-Path";
    public static final String MANIFEST_PROPERTY_PRESENCE_CHECK_TEST_FILE = "RCE-Unpacked-Fileset-Presence-Test-File";
    private final BundleContext bundleContext;
    private final Map<String, File> resolutionCache = new HashMap<String, File>();
    private final File installationRootPath;

    public UnpackedFilesDirectoryResolver(BundleContext context, File installationRootPath) {
        this.bundleContext = context;
        this.installationRootPath = installationRootPath;
    }

    public synchronized File resolveIdToUnpackedFilesDirectory(String id) throws ConfigurationException {
        Objects.requireNonNull(id);
        if (this.resolutionCache.containsKey(id)) {
            File cached = this.resolutionCache.get(id);
            if (cached == null) {
                throw new ConfigurationException("This fileset was previously requested, and a lookup failure was cached; check the log file for the initial reason");
            }
            return cached;
        }
        return this.performLookup(id);
    }

    private File performLookup(String filesetId) throws ConfigurationException {
        Bundle bundleCandidate = this.findMatchingBundle(filesetId);
        File resolvedPath = this.resolvePath(filesetId, bundleCandidate);
        this.resolutionCache.put(filesetId, resolvedPath);
        return resolvedPath;
    }

    private File resolvePath(String lookupId, Bundle bundleCandidate) throws ConfigurationException {
        File absoluteBundleLocation;
        Log log = LogFactory.getLog(this.getClass());
        try {
            absoluteBundleLocation = BundleUtils.resolveAbsolutePathToUnpackedBundle((Bundle)bundleCandidate, (File)this.installationRootPath);
        }
        catch (OperationFailureException e) {
            throw new ConfigurationException(e.getMessage());
        }
        String symbolicName = bundleCandidate.getSymbolicName();
        String relativePathValue = (String)bundleCandidate.getHeaders().get(MANIFEST_PROPERTY_BUNDLE_RELATIVE_PATH);
        if (StringUtils.isNullorEmpty((String)relativePathValue)) {
            throw new ConfigurationException("Missing or empty header entry RCE-Unpacked-Fileset-Path in bundle " + symbolicName);
        }
        File resolvedPath = new File(absoluteBundleLocation, relativePathValue);
        if (!resolvedPath.isDirectory()) {
            throw new ConfigurationException(StringUtils.format((String)"Resolved file set id '%s' to bundle '%s', but the resulting path '%s' does not point to an existing directory", (Object[])new Object[]{lookupId, symbolicName, resolvedPath}));
        }
        String presenceCheckTestFilePath = (String)bundleCandidate.getHeaders().get(MANIFEST_PROPERTY_PRESENCE_CHECK_TEST_FILE);
        if (!StringUtils.isNullorEmpty((String)presenceCheckTestFilePath)) {
            File presenceCheckTestFile = new File(resolvedPath, presenceCheckTestFilePath);
            if (!presenceCheckTestFile.isFile() || !presenceCheckTestFile.canRead()) {
                throw new ConfigurationException(StringUtils.format((String)"Resolved file set id '%s' to path '%s', but the configured test file '%s' does not exist or cannot be read", (Object[])new Object[]{lookupId, resolvedPath, presenceCheckTestFile.getAbsolutePath()}));
            }
        } else {
            log.warn((Object)("No presence check file configured for unpacked file set " + lookupId + "; skipping check"));
        }
        log.debug((Object)StringUtils.format((String)"Resolved file set id '%s' to path '%s' in bundle '%s'", (Object[])new Object[]{lookupId, resolvedPath, symbolicName}));
        return resolvedPath;
    }

    private Bundle findMatchingBundle(String filesetId) throws ConfigurationException {
        Bundle bundleCandidate = null;
        Bundle[] bundleArray = this.bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Dictionary headers;
            String bundleIdCandidate;
            Bundle bundle = bundleArray[n2];
            if (bundle.getState() == 4 && filesetId.equals(bundleIdCandidate = (String)(headers = bundle.getHeaders()).get(MANIFEST_PROPERTY_FILESET_ID))) {
                if (bundleCandidate != null) {
                    throw new ConfigurationException("More than one resolved bundle declares file set id " + filesetId + "; check for proper platform (e.g. OS) filters");
                }
                bundleCandidate = bundle;
            }
            ++n2;
        }
        if (bundleCandidate == null) {
            throw new ConfigurationException("No resolved bundle declaring file set id " + filesetId + " found");
        }
        return bundleCandidate;
    }
}

