/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.palette.view;

import de.rcenvironment.core.gui.palette.toolidentification.ToolType;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.PaletteTreeNode;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class PaletteTreeViewerComparator
extends ViewerComparator {
    public static final int SORT_BY_NAME_ASC = 1;
    public static final int SORT_BY_NAME_DESC = -1;
    private static final String PREFIX_UNDERSCORE = "_";
    private int direction = 1;

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int getDirection() {
        return this.direction;
    }

    public int category(Object element) {
        if (element instanceof PaletteTreeNode) {
            PaletteTreeNode node = (PaletteTreeNode)element;
            if (this.isTopLevelEditorToolTool(node)) {
                return 0;
            }
            if (node.getPaletteParent().isRoot() && !this.isPredefinedTopLevelGroup(node) || node.getNodeName().startsWith(PREFIX_UNDERSCORE)) {
                return 3;
            }
            if (node.isGroup()) {
                return 2;
            }
        }
        return 1;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (!(e1 instanceof PaletteTreeNode) || !(e2 instanceof PaletteTreeNode)) {
            return 0;
        }
        if (this.category(e1) != this.category(e2)) {
            return this.category(e1) - this.category(e2);
        }
        PaletteTreeNode p1 = (PaletteTreeNode)e1;
        PaletteTreeNode p2 = (PaletteTreeNode)e2;
        if (this.isTopLevelEditorToolTool(p1) && this.isTopLevelEditorToolTool(p2)) {
            return 0;
        }
        if (this.isPredefinedTopLevelGroup(p1) && this.isPredefinedTopLevelGroup(p2)) {
            return p1.compareTo(p2);
        }
        if (p1.isGroup() && p2.isGroup()) {
            return p1.compareTo(p2) * this.direction;
        }
        return p1.compareTo(p2);
    }

    private boolean isTopLevelEditorToolTool(PaletteTreeNode node) {
        if (!node.getPaletteParent().isRoot()) {
            return false;
        }
        return node.isCreationTool();
    }

    private boolean isPredefinedTopLevelGroup(PaletteTreeNode node) {
        if (!node.isGroup() || !node.getPaletteParent().isRoot()) {
            return false;
        }
        return ToolType.getTopLevelGroupNames().contains(node.getDisplayName());
    }
}

