/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.parametricstudy.common.internal;

import de.rcenvironment.components.parametricstudy.common.Study;
import de.rcenvironment.components.parametricstudy.common.StudyReceiver;
import de.rcenvironment.components.parametricstudy.common.internal.ParametricStudyUtils;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.notification.DistributedNotificationService;
import de.rcenvironment.core.notification.NotificationSubscriber;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public final class StudyReceiverImpl
implements StudyReceiver {
    private static final long serialVersionUID = -6079120096252508794L;
    private static final int MINUS_ONE = -1;
    private final Study study;
    private final ResolvableNodeId platform;
    private NotificationSubscriber notificationSubscriber;
    private DistributedNotificationService notificationService;

    public StudyReceiverImpl(Study study, ResolvableNodeId platform, DistributedNotificationService notificationService) {
        this.study = study;
        this.platform = platform;
        this.notificationService = notificationService;
    }

    @Override
    public Study getStudy() {
        return this.study;
    }

    @Override
    public void setNotificationSubscriber(NotificationSubscriber notificationSubscriber) {
        this.notificationSubscriber = notificationSubscriber;
    }

    @Override
    public void initialize() {
        Long missedNumber;
        String notificationId = ParametricStudyUtils.createDataIdentifier(this.study);
        try {
            missedNumber = (Long)this.notificationService.subscribe(notificationId, this.notificationSubscriber, this.platform).get(notificationId);
        }
        catch (RemoteOperationException e) {
            LogFactory.getLog(this.getClass()).error((Object)("Failed to subscribe for Parametric Study data source: " + e.getMessage()));
            return;
        }
        if (missedNumber > -1L) {
            if (missedNumber > 9999L) {
                missedNumber = new Long(9999L);
            }
            try {
                List missedNotifications = ((List)this.notificationService.getNotifications(notificationId, this.platform).get(notificationId)).subList(0, missedNumber.intValue() + 1);
                this.notificationSubscriber.receiveBatchedNotifications(missedNotifications);
            }
            catch (RemoteOperationException e) {
                LogFactory.getLog(this.getClass()).warn((Object)("Failed to send notifications: " + e.toString()));
            }
        }
    }
}

