/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.eventlog.backends.api;

import de.rcenvironment.core.eventlog.backends.api.EventLogBackend;
import de.rcenvironment.core.eventlog.internal.EventLogEntryImpl;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.TreeMap;

public class EventLogCompactJsonFileBackend
extends EventLogBackend {
    private static final String JSON_KEY_EVENT_TYPE_ID = "_t";
    private static final String JSON_KEY_MSEC_EPOCH_TIMESTAMP = "_ts";
    private final BufferedWriter writer;

    public EventLogCompactJsonFileBackend(Path filePath) throws IOException {
        this.writer = Files.newBufferedWriter(filePath, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
    }

    @Override
    public void append(EventLogEntryImpl logEntry) throws IOException {
        TreeMap<String, String> orderedFields = new TreeMap<String, String>();
        orderedFields.put(JSON_KEY_EVENT_TYPE_ID, logEntry.getEventTypeId());
        orderedFields.put(JSON_KEY_MSEC_EPOCH_TIMESTAMP, Long.toString(logEntry.getTimestamp().toEpochMilli()));
        orderedFields.putAll(logEntry.getAttributeData());
        String jsonString = EventLogEntryImpl.generateCompactJsonString(orderedFields);
        this.writer.append(jsonString);
        this.writer.newLine();
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

