/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.workflow.command;

import java.util.Objects;
import java.util.Optional;

final class ParseResult<T> {
    private Optional<T> result;
    private String errorMessages;

    private ParseResult() {
    }

    public static <T> ParseResult<T> createSuccessfulResult(T value) {
        Objects.requireNonNull(value);
        ParseResult<T> product = new ParseResult<T>();
        product.result = Optional.of(value);
        return product;
    }

    public static <T> ParseResult<T> createErrorResult(String displayMessage) {
        Objects.requireNonNull(displayMessage);
        ParseResult<T> product = new ParseResult<T>();
        product.result = Optional.empty();
        product.errorMessages = displayMessage;
        return product;
    }

    public boolean isSuccessfulResult() {
        return this.result.isPresent();
    }

    public boolean isErrorResult() {
        return !this.result.isPresent();
    }

    public T getResult() {
        return this.result.get();
    }

    public String getErrorDisplayMessage() {
        return this.errorMessages;
    }
}

